<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Sales.BulkEditBasketItems.Request StructType
 * @subpackage Structs
 */
class BizAction_Sales_BulkEditBasketItems_Request extends AnyEntity
{
    /**
     * The AvilablePriceTypes
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfSales_PriceType
     */
    public $AvilablePriceTypes;
    /**
     * The canChangePriceType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $canChangePriceType;
    /**
     * The CollectionMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CollectionMethod;
    /**
     * The CollectionTarget
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CollectionTarget;
    /**
     * The ComplimentaryConfirmByKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ComplimentaryConfirmByKey;
    /**
     * The EventsIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventsIds;
    /**
     * The IsAllItemsOfTheSameProductType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAllItemsOfTheSameProductType;
    /**
     * The IsAllItemsOfTypeTicket
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAllItemsOfTypeTicket;
    /**
     * The IsExistingConfirmedItems
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsExistingConfirmedItems;
    /**
     * The IsExistingDeliveryItems
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsExistingDeliveryItems;
    /**
     * The IsExistingSubscriptionItems
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsExistingSubscriptionItems;
    /**
     * The isFollowUp
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $isFollowUp;
    /**
     * The IsUpdateCollectionMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsUpdateCollectionMethod;
    /**
     * The IsUpdateComplimentaryConfirmByKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsUpdateComplimentaryConfirmByKey;
    /**
     * The IsUpdateItemNote
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsUpdateItemNote;
    /**
     * The IsUpdateOwnerClientId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsUpdateOwnerClientId;
    /**
     * The IsUpdatePrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsUpdatePrice;
    /**
     * The IsUpdatePriceTypeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsUpdatePriceTypeId;
    /**
     * The IsUpdateReservationExpiryDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsUpdateReservationExpiryDate;
    /**
     * The IsUpdateSalesRepresentativeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsUpdateSalesRepresentativeId;
    /**
     * The IsUpdateSaleStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsUpdateSaleStatus;
    /**
     * The IsUpdateSubscriptionInstanceId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsUpdateSubscriptionInstanceId;
    /**
     * The ItemNote
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ItemNote;
    /**
     * The Items
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfSales_BulkEditItemInformation
     */
    public $Items;
    /**
     * The OwnerClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OwnerClientId;
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Price;
    /**
     * The PriceTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceTypeId;
    /**
     * The ReservationExpiryDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReservationExpiryDate;
    /**
     * The SalesRepresentativeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SalesRepresentativeId;
    /**
     * The SaleStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SaleStatus;
    /**
     * The ShouldDisplayPriceType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ShouldDisplayPriceType;
    /**
     * The SubscriptionInstanceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SubscriptionInstanceId;
    /**
     * The TransactionClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionClientId;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * Constructor method for BizAction.Sales.BulkEditBasketItems.Request
     * @uses BizAction_Sales_BulkEditBasketItems_Request::setAvilablePriceTypes()
     * @uses BizAction_Sales_BulkEditBasketItems_Request::setCanChangePriceType()
     * @uses BizAction_Sales_BulkEditBasketItems_Request::setCollectionMethod()
     * @uses BizAction_Sales_BulkEditBasketItems_Request::setCollectionTarget()
     * @uses BizAction_Sales_BulkEditBasketItems_Request::setComplimentaryConfirmByKey()
     * @uses BizAction_Sales_BulkEditBasketItems_Request::setEventsIds()
     * @uses BizAction_Sales_BulkEditBasketItems_Request::setIsAllItemsOfTheSameProductType()
     * @uses BizAction_Sales_BulkEditBasketItems_Request::setIsAllItemsOfTypeTicket()
     * @uses BizAction_Sales_BulkEditBasketItems_Request::setIsExistingConfirmedItems()
     * @uses BizAction_Sales_BulkEditBasketItems_Request::setIsExistingDeliveryItems()
     * @uses BizAction_Sales_BulkEditBasketItems_Request::setIsExistingSubscriptionItems()
     * @uses BizAction_Sales_BulkEditBasketItems_Request::setIsFollowUp()
     * @uses BizAction_Sales_BulkEditBasketItems_Request::setIsUpdateCollectionMethod()
     * @uses BizAction_Sales_BulkEditBasketItems_Request::setIsUpdateComplimentaryConfirmByKey()
     * @uses BizAction_Sales_BulkEditBasketItems_Request::setIsUpdateItemNote()
     * @uses BizAction_Sales_BulkEditBasketItems_Request::setIsUpdateOwnerClientId()
     * @uses BizAction_Sales_BulkEditBasketItems_Request::setIsUpdatePrice()
     * @uses BizAction_Sales_BulkEditBasketItems_Request::setIsUpdatePriceTypeId()
     * @uses BizAction_Sales_BulkEditBasketItems_Request::setIsUpdateReservationExpiryDate()
     * @uses BizAction_Sales_BulkEditBasketItems_Request::setIsUpdateSalesRepresentativeId()
     * @uses BizAction_Sales_BulkEditBasketItems_Request::setIsUpdateSaleStatus()
     * @uses BizAction_Sales_BulkEditBasketItems_Request::setIsUpdateSubscriptionInstanceId()
     * @uses BizAction_Sales_BulkEditBasketItems_Request::setItemNote()
     * @uses BizAction_Sales_BulkEditBasketItems_Request::setItems()
     * @uses BizAction_Sales_BulkEditBasketItems_Request::setOwnerClientId()
     * @uses BizAction_Sales_BulkEditBasketItems_Request::setPrice()
     * @uses BizAction_Sales_BulkEditBasketItems_Request::setPriceTypeId()
     * @uses BizAction_Sales_BulkEditBasketItems_Request::setReservationExpiryDate()
     * @uses BizAction_Sales_BulkEditBasketItems_Request::setSalesRepresentativeId()
     * @uses BizAction_Sales_BulkEditBasketItems_Request::setSaleStatus()
     * @uses BizAction_Sales_BulkEditBasketItems_Request::setShouldDisplayPriceType()
     * @uses BizAction_Sales_BulkEditBasketItems_Request::setSubscriptionInstanceId()
     * @uses BizAction_Sales_BulkEditBasketItems_Request::setTransactionClientId()
     * @uses BizAction_Sales_BulkEditBasketItems_Request::setTransactionGuid()
     * @param \patest\StructType\RecordSetOfSales_PriceType $avilablePriceTypes
     * @param bool $canChangePriceType
     * @param string $collectionMethod
     * @param string $collectionTarget
     * @param string $complimentaryConfirmByKey
     * @param string $eventsIds
     * @param bool $isAllItemsOfTheSameProductType
     * @param bool $isAllItemsOfTypeTicket
     * @param bool $isExistingConfirmedItems
     * @param bool $isExistingDeliveryItems
     * @param bool $isExistingSubscriptionItems
     * @param bool $isFollowUp
     * @param bool $isUpdateCollectionMethod
     * @param bool $isUpdateComplimentaryConfirmByKey
     * @param bool $isUpdateItemNote
     * @param bool $isUpdateOwnerClientId
     * @param bool $isUpdatePrice
     * @param bool $isUpdatePriceTypeId
     * @param bool $isUpdateReservationExpiryDate
     * @param bool $isUpdateSalesRepresentativeId
     * @param bool $isUpdateSaleStatus
     * @param bool $isUpdateSubscriptionInstanceId
     * @param string $itemNote
     * @param \patest\StructType\RecordSetOfSales_BulkEditItemInformation $items
     * @param string $ownerClientId
     * @param float $price
     * @param string $priceTypeId
     * @param string $reservationExpiryDate
     * @param string $salesRepresentativeId
     * @param string $saleStatus
     * @param bool $shouldDisplayPriceType
     * @param string $subscriptionInstanceId
     * @param string $transactionClientId
     * @param string $transactionGuid
     */
    public function __construct(\patest\StructType\RecordSetOfSales_PriceType $avilablePriceTypes = null, $canChangePriceType = null, $collectionMethod = null, $collectionTarget = null, $complimentaryConfirmByKey = null, $eventsIds = null, $isAllItemsOfTheSameProductType = null, $isAllItemsOfTypeTicket = null, $isExistingConfirmedItems = null, $isExistingDeliveryItems = null, $isExistingSubscriptionItems = null, $isFollowUp = null, $isUpdateCollectionMethod = null, $isUpdateComplimentaryConfirmByKey = null, $isUpdateItemNote = null, $isUpdateOwnerClientId = null, $isUpdatePrice = null, $isUpdatePriceTypeId = null, $isUpdateReservationExpiryDate = null, $isUpdateSalesRepresentativeId = null, $isUpdateSaleStatus = null, $isUpdateSubscriptionInstanceId = null, $itemNote = null, \patest\StructType\RecordSetOfSales_BulkEditItemInformation $items = null, $ownerClientId = null, $price = null, $priceTypeId = null, $reservationExpiryDate = null, $salesRepresentativeId = null, $saleStatus = null, $shouldDisplayPriceType = null, $subscriptionInstanceId = null, $transactionClientId = null, $transactionGuid = null)
    {
        $this
            ->setAvilablePriceTypes($avilablePriceTypes)
            ->setCanChangePriceType($canChangePriceType)
            ->setCollectionMethod($collectionMethod)
            ->setCollectionTarget($collectionTarget)
            ->setComplimentaryConfirmByKey($complimentaryConfirmByKey)
            ->setEventsIds($eventsIds)
            ->setIsAllItemsOfTheSameProductType($isAllItemsOfTheSameProductType)
            ->setIsAllItemsOfTypeTicket($isAllItemsOfTypeTicket)
            ->setIsExistingConfirmedItems($isExistingConfirmedItems)
            ->setIsExistingDeliveryItems($isExistingDeliveryItems)
            ->setIsExistingSubscriptionItems($isExistingSubscriptionItems)
            ->setIsFollowUp($isFollowUp)
            ->setIsUpdateCollectionMethod($isUpdateCollectionMethod)
            ->setIsUpdateComplimentaryConfirmByKey($isUpdateComplimentaryConfirmByKey)
            ->setIsUpdateItemNote($isUpdateItemNote)
            ->setIsUpdateOwnerClientId($isUpdateOwnerClientId)
            ->setIsUpdatePrice($isUpdatePrice)
            ->setIsUpdatePriceTypeId($isUpdatePriceTypeId)
            ->setIsUpdateReservationExpiryDate($isUpdateReservationExpiryDate)
            ->setIsUpdateSalesRepresentativeId($isUpdateSalesRepresentativeId)
            ->setIsUpdateSaleStatus($isUpdateSaleStatus)
            ->setIsUpdateSubscriptionInstanceId($isUpdateSubscriptionInstanceId)
            ->setItemNote($itemNote)
            ->setItems($items)
            ->setOwnerClientId($ownerClientId)
            ->setPrice($price)
            ->setPriceTypeId($priceTypeId)
            ->setReservationExpiryDate($reservationExpiryDate)
            ->setSalesRepresentativeId($salesRepresentativeId)
            ->setSaleStatus($saleStatus)
            ->setShouldDisplayPriceType($shouldDisplayPriceType)
            ->setSubscriptionInstanceId($subscriptionInstanceId)
            ->setTransactionClientId($transactionClientId)
            ->setTransactionGuid($transactionGuid);
    }
    /**
     * Get AvilablePriceTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfSales_PriceType|null
     */
    public function getAvilablePriceTypes()
    {
        return isset($this->AvilablePriceTypes) ? $this->AvilablePriceTypes : null;
    }
    /**
     * Set AvilablePriceTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfSales_PriceType $avilablePriceTypes
     * @return \patest\StructType\BizAction_Sales_BulkEditBasketItems_Request
     */
    public function setAvilablePriceTypes(\patest\StructType\RecordSetOfSales_PriceType $avilablePriceTypes = null)
    {
        if (is_null($avilablePriceTypes) || (is_array($avilablePriceTypes) && empty($avilablePriceTypes))) {
            unset($this->AvilablePriceTypes);
        } else {
            $this->AvilablePriceTypes = $avilablePriceTypes;
        }
        return $this;
    }
    /**
     * Get canChangePriceType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanChangePriceType()
    {
        return isset($this->canChangePriceType) ? $this->canChangePriceType : null;
    }
    /**
     * Set canChangePriceType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canChangePriceType
     * @return \patest\StructType\BizAction_Sales_BulkEditBasketItems_Request
     */
    public function setCanChangePriceType($canChangePriceType = null)
    {
        // validation for constraint: boolean
        if (!is_null($canChangePriceType) && !is_bool($canChangePriceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canChangePriceType, true), gettype($canChangePriceType)), __LINE__);
        }
        if (is_null($canChangePriceType) || (is_array($canChangePriceType) && empty($canChangePriceType))) {
            unset($this->canChangePriceType);
        } else {
            $this->canChangePriceType = $canChangePriceType;
        }
        return $this;
    }
    /**
     * Get CollectionMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCollectionMethod()
    {
        return isset($this->CollectionMethod) ? $this->CollectionMethod : null;
    }
    /**
     * Set CollectionMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $collectionMethod
     * @return \patest\StructType\BizAction_Sales_BulkEditBasketItems_Request
     */
    public function setCollectionMethod($collectionMethod = null)
    {
        // validation for constraint: string
        if (!is_null($collectionMethod) && !is_string($collectionMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($collectionMethod, true), gettype($collectionMethod)), __LINE__);
        }
        if (is_null($collectionMethod) || (is_array($collectionMethod) && empty($collectionMethod))) {
            unset($this->CollectionMethod);
        } else {
            $this->CollectionMethod = $collectionMethod;
        }
        return $this;
    }
    /**
     * Get CollectionTarget value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCollectionTarget()
    {
        return isset($this->CollectionTarget) ? $this->CollectionTarget : null;
    }
    /**
     * Set CollectionTarget value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $collectionTarget
     * @return \patest\StructType\BizAction_Sales_BulkEditBasketItems_Request
     */
    public function setCollectionTarget($collectionTarget = null)
    {
        // validation for constraint: string
        if (!is_null($collectionTarget) && !is_string($collectionTarget)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($collectionTarget, true), gettype($collectionTarget)), __LINE__);
        }
        if (is_null($collectionTarget) || (is_array($collectionTarget) && empty($collectionTarget))) {
            unset($this->CollectionTarget);
        } else {
            $this->CollectionTarget = $collectionTarget;
        }
        return $this;
    }
    /**
     * Get ComplimentaryConfirmByKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getComplimentaryConfirmByKey()
    {
        return isset($this->ComplimentaryConfirmByKey) ? $this->ComplimentaryConfirmByKey : null;
    }
    /**
     * Set ComplimentaryConfirmByKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $complimentaryConfirmByKey
     * @return \patest\StructType\BizAction_Sales_BulkEditBasketItems_Request
     */
    public function setComplimentaryConfirmByKey($complimentaryConfirmByKey = null)
    {
        // validation for constraint: string
        if (!is_null($complimentaryConfirmByKey) && !is_string($complimentaryConfirmByKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($complimentaryConfirmByKey, true), gettype($complimentaryConfirmByKey)), __LINE__);
        }
        if (is_null($complimentaryConfirmByKey) || (is_array($complimentaryConfirmByKey) && empty($complimentaryConfirmByKey))) {
            unset($this->ComplimentaryConfirmByKey);
        } else {
            $this->ComplimentaryConfirmByKey = $complimentaryConfirmByKey;
        }
        return $this;
    }
    /**
     * Get EventsIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventsIds()
    {
        return isset($this->EventsIds) ? $this->EventsIds : null;
    }
    /**
     * Set EventsIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventsIds
     * @return \patest\StructType\BizAction_Sales_BulkEditBasketItems_Request
     */
    public function setEventsIds($eventsIds = null)
    {
        // validation for constraint: string
        if (!is_null($eventsIds) && !is_string($eventsIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventsIds, true), gettype($eventsIds)), __LINE__);
        }
        if (is_null($eventsIds) || (is_array($eventsIds) && empty($eventsIds))) {
            unset($this->EventsIds);
        } else {
            $this->EventsIds = $eventsIds;
        }
        return $this;
    }
    /**
     * Get IsAllItemsOfTheSameProductType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAllItemsOfTheSameProductType()
    {
        return isset($this->IsAllItemsOfTheSameProductType) ? $this->IsAllItemsOfTheSameProductType : null;
    }
    /**
     * Set IsAllItemsOfTheSameProductType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAllItemsOfTheSameProductType
     * @return \patest\StructType\BizAction_Sales_BulkEditBasketItems_Request
     */
    public function setIsAllItemsOfTheSameProductType($isAllItemsOfTheSameProductType = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAllItemsOfTheSameProductType) && !is_bool($isAllItemsOfTheSameProductType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAllItemsOfTheSameProductType, true), gettype($isAllItemsOfTheSameProductType)), __LINE__);
        }
        if (is_null($isAllItemsOfTheSameProductType) || (is_array($isAllItemsOfTheSameProductType) && empty($isAllItemsOfTheSameProductType))) {
            unset($this->IsAllItemsOfTheSameProductType);
        } else {
            $this->IsAllItemsOfTheSameProductType = $isAllItemsOfTheSameProductType;
        }
        return $this;
    }
    /**
     * Get IsAllItemsOfTypeTicket value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAllItemsOfTypeTicket()
    {
        return isset($this->IsAllItemsOfTypeTicket) ? $this->IsAllItemsOfTypeTicket : null;
    }
    /**
     * Set IsAllItemsOfTypeTicket value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAllItemsOfTypeTicket
     * @return \patest\StructType\BizAction_Sales_BulkEditBasketItems_Request
     */
    public function setIsAllItemsOfTypeTicket($isAllItemsOfTypeTicket = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAllItemsOfTypeTicket) && !is_bool($isAllItemsOfTypeTicket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAllItemsOfTypeTicket, true), gettype($isAllItemsOfTypeTicket)), __LINE__);
        }
        if (is_null($isAllItemsOfTypeTicket) || (is_array($isAllItemsOfTypeTicket) && empty($isAllItemsOfTypeTicket))) {
            unset($this->IsAllItemsOfTypeTicket);
        } else {
            $this->IsAllItemsOfTypeTicket = $isAllItemsOfTypeTicket;
        }
        return $this;
    }
    /**
     * Get IsExistingConfirmedItems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsExistingConfirmedItems()
    {
        return isset($this->IsExistingConfirmedItems) ? $this->IsExistingConfirmedItems : null;
    }
    /**
     * Set IsExistingConfirmedItems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isExistingConfirmedItems
     * @return \patest\StructType\BizAction_Sales_BulkEditBasketItems_Request
     */
    public function setIsExistingConfirmedItems($isExistingConfirmedItems = null)
    {
        // validation for constraint: boolean
        if (!is_null($isExistingConfirmedItems) && !is_bool($isExistingConfirmedItems)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isExistingConfirmedItems, true), gettype($isExistingConfirmedItems)), __LINE__);
        }
        if (is_null($isExistingConfirmedItems) || (is_array($isExistingConfirmedItems) && empty($isExistingConfirmedItems))) {
            unset($this->IsExistingConfirmedItems);
        } else {
            $this->IsExistingConfirmedItems = $isExistingConfirmedItems;
        }
        return $this;
    }
    /**
     * Get IsExistingDeliveryItems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsExistingDeliveryItems()
    {
        return isset($this->IsExistingDeliveryItems) ? $this->IsExistingDeliveryItems : null;
    }
    /**
     * Set IsExistingDeliveryItems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isExistingDeliveryItems
     * @return \patest\StructType\BizAction_Sales_BulkEditBasketItems_Request
     */
    public function setIsExistingDeliveryItems($isExistingDeliveryItems = null)
    {
        // validation for constraint: boolean
        if (!is_null($isExistingDeliveryItems) && !is_bool($isExistingDeliveryItems)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isExistingDeliveryItems, true), gettype($isExistingDeliveryItems)), __LINE__);
        }
        if (is_null($isExistingDeliveryItems) || (is_array($isExistingDeliveryItems) && empty($isExistingDeliveryItems))) {
            unset($this->IsExistingDeliveryItems);
        } else {
            $this->IsExistingDeliveryItems = $isExistingDeliveryItems;
        }
        return $this;
    }
    /**
     * Get IsExistingSubscriptionItems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsExistingSubscriptionItems()
    {
        return isset($this->IsExistingSubscriptionItems) ? $this->IsExistingSubscriptionItems : null;
    }
    /**
     * Set IsExistingSubscriptionItems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isExistingSubscriptionItems
     * @return \patest\StructType\BizAction_Sales_BulkEditBasketItems_Request
     */
    public function setIsExistingSubscriptionItems($isExistingSubscriptionItems = null)
    {
        // validation for constraint: boolean
        if (!is_null($isExistingSubscriptionItems) && !is_bool($isExistingSubscriptionItems)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isExistingSubscriptionItems, true), gettype($isExistingSubscriptionItems)), __LINE__);
        }
        if (is_null($isExistingSubscriptionItems) || (is_array($isExistingSubscriptionItems) && empty($isExistingSubscriptionItems))) {
            unset($this->IsExistingSubscriptionItems);
        } else {
            $this->IsExistingSubscriptionItems = $isExistingSubscriptionItems;
        }
        return $this;
    }
    /**
     * Get isFollowUp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsFollowUp()
    {
        return isset($this->isFollowUp) ? $this->isFollowUp : null;
    }
    /**
     * Set isFollowUp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isFollowUp
     * @return \patest\StructType\BizAction_Sales_BulkEditBasketItems_Request
     */
    public function setIsFollowUp($isFollowUp = null)
    {
        // validation for constraint: boolean
        if (!is_null($isFollowUp) && !is_bool($isFollowUp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isFollowUp, true), gettype($isFollowUp)), __LINE__);
        }
        if (is_null($isFollowUp) || (is_array($isFollowUp) && empty($isFollowUp))) {
            unset($this->isFollowUp);
        } else {
            $this->isFollowUp = $isFollowUp;
        }
        return $this;
    }
    /**
     * Get IsUpdateCollectionMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsUpdateCollectionMethod()
    {
        return isset($this->IsUpdateCollectionMethod) ? $this->IsUpdateCollectionMethod : null;
    }
    /**
     * Set IsUpdateCollectionMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isUpdateCollectionMethod
     * @return \patest\StructType\BizAction_Sales_BulkEditBasketItems_Request
     */
    public function setIsUpdateCollectionMethod($isUpdateCollectionMethod = null)
    {
        // validation for constraint: boolean
        if (!is_null($isUpdateCollectionMethod) && !is_bool($isUpdateCollectionMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isUpdateCollectionMethod, true), gettype($isUpdateCollectionMethod)), __LINE__);
        }
        if (is_null($isUpdateCollectionMethod) || (is_array($isUpdateCollectionMethod) && empty($isUpdateCollectionMethod))) {
            unset($this->IsUpdateCollectionMethod);
        } else {
            $this->IsUpdateCollectionMethod = $isUpdateCollectionMethod;
        }
        return $this;
    }
    /**
     * Get IsUpdateComplimentaryConfirmByKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsUpdateComplimentaryConfirmByKey()
    {
        return isset($this->IsUpdateComplimentaryConfirmByKey) ? $this->IsUpdateComplimentaryConfirmByKey : null;
    }
    /**
     * Set IsUpdateComplimentaryConfirmByKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isUpdateComplimentaryConfirmByKey
     * @return \patest\StructType\BizAction_Sales_BulkEditBasketItems_Request
     */
    public function setIsUpdateComplimentaryConfirmByKey($isUpdateComplimentaryConfirmByKey = null)
    {
        // validation for constraint: boolean
        if (!is_null($isUpdateComplimentaryConfirmByKey) && !is_bool($isUpdateComplimentaryConfirmByKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isUpdateComplimentaryConfirmByKey, true), gettype($isUpdateComplimentaryConfirmByKey)), __LINE__);
        }
        if (is_null($isUpdateComplimentaryConfirmByKey) || (is_array($isUpdateComplimentaryConfirmByKey) && empty($isUpdateComplimentaryConfirmByKey))) {
            unset($this->IsUpdateComplimentaryConfirmByKey);
        } else {
            $this->IsUpdateComplimentaryConfirmByKey = $isUpdateComplimentaryConfirmByKey;
        }
        return $this;
    }
    /**
     * Get IsUpdateItemNote value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsUpdateItemNote()
    {
        return isset($this->IsUpdateItemNote) ? $this->IsUpdateItemNote : null;
    }
    /**
     * Set IsUpdateItemNote value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isUpdateItemNote
     * @return \patest\StructType\BizAction_Sales_BulkEditBasketItems_Request
     */
    public function setIsUpdateItemNote($isUpdateItemNote = null)
    {
        // validation for constraint: boolean
        if (!is_null($isUpdateItemNote) && !is_bool($isUpdateItemNote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isUpdateItemNote, true), gettype($isUpdateItemNote)), __LINE__);
        }
        if (is_null($isUpdateItemNote) || (is_array($isUpdateItemNote) && empty($isUpdateItemNote))) {
            unset($this->IsUpdateItemNote);
        } else {
            $this->IsUpdateItemNote = $isUpdateItemNote;
        }
        return $this;
    }
    /**
     * Get IsUpdateOwnerClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsUpdateOwnerClientId()
    {
        return isset($this->IsUpdateOwnerClientId) ? $this->IsUpdateOwnerClientId : null;
    }
    /**
     * Set IsUpdateOwnerClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isUpdateOwnerClientId
     * @return \patest\StructType\BizAction_Sales_BulkEditBasketItems_Request
     */
    public function setIsUpdateOwnerClientId($isUpdateOwnerClientId = null)
    {
        // validation for constraint: boolean
        if (!is_null($isUpdateOwnerClientId) && !is_bool($isUpdateOwnerClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isUpdateOwnerClientId, true), gettype($isUpdateOwnerClientId)), __LINE__);
        }
        if (is_null($isUpdateOwnerClientId) || (is_array($isUpdateOwnerClientId) && empty($isUpdateOwnerClientId))) {
            unset($this->IsUpdateOwnerClientId);
        } else {
            $this->IsUpdateOwnerClientId = $isUpdateOwnerClientId;
        }
        return $this;
    }
    /**
     * Get IsUpdatePrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsUpdatePrice()
    {
        return isset($this->IsUpdatePrice) ? $this->IsUpdatePrice : null;
    }
    /**
     * Set IsUpdatePrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isUpdatePrice
     * @return \patest\StructType\BizAction_Sales_BulkEditBasketItems_Request
     */
    public function setIsUpdatePrice($isUpdatePrice = null)
    {
        // validation for constraint: boolean
        if (!is_null($isUpdatePrice) && !is_bool($isUpdatePrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isUpdatePrice, true), gettype($isUpdatePrice)), __LINE__);
        }
        if (is_null($isUpdatePrice) || (is_array($isUpdatePrice) && empty($isUpdatePrice))) {
            unset($this->IsUpdatePrice);
        } else {
            $this->IsUpdatePrice = $isUpdatePrice;
        }
        return $this;
    }
    /**
     * Get IsUpdatePriceTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsUpdatePriceTypeId()
    {
        return isset($this->IsUpdatePriceTypeId) ? $this->IsUpdatePriceTypeId : null;
    }
    /**
     * Set IsUpdatePriceTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isUpdatePriceTypeId
     * @return \patest\StructType\BizAction_Sales_BulkEditBasketItems_Request
     */
    public function setIsUpdatePriceTypeId($isUpdatePriceTypeId = null)
    {
        // validation for constraint: boolean
        if (!is_null($isUpdatePriceTypeId) && !is_bool($isUpdatePriceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isUpdatePriceTypeId, true), gettype($isUpdatePriceTypeId)), __LINE__);
        }
        if (is_null($isUpdatePriceTypeId) || (is_array($isUpdatePriceTypeId) && empty($isUpdatePriceTypeId))) {
            unset($this->IsUpdatePriceTypeId);
        } else {
            $this->IsUpdatePriceTypeId = $isUpdatePriceTypeId;
        }
        return $this;
    }
    /**
     * Get IsUpdateReservationExpiryDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsUpdateReservationExpiryDate()
    {
        return isset($this->IsUpdateReservationExpiryDate) ? $this->IsUpdateReservationExpiryDate : null;
    }
    /**
     * Set IsUpdateReservationExpiryDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isUpdateReservationExpiryDate
     * @return \patest\StructType\BizAction_Sales_BulkEditBasketItems_Request
     */
    public function setIsUpdateReservationExpiryDate($isUpdateReservationExpiryDate = null)
    {
        // validation for constraint: boolean
        if (!is_null($isUpdateReservationExpiryDate) && !is_bool($isUpdateReservationExpiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isUpdateReservationExpiryDate, true), gettype($isUpdateReservationExpiryDate)), __LINE__);
        }
        if (is_null($isUpdateReservationExpiryDate) || (is_array($isUpdateReservationExpiryDate) && empty($isUpdateReservationExpiryDate))) {
            unset($this->IsUpdateReservationExpiryDate);
        } else {
            $this->IsUpdateReservationExpiryDate = $isUpdateReservationExpiryDate;
        }
        return $this;
    }
    /**
     * Get IsUpdateSalesRepresentativeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsUpdateSalesRepresentativeId()
    {
        return isset($this->IsUpdateSalesRepresentativeId) ? $this->IsUpdateSalesRepresentativeId : null;
    }
    /**
     * Set IsUpdateSalesRepresentativeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isUpdateSalesRepresentativeId
     * @return \patest\StructType\BizAction_Sales_BulkEditBasketItems_Request
     */
    public function setIsUpdateSalesRepresentativeId($isUpdateSalesRepresentativeId = null)
    {
        // validation for constraint: boolean
        if (!is_null($isUpdateSalesRepresentativeId) && !is_bool($isUpdateSalesRepresentativeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isUpdateSalesRepresentativeId, true), gettype($isUpdateSalesRepresentativeId)), __LINE__);
        }
        if (is_null($isUpdateSalesRepresentativeId) || (is_array($isUpdateSalesRepresentativeId) && empty($isUpdateSalesRepresentativeId))) {
            unset($this->IsUpdateSalesRepresentativeId);
        } else {
            $this->IsUpdateSalesRepresentativeId = $isUpdateSalesRepresentativeId;
        }
        return $this;
    }
    /**
     * Get IsUpdateSaleStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsUpdateSaleStatus()
    {
        return isset($this->IsUpdateSaleStatus) ? $this->IsUpdateSaleStatus : null;
    }
    /**
     * Set IsUpdateSaleStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isUpdateSaleStatus
     * @return \patest\StructType\BizAction_Sales_BulkEditBasketItems_Request
     */
    public function setIsUpdateSaleStatus($isUpdateSaleStatus = null)
    {
        // validation for constraint: boolean
        if (!is_null($isUpdateSaleStatus) && !is_bool($isUpdateSaleStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isUpdateSaleStatus, true), gettype($isUpdateSaleStatus)), __LINE__);
        }
        if (is_null($isUpdateSaleStatus) || (is_array($isUpdateSaleStatus) && empty($isUpdateSaleStatus))) {
            unset($this->IsUpdateSaleStatus);
        } else {
            $this->IsUpdateSaleStatus = $isUpdateSaleStatus;
        }
        return $this;
    }
    /**
     * Get IsUpdateSubscriptionInstanceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsUpdateSubscriptionInstanceId()
    {
        return isset($this->IsUpdateSubscriptionInstanceId) ? $this->IsUpdateSubscriptionInstanceId : null;
    }
    /**
     * Set IsUpdateSubscriptionInstanceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isUpdateSubscriptionInstanceId
     * @return \patest\StructType\BizAction_Sales_BulkEditBasketItems_Request
     */
    public function setIsUpdateSubscriptionInstanceId($isUpdateSubscriptionInstanceId = null)
    {
        // validation for constraint: boolean
        if (!is_null($isUpdateSubscriptionInstanceId) && !is_bool($isUpdateSubscriptionInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isUpdateSubscriptionInstanceId, true), gettype($isUpdateSubscriptionInstanceId)), __LINE__);
        }
        if (is_null($isUpdateSubscriptionInstanceId) || (is_array($isUpdateSubscriptionInstanceId) && empty($isUpdateSubscriptionInstanceId))) {
            unset($this->IsUpdateSubscriptionInstanceId);
        } else {
            $this->IsUpdateSubscriptionInstanceId = $isUpdateSubscriptionInstanceId;
        }
        return $this;
    }
    /**
     * Get ItemNote value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getItemNote()
    {
        return isset($this->ItemNote) ? $this->ItemNote : null;
    }
    /**
     * Set ItemNote value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $itemNote
     * @return \patest\StructType\BizAction_Sales_BulkEditBasketItems_Request
     */
    public function setItemNote($itemNote = null)
    {
        // validation for constraint: string
        if (!is_null($itemNote) && !is_string($itemNote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemNote, true), gettype($itemNote)), __LINE__);
        }
        if (is_null($itemNote) || (is_array($itemNote) && empty($itemNote))) {
            unset($this->ItemNote);
        } else {
            $this->ItemNote = $itemNote;
        }
        return $this;
    }
    /**
     * Get Items value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfSales_BulkEditItemInformation|null
     */
    public function getItems()
    {
        return isset($this->Items) ? $this->Items : null;
    }
    /**
     * Set Items value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfSales_BulkEditItemInformation $items
     * @return \patest\StructType\BizAction_Sales_BulkEditBasketItems_Request
     */
    public function setItems(\patest\StructType\RecordSetOfSales_BulkEditItemInformation $items = null)
    {
        if (is_null($items) || (is_array($items) && empty($items))) {
            unset($this->Items);
        } else {
            $this->Items = $items;
        }
        return $this;
    }
    /**
     * Get OwnerClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnerClientId()
    {
        return isset($this->OwnerClientId) ? $this->OwnerClientId : null;
    }
    /**
     * Set OwnerClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownerClientId
     * @return \patest\StructType\BizAction_Sales_BulkEditBasketItems_Request
     */
    public function setOwnerClientId($ownerClientId = null)
    {
        // validation for constraint: string
        if (!is_null($ownerClientId) && !is_string($ownerClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerClientId, true), gettype($ownerClientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ownerClientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ownerClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ownerClientId, true)), __LINE__);
        }
        if (is_null($ownerClientId) || (is_array($ownerClientId) && empty($ownerClientId))) {
            unset($this->OwnerClientId);
        } else {
            $this->OwnerClientId = $ownerClientId;
        }
        return $this;
    }
    /**
     * Get Price value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPrice()
    {
        return isset($this->Price) ? $this->Price : null;
    }
    /**
     * Set Price value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $price
     * @return \patest\StructType\BizAction_Sales_BulkEditBasketItems_Request
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        if (is_null($price) || (is_array($price) && empty($price))) {
            unset($this->Price);
        } else {
            $this->Price = $price;
        }
        return $this;
    }
    /**
     * Get PriceTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceTypeId()
    {
        return isset($this->PriceTypeId) ? $this->PriceTypeId : null;
    }
    /**
     * Set PriceTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceTypeId
     * @return \patest\StructType\BizAction_Sales_BulkEditBasketItems_Request
     */
    public function setPriceTypeId($priceTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($priceTypeId) && !is_string($priceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceTypeId, true), gettype($priceTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceTypeId, true)), __LINE__);
        }
        if (is_null($priceTypeId) || (is_array($priceTypeId) && empty($priceTypeId))) {
            unset($this->PriceTypeId);
        } else {
            $this->PriceTypeId = $priceTypeId;
        }
        return $this;
    }
    /**
     * Get ReservationExpiryDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReservationExpiryDate()
    {
        return isset($this->ReservationExpiryDate) ? $this->ReservationExpiryDate : null;
    }
    /**
     * Set ReservationExpiryDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reservationExpiryDate
     * @return \patest\StructType\BizAction_Sales_BulkEditBasketItems_Request
     */
    public function setReservationExpiryDate($reservationExpiryDate = null)
    {
        // validation for constraint: string
        if (!is_null($reservationExpiryDate) && !is_string($reservationExpiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reservationExpiryDate, true), gettype($reservationExpiryDate)), __LINE__);
        }
        if (is_null($reservationExpiryDate) || (is_array($reservationExpiryDate) && empty($reservationExpiryDate))) {
            unset($this->ReservationExpiryDate);
        } else {
            $this->ReservationExpiryDate = $reservationExpiryDate;
        }
        return $this;
    }
    /**
     * Get SalesRepresentativeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSalesRepresentativeId()
    {
        return isset($this->SalesRepresentativeId) ? $this->SalesRepresentativeId : null;
    }
    /**
     * Set SalesRepresentativeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $salesRepresentativeId
     * @return \patest\StructType\BizAction_Sales_BulkEditBasketItems_Request
     */
    public function setSalesRepresentativeId($salesRepresentativeId = null)
    {
        // validation for constraint: string
        if (!is_null($salesRepresentativeId) && !is_string($salesRepresentativeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesRepresentativeId, true), gettype($salesRepresentativeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($salesRepresentativeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $salesRepresentativeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($salesRepresentativeId, true)), __LINE__);
        }
        if (is_null($salesRepresentativeId) || (is_array($salesRepresentativeId) && empty($salesRepresentativeId))) {
            unset($this->SalesRepresentativeId);
        } else {
            $this->SalesRepresentativeId = $salesRepresentativeId;
        }
        return $this;
    }
    /**
     * Get SaleStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSaleStatus()
    {
        return isset($this->SaleStatus) ? $this->SaleStatus : null;
    }
    /**
     * Set SaleStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ProductItemSalesStatus::valueIsValid()
     * @uses \patest\EnumType\ProductItemSalesStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $saleStatus
     * @return \patest\StructType\BizAction_Sales_BulkEditBasketItems_Request
     */
    public function setSaleStatus($saleStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ProductItemSalesStatus::valueIsValid($saleStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ProductItemSalesStatus', is_array($saleStatus) ? implode(', ', $saleStatus) : var_export($saleStatus, true), implode(', ', \patest\EnumType\ProductItemSalesStatus::getValidValues())), __LINE__);
        }
        if (is_null($saleStatus) || (is_array($saleStatus) && empty($saleStatus))) {
            unset($this->SaleStatus);
        } else {
            $this->SaleStatus = $saleStatus;
        }
        return $this;
    }
    /**
     * Get ShouldDisplayPriceType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getShouldDisplayPriceType()
    {
        return isset($this->ShouldDisplayPriceType) ? $this->ShouldDisplayPriceType : null;
    }
    /**
     * Set ShouldDisplayPriceType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $shouldDisplayPriceType
     * @return \patest\StructType\BizAction_Sales_BulkEditBasketItems_Request
     */
    public function setShouldDisplayPriceType($shouldDisplayPriceType = null)
    {
        // validation for constraint: boolean
        if (!is_null($shouldDisplayPriceType) && !is_bool($shouldDisplayPriceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($shouldDisplayPriceType, true), gettype($shouldDisplayPriceType)), __LINE__);
        }
        if (is_null($shouldDisplayPriceType) || (is_array($shouldDisplayPriceType) && empty($shouldDisplayPriceType))) {
            unset($this->ShouldDisplayPriceType);
        } else {
            $this->ShouldDisplayPriceType = $shouldDisplayPriceType;
        }
        return $this;
    }
    /**
     * Get SubscriptionInstanceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriptionInstanceId()
    {
        return isset($this->SubscriptionInstanceId) ? $this->SubscriptionInstanceId : null;
    }
    /**
     * Set SubscriptionInstanceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subscriptionInstanceId
     * @return \patest\StructType\BizAction_Sales_BulkEditBasketItems_Request
     */
    public function setSubscriptionInstanceId($subscriptionInstanceId = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionInstanceId) && !is_string($subscriptionInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriptionInstanceId, true), gettype($subscriptionInstanceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($subscriptionInstanceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $subscriptionInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($subscriptionInstanceId, true)), __LINE__);
        }
        if (is_null($subscriptionInstanceId) || (is_array($subscriptionInstanceId) && empty($subscriptionInstanceId))) {
            unset($this->SubscriptionInstanceId);
        } else {
            $this->SubscriptionInstanceId = $subscriptionInstanceId;
        }
        return $this;
    }
    /**
     * Get TransactionClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionClientId()
    {
        return isset($this->TransactionClientId) ? $this->TransactionClientId : null;
    }
    /**
     * Set TransactionClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionClientId
     * @return \patest\StructType\BizAction_Sales_BulkEditBasketItems_Request
     */
    public function setTransactionClientId($transactionClientId = null)
    {
        // validation for constraint: string
        if (!is_null($transactionClientId) && !is_string($transactionClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionClientId, true), gettype($transactionClientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionClientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionClientId, true)), __LINE__);
        }
        if (is_null($transactionClientId) || (is_array($transactionClientId) && empty($transactionClientId))) {
            unset($this->TransactionClientId);
        } else {
            $this->TransactionClientId = $transactionClientId;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return isset($this->TransactionGuid) ? $this->TransactionGuid : null;
    }
    /**
     * Set TransactionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionGuid
     * @return \patest\StructType\BizAction_Sales_BulkEditBasketItems_Request
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        if (is_null($transactionGuid) || (is_array($transactionGuid) && empty($transactionGuid))) {
            unset($this->TransactionGuid);
        } else {
            $this->TransactionGuid = $transactionGuid;
        }
        return $this;
    }
}
