<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Sales.Accounting.DeductAction.Request StructType
 * @subpackage Structs
 */
class BizAction_Sales_Accounting_DeductAction_Request extends AnyEntity
{
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The DeductedReminder
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $DeductedReminder;
    /**
     * The DepositAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $DepositAmount;
    /**
     * The DepositCategoryId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DepositCategoryId;
    /**
     * The DepositId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DepositId;
    /**
     * The FromDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FromDate;
    /**
     * The Items
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfSales_DeductActionItem
     */
    public $Items;
    /**
     * The RemainingAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $RemainingAmount;
    /**
     * The ShowIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ShowIds;
    /**
     * The UntilDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UntilDate;
    /**
     * Constructor method for BizAction.Sales.Accounting.DeductAction.Request
     * @uses BizAction_Sales_Accounting_DeductAction_Request::setClientId()
     * @uses BizAction_Sales_Accounting_DeductAction_Request::setDeductedReminder()
     * @uses BizAction_Sales_Accounting_DeductAction_Request::setDepositAmount()
     * @uses BizAction_Sales_Accounting_DeductAction_Request::setDepositCategoryId()
     * @uses BizAction_Sales_Accounting_DeductAction_Request::setDepositId()
     * @uses BizAction_Sales_Accounting_DeductAction_Request::setFromDate()
     * @uses BizAction_Sales_Accounting_DeductAction_Request::setItems()
     * @uses BizAction_Sales_Accounting_DeductAction_Request::setRemainingAmount()
     * @uses BizAction_Sales_Accounting_DeductAction_Request::setShowIds()
     * @uses BizAction_Sales_Accounting_DeductAction_Request::setUntilDate()
     * @param string $clientId
     * @param \patest\StructType\Money $deductedReminder
     * @param \patest\StructType\Money $depositAmount
     * @param string $depositCategoryId
     * @param string $depositId
     * @param string $fromDate
     * @param \patest\StructType\RecordSetOfSales_DeductActionItem $items
     * @param \patest\StructType\Money $remainingAmount
     * @param string $showIds
     * @param string $untilDate
     */
    public function __construct($clientId = null, \patest\StructType\Money $deductedReminder = null, \patest\StructType\Money $depositAmount = null, $depositCategoryId = null, $depositId = null, $fromDate = null, \patest\StructType\RecordSetOfSales_DeductActionItem $items = null, \patest\StructType\Money $remainingAmount = null, $showIds = null, $untilDate = null)
    {
        $this
            ->setClientId($clientId)
            ->setDeductedReminder($deductedReminder)
            ->setDepositAmount($depositAmount)
            ->setDepositCategoryId($depositCategoryId)
            ->setDepositId($depositId)
            ->setFromDate($fromDate)
            ->setItems($items)
            ->setRemainingAmount($remainingAmount)
            ->setShowIds($showIds)
            ->setUntilDate($untilDate);
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\BizAction_Sales_Accounting_DeductAction_Request
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get DeductedReminder value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getDeductedReminder()
    {
        return isset($this->DeductedReminder) ? $this->DeductedReminder : null;
    }
    /**
     * Set DeductedReminder value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $deductedReminder
     * @return \patest\StructType\BizAction_Sales_Accounting_DeductAction_Request
     */
    public function setDeductedReminder(\patest\StructType\Money $deductedReminder = null)
    {
        if (is_null($deductedReminder) || (is_array($deductedReminder) && empty($deductedReminder))) {
            unset($this->DeductedReminder);
        } else {
            $this->DeductedReminder = $deductedReminder;
        }
        return $this;
    }
    /**
     * Get DepositAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getDepositAmount()
    {
        return isset($this->DepositAmount) ? $this->DepositAmount : null;
    }
    /**
     * Set DepositAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $depositAmount
     * @return \patest\StructType\BizAction_Sales_Accounting_DeductAction_Request
     */
    public function setDepositAmount(\patest\StructType\Money $depositAmount = null)
    {
        if (is_null($depositAmount) || (is_array($depositAmount) && empty($depositAmount))) {
            unset($this->DepositAmount);
        } else {
            $this->DepositAmount = $depositAmount;
        }
        return $this;
    }
    /**
     * Get DepositCategoryId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDepositCategoryId()
    {
        return isset($this->DepositCategoryId) ? $this->DepositCategoryId : null;
    }
    /**
     * Set DepositCategoryId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $depositCategoryId
     * @return \patest\StructType\BizAction_Sales_Accounting_DeductAction_Request
     */
    public function setDepositCategoryId($depositCategoryId = null)
    {
        // validation for constraint: string
        if (!is_null($depositCategoryId) && !is_string($depositCategoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($depositCategoryId, true), gettype($depositCategoryId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($depositCategoryId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $depositCategoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($depositCategoryId, true)), __LINE__);
        }
        if (is_null($depositCategoryId) || (is_array($depositCategoryId) && empty($depositCategoryId))) {
            unset($this->DepositCategoryId);
        } else {
            $this->DepositCategoryId = $depositCategoryId;
        }
        return $this;
    }
    /**
     * Get DepositId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDepositId()
    {
        return isset($this->DepositId) ? $this->DepositId : null;
    }
    /**
     * Set DepositId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $depositId
     * @return \patest\StructType\BizAction_Sales_Accounting_DeductAction_Request
     */
    public function setDepositId($depositId = null)
    {
        // validation for constraint: string
        if (!is_null($depositId) && !is_string($depositId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($depositId, true), gettype($depositId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($depositId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $depositId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($depositId, true)), __LINE__);
        }
        if (is_null($depositId) || (is_array($depositId) && empty($depositId))) {
            unset($this->DepositId);
        } else {
            $this->DepositId = $depositId;
        }
        return $this;
    }
    /**
     * Get FromDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFromDate()
    {
        return isset($this->FromDate) ? $this->FromDate : null;
    }
    /**
     * Set FromDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fromDate
     * @return \patest\StructType\BizAction_Sales_Accounting_DeductAction_Request
     */
    public function setFromDate($fromDate = null)
    {
        // validation for constraint: string
        if (!is_null($fromDate) && !is_string($fromDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromDate, true), gettype($fromDate)), __LINE__);
        }
        if (is_null($fromDate) || (is_array($fromDate) && empty($fromDate))) {
            unset($this->FromDate);
        } else {
            $this->FromDate = $fromDate;
        }
        return $this;
    }
    /**
     * Get Items value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfSales_DeductActionItem|null
     */
    public function getItems()
    {
        return isset($this->Items) ? $this->Items : null;
    }
    /**
     * Set Items value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfSales_DeductActionItem $items
     * @return \patest\StructType\BizAction_Sales_Accounting_DeductAction_Request
     */
    public function setItems(\patest\StructType\RecordSetOfSales_DeductActionItem $items = null)
    {
        if (is_null($items) || (is_array($items) && empty($items))) {
            unset($this->Items);
        } else {
            $this->Items = $items;
        }
        return $this;
    }
    /**
     * Get RemainingAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getRemainingAmount()
    {
        return isset($this->RemainingAmount) ? $this->RemainingAmount : null;
    }
    /**
     * Set RemainingAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $remainingAmount
     * @return \patest\StructType\BizAction_Sales_Accounting_DeductAction_Request
     */
    public function setRemainingAmount(\patest\StructType\Money $remainingAmount = null)
    {
        if (is_null($remainingAmount) || (is_array($remainingAmount) && empty($remainingAmount))) {
            unset($this->RemainingAmount);
        } else {
            $this->RemainingAmount = $remainingAmount;
        }
        return $this;
    }
    /**
     * Get ShowIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShowIds()
    {
        return isset($this->ShowIds) ? $this->ShowIds : null;
    }
    /**
     * Set ShowIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $showIds
     * @return \patest\StructType\BizAction_Sales_Accounting_DeductAction_Request
     */
    public function setShowIds($showIds = null)
    {
        // validation for constraint: string
        if (!is_null($showIds) && !is_string($showIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showIds, true), gettype($showIds)), __LINE__);
        }
        if (is_null($showIds) || (is_array($showIds) && empty($showIds))) {
            unset($this->ShowIds);
        } else {
            $this->ShowIds = $showIds;
        }
        return $this;
    }
    /**
     * Get UntilDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUntilDate()
    {
        return isset($this->UntilDate) ? $this->UntilDate : null;
    }
    /**
     * Set UntilDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $untilDate
     * @return \patest\StructType\BizAction_Sales_Accounting_DeductAction_Request
     */
    public function setUntilDate($untilDate = null)
    {
        // validation for constraint: string
        if (!is_null($untilDate) && !is_string($untilDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($untilDate, true), gettype($untilDate)), __LINE__);
        }
        if (is_null($untilDate) || (is_array($untilDate) && empty($untilDate))) {
            unset($this->UntilDate);
        } else {
            $this->UntilDate = $untilDate;
        }
        return $this;
    }
}
