<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Sale.Accounting.PrintDraftInvoiceAction.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Sale_Accounting_PrintDraftInvoiceAction_Request extends AnyEntity
{
    /**
     * The CCRecipients
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CCRecipients;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The EmailBodyOptionalMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EmailBodyOptionalMessage;
    /**
     * The InvoiceDocumentId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $InvoiceDocumentId;
    /**
     * The IsSendByEmail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSendByEmail;
    /**
     * The PayDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PayDate;
    /**
     * The PaymentTerms
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentTerms;
    /**
     * The Remark
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Remark;
    /**
     * The TargetPrinterId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TargetPrinterId;
    /**
     * The ToRecipients
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ToRecipients;
    /**
     * The TransactionIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\TransactionIds
     */
    public $TransactionIds;
    /**
     * Constructor method for BizAction.Sale.Accounting.PrintDraftInvoiceAction.Request
     * @uses BizAction_Sale_Accounting_PrintDraftInvoiceAction_Request::setCCRecipients()
     * @uses BizAction_Sale_Accounting_PrintDraftInvoiceAction_Request::setClientId()
     * @uses BizAction_Sale_Accounting_PrintDraftInvoiceAction_Request::setEmailBodyOptionalMessage()
     * @uses BizAction_Sale_Accounting_PrintDraftInvoiceAction_Request::setInvoiceDocumentId()
     * @uses BizAction_Sale_Accounting_PrintDraftInvoiceAction_Request::setIsSendByEmail()
     * @uses BizAction_Sale_Accounting_PrintDraftInvoiceAction_Request::setPayDate()
     * @uses BizAction_Sale_Accounting_PrintDraftInvoiceAction_Request::setPaymentTerms()
     * @uses BizAction_Sale_Accounting_PrintDraftInvoiceAction_Request::setRemark()
     * @uses BizAction_Sale_Accounting_PrintDraftInvoiceAction_Request::setTargetPrinterId()
     * @uses BizAction_Sale_Accounting_PrintDraftInvoiceAction_Request::setToRecipients()
     * @uses BizAction_Sale_Accounting_PrintDraftInvoiceAction_Request::setTransactionIds()
     * @param string $cCRecipients
     * @param string $clientId
     * @param string $emailBodyOptionalMessage
     * @param string $invoiceDocumentId
     * @param bool $isSendByEmail
     * @param string $payDate
     * @param string $paymentTerms
     * @param string $remark
     * @param string $targetPrinterId
     * @param string $toRecipients
     * @param \patest\StructType\TransactionIds $transactionIds
     */
    public function __construct($cCRecipients = null, $clientId = null, $emailBodyOptionalMessage = null, $invoiceDocumentId = null, $isSendByEmail = null, $payDate = null, $paymentTerms = null, $remark = null, $targetPrinterId = null, $toRecipients = null, \patest\StructType\TransactionIds $transactionIds = null)
    {
        $this
            ->setCCRecipients($cCRecipients)
            ->setClientId($clientId)
            ->setEmailBodyOptionalMessage($emailBodyOptionalMessage)
            ->setInvoiceDocumentId($invoiceDocumentId)
            ->setIsSendByEmail($isSendByEmail)
            ->setPayDate($payDate)
            ->setPaymentTerms($paymentTerms)
            ->setRemark($remark)
            ->setTargetPrinterId($targetPrinterId)
            ->setToRecipients($toRecipients)
            ->setTransactionIds($transactionIds);
    }
    /**
     * Get CCRecipients value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCCRecipients()
    {
        return isset($this->CCRecipients) ? $this->CCRecipients : null;
    }
    /**
     * Set CCRecipients value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cCRecipients
     * @return \patest\StructType\BizAction_Sale_Accounting_PrintDraftInvoiceAction_Request
     */
    public function setCCRecipients($cCRecipients = null)
    {
        // validation for constraint: string
        if (!is_null($cCRecipients) && !is_string($cCRecipients)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cCRecipients, true), gettype($cCRecipients)), __LINE__);
        }
        if (is_null($cCRecipients) || (is_array($cCRecipients) && empty($cCRecipients))) {
            unset($this->CCRecipients);
        } else {
            $this->CCRecipients = $cCRecipients;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\BizAction_Sale_Accounting_PrintDraftInvoiceAction_Request
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get EmailBodyOptionalMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmailBodyOptionalMessage()
    {
        return isset($this->EmailBodyOptionalMessage) ? $this->EmailBodyOptionalMessage : null;
    }
    /**
     * Set EmailBodyOptionalMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $emailBodyOptionalMessage
     * @return \patest\StructType\BizAction_Sale_Accounting_PrintDraftInvoiceAction_Request
     */
    public function setEmailBodyOptionalMessage($emailBodyOptionalMessage = null)
    {
        // validation for constraint: string
        if (!is_null($emailBodyOptionalMessage) && !is_string($emailBodyOptionalMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailBodyOptionalMessage, true), gettype($emailBodyOptionalMessage)), __LINE__);
        }
        if (is_null($emailBodyOptionalMessage) || (is_array($emailBodyOptionalMessage) && empty($emailBodyOptionalMessage))) {
            unset($this->EmailBodyOptionalMessage);
        } else {
            $this->EmailBodyOptionalMessage = $emailBodyOptionalMessage;
        }
        return $this;
    }
    /**
     * Get InvoiceDocumentId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInvoiceDocumentId()
    {
        return isset($this->InvoiceDocumentId) ? $this->InvoiceDocumentId : null;
    }
    /**
     * Set InvoiceDocumentId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $invoiceDocumentId
     * @return \patest\StructType\BizAction_Sale_Accounting_PrintDraftInvoiceAction_Request
     */
    public function setInvoiceDocumentId($invoiceDocumentId = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceDocumentId) && !is_string($invoiceDocumentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceDocumentId, true), gettype($invoiceDocumentId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($invoiceDocumentId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $invoiceDocumentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($invoiceDocumentId, true)), __LINE__);
        }
        if (is_null($invoiceDocumentId) || (is_array($invoiceDocumentId) && empty($invoiceDocumentId))) {
            unset($this->InvoiceDocumentId);
        } else {
            $this->InvoiceDocumentId = $invoiceDocumentId;
        }
        return $this;
    }
    /**
     * Get IsSendByEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSendByEmail()
    {
        return isset($this->IsSendByEmail) ? $this->IsSendByEmail : null;
    }
    /**
     * Set IsSendByEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSendByEmail
     * @return \patest\StructType\BizAction_Sale_Accounting_PrintDraftInvoiceAction_Request
     */
    public function setIsSendByEmail($isSendByEmail = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSendByEmail) && !is_bool($isSendByEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSendByEmail, true), gettype($isSendByEmail)), __LINE__);
        }
        if (is_null($isSendByEmail) || (is_array($isSendByEmail) && empty($isSendByEmail))) {
            unset($this->IsSendByEmail);
        } else {
            $this->IsSendByEmail = $isSendByEmail;
        }
        return $this;
    }
    /**
     * Get PayDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayDate()
    {
        return isset($this->PayDate) ? $this->PayDate : null;
    }
    /**
     * Set PayDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $payDate
     * @return \patest\StructType\BizAction_Sale_Accounting_PrintDraftInvoiceAction_Request
     */
    public function setPayDate($payDate = null)
    {
        // validation for constraint: string
        if (!is_null($payDate) && !is_string($payDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payDate, true), gettype($payDate)), __LINE__);
        }
        if (is_null($payDate) || (is_array($payDate) && empty($payDate))) {
            unset($this->PayDate);
        } else {
            $this->PayDate = $payDate;
        }
        return $this;
    }
    /**
     * Get PaymentTerms value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentTerms()
    {
        return isset($this->PaymentTerms) ? $this->PaymentTerms : null;
    }
    /**
     * Set PaymentTerms value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentTerms
     * @return \patest\StructType\BizAction_Sale_Accounting_PrintDraftInvoiceAction_Request
     */
    public function setPaymentTerms($paymentTerms = null)
    {
        // validation for constraint: string
        if (!is_null($paymentTerms) && !is_string($paymentTerms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentTerms, true), gettype($paymentTerms)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentTerms) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentTerms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentTerms, true)), __LINE__);
        }
        if (is_null($paymentTerms) || (is_array($paymentTerms) && empty($paymentTerms))) {
            unset($this->PaymentTerms);
        } else {
            $this->PaymentTerms = $paymentTerms;
        }
        return $this;
    }
    /**
     * Get Remark value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRemark()
    {
        return isset($this->Remark) ? $this->Remark : null;
    }
    /**
     * Set Remark value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $remark
     * @return \patest\StructType\BizAction_Sale_Accounting_PrintDraftInvoiceAction_Request
     */
    public function setRemark($remark = null)
    {
        // validation for constraint: string
        if (!is_null($remark) && !is_string($remark)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remark, true), gettype($remark)), __LINE__);
        }
        if (is_null($remark) || (is_array($remark) && empty($remark))) {
            unset($this->Remark);
        } else {
            $this->Remark = $remark;
        }
        return $this;
    }
    /**
     * Get TargetPrinterId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetPrinterId()
    {
        return isset($this->TargetPrinterId) ? $this->TargetPrinterId : null;
    }
    /**
     * Set TargetPrinterId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetPrinterId
     * @return \patest\StructType\BizAction_Sale_Accounting_PrintDraftInvoiceAction_Request
     */
    public function setTargetPrinterId($targetPrinterId = null)
    {
        // validation for constraint: string
        if (!is_null($targetPrinterId) && !is_string($targetPrinterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetPrinterId, true), gettype($targetPrinterId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($targetPrinterId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $targetPrinterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($targetPrinterId, true)), __LINE__);
        }
        if (is_null($targetPrinterId) || (is_array($targetPrinterId) && empty($targetPrinterId))) {
            unset($this->TargetPrinterId);
        } else {
            $this->TargetPrinterId = $targetPrinterId;
        }
        return $this;
    }
    /**
     * Get ToRecipients value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToRecipients()
    {
        return isset($this->ToRecipients) ? $this->ToRecipients : null;
    }
    /**
     * Set ToRecipients value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $toRecipients
     * @return \patest\StructType\BizAction_Sale_Accounting_PrintDraftInvoiceAction_Request
     */
    public function setToRecipients($toRecipients = null)
    {
        // validation for constraint: string
        if (!is_null($toRecipients) && !is_string($toRecipients)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toRecipients, true), gettype($toRecipients)), __LINE__);
        }
        if (is_null($toRecipients) || (is_array($toRecipients) && empty($toRecipients))) {
            unset($this->ToRecipients);
        } else {
            $this->ToRecipients = $toRecipients;
        }
        return $this;
    }
    /**
     * Get TransactionIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\TransactionIds|null
     */
    public function getTransactionIds()
    {
        return isset($this->TransactionIds) ? $this->TransactionIds : null;
    }
    /**
     * Set TransactionIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\TransactionIds $transactionIds
     * @return \patest\StructType\BizAction_Sale_Accounting_PrintDraftInvoiceAction_Request
     */
    public function setTransactionIds(\patest\StructType\TransactionIds $transactionIds = null)
    {
        if (is_null($transactionIds) || (is_array($transactionIds) && empty($transactionIds))) {
            unset($this->TransactionIds);
        } else {
            $this->TransactionIds = $transactionIds;
        }
        return $this;
    }
}
