<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Sale.Accounting.CreateDraftInvoiceAction.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Sale_Accounting_CreateDraftInvoiceAction_Request extends AnyEntity
{
    /**
     * The CalculateCommPerTransaction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CalculateCommPerTransaction;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The FromDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FromDate;
    /**
     * The GroupByFullPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $GroupByFullPrice;
    /**
     * The IncludeAllItems
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IncludeAllItems;
    /**
     * The IncludedItemKind
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IncludedItemKind;
    /**
     * The IncludedSalesItems
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IncludedSalesItems;
    /**
     * The IsSendByEmail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSendByEmail;
    /**
     * The Items
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfSales_LiabilityItemForDraftInvoice
     */
    public $Items;
    /**
     * The PurposeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PurposeId;
    /**
     * The Remark
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Remark;
    /**
     * The SendByEmailData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Sales_SendByEmailData
     */
    public $SendByEmailData;
    /**
     * The TargetPrinterId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TargetPrinterId;
    /**
     * The UntilDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UntilDate;
    /**
     * Constructor method for
     * BizAction.Sale.Accounting.CreateDraftInvoiceAction.Request
     * @uses BizAction_Sale_Accounting_CreateDraftInvoiceAction_Request::setCalculateCommPerTransaction()
     * @uses BizAction_Sale_Accounting_CreateDraftInvoiceAction_Request::setClientId()
     * @uses BizAction_Sale_Accounting_CreateDraftInvoiceAction_Request::setFromDate()
     * @uses BizAction_Sale_Accounting_CreateDraftInvoiceAction_Request::setGroupByFullPrice()
     * @uses BizAction_Sale_Accounting_CreateDraftInvoiceAction_Request::setIncludeAllItems()
     * @uses BizAction_Sale_Accounting_CreateDraftInvoiceAction_Request::setIncludedItemKind()
     * @uses BizAction_Sale_Accounting_CreateDraftInvoiceAction_Request::setIncludedSalesItems()
     * @uses BizAction_Sale_Accounting_CreateDraftInvoiceAction_Request::setIsSendByEmail()
     * @uses BizAction_Sale_Accounting_CreateDraftInvoiceAction_Request::setItems()
     * @uses BizAction_Sale_Accounting_CreateDraftInvoiceAction_Request::setPurposeId()
     * @uses BizAction_Sale_Accounting_CreateDraftInvoiceAction_Request::setRemark()
     * @uses BizAction_Sale_Accounting_CreateDraftInvoiceAction_Request::setSendByEmailData()
     * @uses BizAction_Sale_Accounting_CreateDraftInvoiceAction_Request::setTargetPrinterId()
     * @uses BizAction_Sale_Accounting_CreateDraftInvoiceAction_Request::setUntilDate()
     * @param bool $calculateCommPerTransaction
     * @param string $clientId
     * @param string $fromDate
     * @param bool $groupByFullPrice
     * @param bool $includeAllItems
     * @param string $includedItemKind
     * @param string $includedSalesItems
     * @param bool $isSendByEmail
     * @param \patest\StructType\RecordSetOfSales_LiabilityItemForDraftInvoice $items
     * @param string $purposeId
     * @param string $remark
     * @param \patest\StructType\Sales_SendByEmailData $sendByEmailData
     * @param string $targetPrinterId
     * @param string $untilDate
     */
    public function __construct($calculateCommPerTransaction = null, $clientId = null, $fromDate = null, $groupByFullPrice = null, $includeAllItems = null, $includedItemKind = null, $includedSalesItems = null, $isSendByEmail = null, \patest\StructType\RecordSetOfSales_LiabilityItemForDraftInvoice $items = null, $purposeId = null, $remark = null, \patest\StructType\Sales_SendByEmailData $sendByEmailData = null, $targetPrinterId = null, $untilDate = null)
    {
        $this
            ->setCalculateCommPerTransaction($calculateCommPerTransaction)
            ->setClientId($clientId)
            ->setFromDate($fromDate)
            ->setGroupByFullPrice($groupByFullPrice)
            ->setIncludeAllItems($includeAllItems)
            ->setIncludedItemKind($includedItemKind)
            ->setIncludedSalesItems($includedSalesItems)
            ->setIsSendByEmail($isSendByEmail)
            ->setItems($items)
            ->setPurposeId($purposeId)
            ->setRemark($remark)
            ->setSendByEmailData($sendByEmailData)
            ->setTargetPrinterId($targetPrinterId)
            ->setUntilDate($untilDate);
    }
    /**
     * Get CalculateCommPerTransaction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCalculateCommPerTransaction()
    {
        return isset($this->CalculateCommPerTransaction) ? $this->CalculateCommPerTransaction : null;
    }
    /**
     * Set CalculateCommPerTransaction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $calculateCommPerTransaction
     * @return \patest\StructType\BizAction_Sale_Accounting_CreateDraftInvoiceAction_Request
     */
    public function setCalculateCommPerTransaction($calculateCommPerTransaction = null)
    {
        // validation for constraint: boolean
        if (!is_null($calculateCommPerTransaction) && !is_bool($calculateCommPerTransaction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($calculateCommPerTransaction, true), gettype($calculateCommPerTransaction)), __LINE__);
        }
        if (is_null($calculateCommPerTransaction) || (is_array($calculateCommPerTransaction) && empty($calculateCommPerTransaction))) {
            unset($this->CalculateCommPerTransaction);
        } else {
            $this->CalculateCommPerTransaction = $calculateCommPerTransaction;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\BizAction_Sale_Accounting_CreateDraftInvoiceAction_Request
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get FromDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFromDate()
    {
        return isset($this->FromDate) ? $this->FromDate : null;
    }
    /**
     * Set FromDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fromDate
     * @return \patest\StructType\BizAction_Sale_Accounting_CreateDraftInvoiceAction_Request
     */
    public function setFromDate($fromDate = null)
    {
        // validation for constraint: string
        if (!is_null($fromDate) && !is_string($fromDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromDate, true), gettype($fromDate)), __LINE__);
        }
        if (is_null($fromDate) || (is_array($fromDate) && empty($fromDate))) {
            unset($this->FromDate);
        } else {
            $this->FromDate = $fromDate;
        }
        return $this;
    }
    /**
     * Get GroupByFullPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getGroupByFullPrice()
    {
        return isset($this->GroupByFullPrice) ? $this->GroupByFullPrice : null;
    }
    /**
     * Set GroupByFullPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $groupByFullPrice
     * @return \patest\StructType\BizAction_Sale_Accounting_CreateDraftInvoiceAction_Request
     */
    public function setGroupByFullPrice($groupByFullPrice = null)
    {
        // validation for constraint: boolean
        if (!is_null($groupByFullPrice) && !is_bool($groupByFullPrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($groupByFullPrice, true), gettype($groupByFullPrice)), __LINE__);
        }
        if (is_null($groupByFullPrice) || (is_array($groupByFullPrice) && empty($groupByFullPrice))) {
            unset($this->GroupByFullPrice);
        } else {
            $this->GroupByFullPrice = $groupByFullPrice;
        }
        return $this;
    }
    /**
     * Get IncludeAllItems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIncludeAllItems()
    {
        return isset($this->IncludeAllItems) ? $this->IncludeAllItems : null;
    }
    /**
     * Set IncludeAllItems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $includeAllItems
     * @return \patest\StructType\BizAction_Sale_Accounting_CreateDraftInvoiceAction_Request
     */
    public function setIncludeAllItems($includeAllItems = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeAllItems) && !is_bool($includeAllItems)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeAllItems, true), gettype($includeAllItems)), __LINE__);
        }
        if (is_null($includeAllItems) || (is_array($includeAllItems) && empty($includeAllItems))) {
            unset($this->IncludeAllItems);
        } else {
            $this->IncludeAllItems = $includeAllItems;
        }
        return $this;
    }
    /**
     * Get IncludedItemKind value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIncludedItemKind()
    {
        return isset($this->IncludedItemKind) ? $this->IncludedItemKind : null;
    }
    /**
     * Set IncludedItemKind value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $includedItemKind
     * @return \patest\StructType\BizAction_Sale_Accounting_CreateDraftInvoiceAction_Request
     */
    public function setIncludedItemKind($includedItemKind = null)
    {
        // validation for constraint: string
        if (!is_null($includedItemKind) && !is_string($includedItemKind)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($includedItemKind, true), gettype($includedItemKind)), __LINE__);
        }
        if (is_null($includedItemKind) || (is_array($includedItemKind) && empty($includedItemKind))) {
            unset($this->IncludedItemKind);
        } else {
            $this->IncludedItemKind = $includedItemKind;
        }
        return $this;
    }
    /**
     * Get IncludedSalesItems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIncludedSalesItems()
    {
        return isset($this->IncludedSalesItems) ? $this->IncludedSalesItems : null;
    }
    /**
     * Set IncludedSalesItems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $includedSalesItems
     * @return \patest\StructType\BizAction_Sale_Accounting_CreateDraftInvoiceAction_Request
     */
    public function setIncludedSalesItems($includedSalesItems = null)
    {
        // validation for constraint: string
        if (!is_null($includedSalesItems) && !is_string($includedSalesItems)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($includedSalesItems, true), gettype($includedSalesItems)), __LINE__);
        }
        if (is_null($includedSalesItems) || (is_array($includedSalesItems) && empty($includedSalesItems))) {
            unset($this->IncludedSalesItems);
        } else {
            $this->IncludedSalesItems = $includedSalesItems;
        }
        return $this;
    }
    /**
     * Get IsSendByEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSendByEmail()
    {
        return isset($this->IsSendByEmail) ? $this->IsSendByEmail : null;
    }
    /**
     * Set IsSendByEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSendByEmail
     * @return \patest\StructType\BizAction_Sale_Accounting_CreateDraftInvoiceAction_Request
     */
    public function setIsSendByEmail($isSendByEmail = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSendByEmail) && !is_bool($isSendByEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSendByEmail, true), gettype($isSendByEmail)), __LINE__);
        }
        if (is_null($isSendByEmail) || (is_array($isSendByEmail) && empty($isSendByEmail))) {
            unset($this->IsSendByEmail);
        } else {
            $this->IsSendByEmail = $isSendByEmail;
        }
        return $this;
    }
    /**
     * Get Items value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfSales_LiabilityItemForDraftInvoice|null
     */
    public function getItems()
    {
        return isset($this->Items) ? $this->Items : null;
    }
    /**
     * Set Items value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfSales_LiabilityItemForDraftInvoice $items
     * @return \patest\StructType\BizAction_Sale_Accounting_CreateDraftInvoiceAction_Request
     */
    public function setItems(\patest\StructType\RecordSetOfSales_LiabilityItemForDraftInvoice $items = null)
    {
        if (is_null($items) || (is_array($items) && empty($items))) {
            unset($this->Items);
        } else {
            $this->Items = $items;
        }
        return $this;
    }
    /**
     * Get PurposeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPurposeId()
    {
        return isset($this->PurposeId) ? $this->PurposeId : null;
    }
    /**
     * Set PurposeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $purposeId
     * @return \patest\StructType\BizAction_Sale_Accounting_CreateDraftInvoiceAction_Request
     */
    public function setPurposeId($purposeId = null)
    {
        // validation for constraint: string
        if (!is_null($purposeId) && !is_string($purposeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purposeId, true), gettype($purposeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($purposeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $purposeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($purposeId, true)), __LINE__);
        }
        if (is_null($purposeId) || (is_array($purposeId) && empty($purposeId))) {
            unset($this->PurposeId);
        } else {
            $this->PurposeId = $purposeId;
        }
        return $this;
    }
    /**
     * Get Remark value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRemark()
    {
        return isset($this->Remark) ? $this->Remark : null;
    }
    /**
     * Set Remark value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $remark
     * @return \patest\StructType\BizAction_Sale_Accounting_CreateDraftInvoiceAction_Request
     */
    public function setRemark($remark = null)
    {
        // validation for constraint: string
        if (!is_null($remark) && !is_string($remark)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remark, true), gettype($remark)), __LINE__);
        }
        if (is_null($remark) || (is_array($remark) && empty($remark))) {
            unset($this->Remark);
        } else {
            $this->Remark = $remark;
        }
        return $this;
    }
    /**
     * Get SendByEmailData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Sales_SendByEmailData|null
     */
    public function getSendByEmailData()
    {
        return isset($this->SendByEmailData) ? $this->SendByEmailData : null;
    }
    /**
     * Set SendByEmailData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Sales_SendByEmailData $sendByEmailData
     * @return \patest\StructType\BizAction_Sale_Accounting_CreateDraftInvoiceAction_Request
     */
    public function setSendByEmailData(\patest\StructType\Sales_SendByEmailData $sendByEmailData = null)
    {
        if (is_null($sendByEmailData) || (is_array($sendByEmailData) && empty($sendByEmailData))) {
            unset($this->SendByEmailData);
        } else {
            $this->SendByEmailData = $sendByEmailData;
        }
        return $this;
    }
    /**
     * Get TargetPrinterId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetPrinterId()
    {
        return isset($this->TargetPrinterId) ? $this->TargetPrinterId : null;
    }
    /**
     * Set TargetPrinterId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetPrinterId
     * @return \patest\StructType\BizAction_Sale_Accounting_CreateDraftInvoiceAction_Request
     */
    public function setTargetPrinterId($targetPrinterId = null)
    {
        // validation for constraint: string
        if (!is_null($targetPrinterId) && !is_string($targetPrinterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetPrinterId, true), gettype($targetPrinterId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($targetPrinterId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $targetPrinterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($targetPrinterId, true)), __LINE__);
        }
        if (is_null($targetPrinterId) || (is_array($targetPrinterId) && empty($targetPrinterId))) {
            unset($this->TargetPrinterId);
        } else {
            $this->TargetPrinterId = $targetPrinterId;
        }
        return $this;
    }
    /**
     * Get UntilDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUntilDate()
    {
        return isset($this->UntilDate) ? $this->UntilDate : null;
    }
    /**
     * Set UntilDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $untilDate
     * @return \patest\StructType\BizAction_Sale_Accounting_CreateDraftInvoiceAction_Request
     */
    public function setUntilDate($untilDate = null)
    {
        // validation for constraint: string
        if (!is_null($untilDate) && !is_string($untilDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($untilDate, true), gettype($untilDate)), __LINE__);
        }
        if (is_null($untilDate) || (is_array($untilDate) && empty($untilDate))) {
            unset($this->UntilDate);
        } else {
            $this->UntilDate = $untilDate;
        }
        return $this;
    }
}
