<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Reporting.Report.SaveParameters.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Reporting_Report_SaveParameters_Request extends AnyEntity
{
    /**
     * The ReportId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ReportId;
    /**
     * The RequestEntityData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RequestEntityData;
    /**
     * The RequestScreenData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RequestScreenData;
    /**
     * Constructor method for BizAction.Reporting.Report.SaveParameters.Request
     * @uses BizAction_Reporting_Report_SaveParameters_Request::setReportId()
     * @uses BizAction_Reporting_Report_SaveParameters_Request::setRequestEntityData()
     * @uses BizAction_Reporting_Report_SaveParameters_Request::setRequestScreenData()
     * @param string $reportId
     * @param string $requestEntityData
     * @param string $requestScreenData
     */
    public function __construct($reportId = null, $requestEntityData = null, $requestScreenData = null)
    {
        $this
            ->setReportId($reportId)
            ->setRequestEntityData($requestEntityData)
            ->setRequestScreenData($requestScreenData);
    }
    /**
     * Get ReportId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReportId()
    {
        return isset($this->ReportId) ? $this->ReportId : null;
    }
    /**
     * Set ReportId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reportId
     * @return \patest\StructType\BizAction_Reporting_Report_SaveParameters_Request
     */
    public function setReportId($reportId = null)
    {
        // validation for constraint: string
        if (!is_null($reportId) && !is_string($reportId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reportId, true), gettype($reportId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($reportId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $reportId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($reportId, true)), __LINE__);
        }
        if (is_null($reportId) || (is_array($reportId) && empty($reportId))) {
            unset($this->ReportId);
        } else {
            $this->ReportId = $reportId;
        }
        return $this;
    }
    /**
     * Get RequestEntityData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestEntityData()
    {
        return isset($this->RequestEntityData) ? $this->RequestEntityData : null;
    }
    /**
     * Set RequestEntityData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestEntityData
     * @return \patest\StructType\BizAction_Reporting_Report_SaveParameters_Request
     */
    public function setRequestEntityData($requestEntityData = null)
    {
        // validation for constraint: string
        if (!is_null($requestEntityData) && !is_string($requestEntityData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestEntityData, true), gettype($requestEntityData)), __LINE__);
        }
        if (is_null($requestEntityData) || (is_array($requestEntityData) && empty($requestEntityData))) {
            unset($this->RequestEntityData);
        } else {
            $this->RequestEntityData = $requestEntityData;
        }
        return $this;
    }
    /**
     * Get RequestScreenData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestScreenData()
    {
        return isset($this->RequestScreenData) ? $this->RequestScreenData : null;
    }
    /**
     * Set RequestScreenData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestScreenData
     * @return \patest\StructType\BizAction_Reporting_Report_SaveParameters_Request
     */
    public function setRequestScreenData($requestScreenData = null)
    {
        // validation for constraint: string
        if (!is_null($requestScreenData) && !is_string($requestScreenData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestScreenData, true), gettype($requestScreenData)), __LINE__);
        }
        if (is_null($requestScreenData) || (is_array($requestScreenData) && empty($requestScreenData))) {
            unset($this->RequestScreenData);
        } else {
            $this->RequestScreenData = $requestScreenData;
        }
        return $this;
    }
}
