<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Reporting.Report.Export.Request StructType
 * @subpackage Structs
 */
class BizAction_Reporting_Report_Export_Request extends AnyEntity
{
    /**
     * The ByUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ByUrl;
    /**
     * The ExportSelectionType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExportSelectionType;
    /**
     * The Path
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Path;
    /**
     * The ReportId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ReportId;
    /**
     * The ReportIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ReportIds
     */
    public $ReportIds;
    /**
     * Constructor method for BizAction.Reporting.Report.Export.Request
     * @uses BizAction_Reporting_Report_Export_Request::setByUrl()
     * @uses BizAction_Reporting_Report_Export_Request::setExportSelectionType()
     * @uses BizAction_Reporting_Report_Export_Request::setPath()
     * @uses BizAction_Reporting_Report_Export_Request::setReportId()
     * @uses BizAction_Reporting_Report_Export_Request::setReportIds()
     * @param bool $byUrl
     * @param string $exportSelectionType
     * @param string $path
     * @param string $reportId
     * @param \patest\StructType\ReportIds $reportIds
     */
    public function __construct($byUrl = null, $exportSelectionType = null, $path = null, $reportId = null, \patest\StructType\ReportIds $reportIds = null)
    {
        $this
            ->setByUrl($byUrl)
            ->setExportSelectionType($exportSelectionType)
            ->setPath($path)
            ->setReportId($reportId)
            ->setReportIds($reportIds);
    }
    /**
     * Get ByUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getByUrl()
    {
        return isset($this->ByUrl) ? $this->ByUrl : null;
    }
    /**
     * Set ByUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $byUrl
     * @return \patest\StructType\BizAction_Reporting_Report_Export_Request
     */
    public function setByUrl($byUrl = null)
    {
        // validation for constraint: boolean
        if (!is_null($byUrl) && !is_bool($byUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($byUrl, true), gettype($byUrl)), __LINE__);
        }
        if (is_null($byUrl) || (is_array($byUrl) && empty($byUrl))) {
            unset($this->ByUrl);
        } else {
            $this->ByUrl = $byUrl;
        }
        return $this;
    }
    /**
     * Get ExportSelectionType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExportSelectionType()
    {
        return isset($this->ExportSelectionType) ? $this->ExportSelectionType : null;
    }
    /**
     * Set ExportSelectionType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ExportSelectionType::valueIsValid()
     * @uses \patest\EnumType\ExportSelectionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $exportSelectionType
     * @return \patest\StructType\BizAction_Reporting_Report_Export_Request
     */
    public function setExportSelectionType($exportSelectionType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ExportSelectionType::valueIsValid($exportSelectionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ExportSelectionType', is_array($exportSelectionType) ? implode(', ', $exportSelectionType) : var_export($exportSelectionType, true), implode(', ', \patest\EnumType\ExportSelectionType::getValidValues())), __LINE__);
        }
        if (is_null($exportSelectionType) || (is_array($exportSelectionType) && empty($exportSelectionType))) {
            unset($this->ExportSelectionType);
        } else {
            $this->ExportSelectionType = $exportSelectionType;
        }
        return $this;
    }
    /**
     * Get Path value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPath()
    {
        return isset($this->Path) ? $this->Path : null;
    }
    /**
     * Set Path value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $path
     * @return \patest\StructType\BizAction_Reporting_Report_Export_Request
     */
    public function setPath($path = null)
    {
        // validation for constraint: string
        if (!is_null($path) && !is_string($path)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($path, true), gettype($path)), __LINE__);
        }
        if (is_null($path) || (is_array($path) && empty($path))) {
            unset($this->Path);
        } else {
            $this->Path = $path;
        }
        return $this;
    }
    /**
     * Get ReportId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReportId()
    {
        return isset($this->ReportId) ? $this->ReportId : null;
    }
    /**
     * Set ReportId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reportId
     * @return \patest\StructType\BizAction_Reporting_Report_Export_Request
     */
    public function setReportId($reportId = null)
    {
        // validation for constraint: string
        if (!is_null($reportId) && !is_string($reportId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reportId, true), gettype($reportId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($reportId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $reportId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($reportId, true)), __LINE__);
        }
        if (is_null($reportId) || (is_array($reportId) && empty($reportId))) {
            unset($this->ReportId);
        } else {
            $this->ReportId = $reportId;
        }
        return $this;
    }
    /**
     * Get ReportIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ReportIds|null
     */
    public function getReportIds()
    {
        return isset($this->ReportIds) ? $this->ReportIds : null;
    }
    /**
     * Set ReportIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ReportIds $reportIds
     * @return \patest\StructType\BizAction_Reporting_Report_Export_Request
     */
    public function setReportIds(\patest\StructType\ReportIds $reportIds = null)
    {
        if (is_null($reportIds) || (is_array($reportIds) && empty($reportIds))) {
            unset($this->ReportIds);
        } else {
            $this->ReportIds = $reportIds;
        }
        return $this;
    }
}
