<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Printing.BatchPrint.Transactions.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Printing_BatchPrint_Transactions_Request extends BizAction_Printing_BatchPrint_Request_Base
{
    /**
     * The BatchTransactionStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BatchTransactionStatus;
    /**
     * The TransactionsSorting
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransactionsSorting;
    /**
     * Constructor method for BizAction.Printing.BatchPrint.Transactions.Request
     * @uses BizAction_Printing_BatchPrint_Transactions_Request::setBatchTransactionStatus()
     * @uses BizAction_Printing_BatchPrint_Transactions_Request::setTransactionsSorting()
     * @param string $batchTransactionStatus
     * @param string $transactionsSorting
     */
    public function __construct($batchTransactionStatus = null, $transactionsSorting = null)
    {
        $this
            ->setBatchTransactionStatus($batchTransactionStatus)
            ->setTransactionsSorting($transactionsSorting);
    }
    /**
     * Get BatchTransactionStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBatchTransactionStatus()
    {
        return isset($this->BatchTransactionStatus) ? $this->BatchTransactionStatus : null;
    }
    /**
     * Set BatchTransactionStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\TransactionStatus::valueIsValid()
     * @uses \patest\EnumType\TransactionStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $batchTransactionStatus
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Transactions_Request
     */
    public function setBatchTransactionStatus($batchTransactionStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TransactionStatus::valueIsValid($batchTransactionStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TransactionStatus', is_array($batchTransactionStatus) ? implode(', ', $batchTransactionStatus) : var_export($batchTransactionStatus, true), implode(', ', \patest\EnumType\TransactionStatus::getValidValues())), __LINE__);
        }
        if (is_null($batchTransactionStatus) || (is_array($batchTransactionStatus) && empty($batchTransactionStatus))) {
            unset($this->BatchTransactionStatus);
        } else {
            $this->BatchTransactionStatus = $batchTransactionStatus;
        }
        return $this;
    }
    /**
     * Get TransactionsSorting value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionsSorting()
    {
        return isset($this->TransactionsSorting) ? $this->TransactionsSorting : null;
    }
    /**
     * Set TransactionsSorting value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\BatchPrintTransactionsSorting::valueIsValid()
     * @uses \patest\EnumType\BatchPrintTransactionsSorting::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transactionsSorting
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Transactions_Request
     */
    public function setTransactionsSorting($transactionsSorting = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BatchPrintTransactionsSorting::valueIsValid($transactionsSorting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BatchPrintTransactionsSorting', is_array($transactionsSorting) ? implode(', ', $transactionsSorting) : var_export($transactionsSorting, true), implode(', ', \patest\EnumType\BatchPrintTransactionsSorting::getValidValues())), __LINE__);
        }
        if (is_null($transactionsSorting) || (is_array($transactionsSorting) && empty($transactionsSorting))) {
            unset($this->TransactionsSorting);
        } else {
            $this->TransactionsSorting = $transactionsSorting;
        }
        return $this;
    }
}
