<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Printing.AddPrinterToPrinterServer.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Printing_AddPrinterToPrinterServer_Request extends AnyEntity
{
    /**
     * The PhysicalPrinterPath
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PhysicalPrinterPath;
    /**
     * The PrintServerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PrintServerId;
    /**
     * Constructor method for BizAction.Printing.AddPrinterToPrinterServer.Request
     * @uses BizAction_Printing_AddPrinterToPrinterServer_Request::setPhysicalPrinterPath()
     * @uses BizAction_Printing_AddPrinterToPrinterServer_Request::setPrintServerId()
     * @param string $physicalPrinterPath
     * @param string $printServerId
     */
    public function __construct($physicalPrinterPath = null, $printServerId = null)
    {
        $this
            ->setPhysicalPrinterPath($physicalPrinterPath)
            ->setPrintServerId($printServerId);
    }
    /**
     * Get PhysicalPrinterPath value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPhysicalPrinterPath()
    {
        return isset($this->PhysicalPrinterPath) ? $this->PhysicalPrinterPath : null;
    }
    /**
     * Set PhysicalPrinterPath value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $physicalPrinterPath
     * @return \patest\StructType\BizAction_Printing_AddPrinterToPrinterServer_Request
     */
    public function setPhysicalPrinterPath($physicalPrinterPath = null)
    {
        // validation for constraint: string
        if (!is_null($physicalPrinterPath) && !is_string($physicalPrinterPath)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($physicalPrinterPath, true), gettype($physicalPrinterPath)), __LINE__);
        }
        if (is_null($physicalPrinterPath) || (is_array($physicalPrinterPath) && empty($physicalPrinterPath))) {
            unset($this->PhysicalPrinterPath);
        } else {
            $this->PhysicalPrinterPath = $physicalPrinterPath;
        }
        return $this;
    }
    /**
     * Get PrintServerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrintServerId()
    {
        return isset($this->PrintServerId) ? $this->PrintServerId : null;
    }
    /**
     * Set PrintServerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $printServerId
     * @return \patest\StructType\BizAction_Printing_AddPrinterToPrinterServer_Request
     */
    public function setPrintServerId($printServerId = null)
    {
        // validation for constraint: string
        if (!is_null($printServerId) && !is_string($printServerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($printServerId, true), gettype($printServerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($printServerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $printServerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($printServerId, true)), __LINE__);
        }
        if (is_null($printServerId) || (is_array($printServerId) && empty($printServerId))) {
            unset($this->PrintServerId);
        } else {
            $this->PrintServerId = $printServerId;
        }
        return $this;
    }
}
