<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Payment.CreateOnlinePaymentToken.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Payment_CreateOnlinePaymentToken_Request extends AnyEntity
{
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The IsSelectableByClient
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSelectableByClient;
    /**
     * The IsTokenCreationFailed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsTokenCreationFailed;
    /**
     * The PaymentMethodId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentMethodId;
    /**
     * The ProviderSpecificData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ProviderSpecificData
     */
    public $ProviderSpecificData;
    /**
     * The ProviderSpecificTokenId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ProviderSpecificTokenId;
    /**
     * The UserInteractionMarkup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserInteractionMarkup;
    /**
     * The UserInteractionUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserInteractionUrl;
    /**
     * Constructor method for BizAction.Payment.CreateOnlinePaymentToken.Request
     * @uses BizAction_Payment_CreateOnlinePaymentToken_Request::setClientId()
     * @uses BizAction_Payment_CreateOnlinePaymentToken_Request::setIsSelectableByClient()
     * @uses BizAction_Payment_CreateOnlinePaymentToken_Request::setIsTokenCreationFailed()
     * @uses BizAction_Payment_CreateOnlinePaymentToken_Request::setPaymentMethodId()
     * @uses BizAction_Payment_CreateOnlinePaymentToken_Request::setProviderSpecificData()
     * @uses BizAction_Payment_CreateOnlinePaymentToken_Request::setProviderSpecificTokenId()
     * @uses BizAction_Payment_CreateOnlinePaymentToken_Request::setUserInteractionMarkup()
     * @uses BizAction_Payment_CreateOnlinePaymentToken_Request::setUserInteractionUrl()
     * @param string $clientId
     * @param bool $isSelectableByClient
     * @param bool $isTokenCreationFailed
     * @param string $paymentMethodId
     * @param \patest\StructType\ProviderSpecificData $providerSpecificData
     * @param string $providerSpecificTokenId
     * @param string $userInteractionMarkup
     * @param string $userInteractionUrl
     */
    public function __construct($clientId = null, $isSelectableByClient = null, $isTokenCreationFailed = null, $paymentMethodId = null, \patest\StructType\ProviderSpecificData $providerSpecificData = null, $providerSpecificTokenId = null, $userInteractionMarkup = null, $userInteractionUrl = null)
    {
        $this
            ->setClientId($clientId)
            ->setIsSelectableByClient($isSelectableByClient)
            ->setIsTokenCreationFailed($isTokenCreationFailed)
            ->setPaymentMethodId($paymentMethodId)
            ->setProviderSpecificData($providerSpecificData)
            ->setProviderSpecificTokenId($providerSpecificTokenId)
            ->setUserInteractionMarkup($userInteractionMarkup)
            ->setUserInteractionUrl($userInteractionUrl);
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\BizAction_Payment_CreateOnlinePaymentToken_Request
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get IsSelectableByClient value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSelectableByClient()
    {
        return isset($this->IsSelectableByClient) ? $this->IsSelectableByClient : null;
    }
    /**
     * Set IsSelectableByClient value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSelectableByClient
     * @return \patest\StructType\BizAction_Payment_CreateOnlinePaymentToken_Request
     */
    public function setIsSelectableByClient($isSelectableByClient = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSelectableByClient) && !is_bool($isSelectableByClient)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSelectableByClient, true), gettype($isSelectableByClient)), __LINE__);
        }
        if (is_null($isSelectableByClient) || (is_array($isSelectableByClient) && empty($isSelectableByClient))) {
            unset($this->IsSelectableByClient);
        } else {
            $this->IsSelectableByClient = $isSelectableByClient;
        }
        return $this;
    }
    /**
     * Get IsTokenCreationFailed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsTokenCreationFailed()
    {
        return isset($this->IsTokenCreationFailed) ? $this->IsTokenCreationFailed : null;
    }
    /**
     * Set IsTokenCreationFailed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isTokenCreationFailed
     * @return \patest\StructType\BizAction_Payment_CreateOnlinePaymentToken_Request
     */
    public function setIsTokenCreationFailed($isTokenCreationFailed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTokenCreationFailed) && !is_bool($isTokenCreationFailed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isTokenCreationFailed, true), gettype($isTokenCreationFailed)), __LINE__);
        }
        if (is_null($isTokenCreationFailed) || (is_array($isTokenCreationFailed) && empty($isTokenCreationFailed))) {
            unset($this->IsTokenCreationFailed);
        } else {
            $this->IsTokenCreationFailed = $isTokenCreationFailed;
        }
        return $this;
    }
    /**
     * Get PaymentMethodId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodId()
    {
        return isset($this->PaymentMethodId) ? $this->PaymentMethodId : null;
    }
    /**
     * Set PaymentMethodId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMethodId
     * @return \patest\StructType\BizAction_Payment_CreateOnlinePaymentToken_Request
     */
    public function setPaymentMethodId($paymentMethodId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodId) && !is_string($paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodId, true), gettype($paymentMethodId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentMethodId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentMethodId, true)), __LINE__);
        }
        if (is_null($paymentMethodId) || (is_array($paymentMethodId) && empty($paymentMethodId))) {
            unset($this->PaymentMethodId);
        } else {
            $this->PaymentMethodId = $paymentMethodId;
        }
        return $this;
    }
    /**
     * Get ProviderSpecificData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ProviderSpecificData|null
     */
    public function getProviderSpecificData()
    {
        return isset($this->ProviderSpecificData) ? $this->ProviderSpecificData : null;
    }
    /**
     * Set ProviderSpecificData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ProviderSpecificData $providerSpecificData
     * @return \patest\StructType\BizAction_Payment_CreateOnlinePaymentToken_Request
     */
    public function setProviderSpecificData(\patest\StructType\ProviderSpecificData $providerSpecificData = null)
    {
        if (is_null($providerSpecificData) || (is_array($providerSpecificData) && empty($providerSpecificData))) {
            unset($this->ProviderSpecificData);
        } else {
            $this->ProviderSpecificData = $providerSpecificData;
        }
        return $this;
    }
    /**
     * Get ProviderSpecificTokenId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProviderSpecificTokenId()
    {
        return isset($this->ProviderSpecificTokenId) ? $this->ProviderSpecificTokenId : null;
    }
    /**
     * Set ProviderSpecificTokenId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $providerSpecificTokenId
     * @return \patest\StructType\BizAction_Payment_CreateOnlinePaymentToken_Request
     */
    public function setProviderSpecificTokenId($providerSpecificTokenId = null)
    {
        // validation for constraint: string
        if (!is_null($providerSpecificTokenId) && !is_string($providerSpecificTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($providerSpecificTokenId, true), gettype($providerSpecificTokenId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($providerSpecificTokenId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $providerSpecificTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($providerSpecificTokenId, true)), __LINE__);
        }
        if (is_null($providerSpecificTokenId) || (is_array($providerSpecificTokenId) && empty($providerSpecificTokenId))) {
            unset($this->ProviderSpecificTokenId);
        } else {
            $this->ProviderSpecificTokenId = $providerSpecificTokenId;
        }
        return $this;
    }
    /**
     * Get UserInteractionMarkup value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserInteractionMarkup()
    {
        return isset($this->UserInteractionMarkup) ? $this->UserInteractionMarkup : null;
    }
    /**
     * Set UserInteractionMarkup value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userInteractionMarkup
     * @return \patest\StructType\BizAction_Payment_CreateOnlinePaymentToken_Request
     */
    public function setUserInteractionMarkup($userInteractionMarkup = null)
    {
        // validation for constraint: string
        if (!is_null($userInteractionMarkup) && !is_string($userInteractionMarkup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userInteractionMarkup, true), gettype($userInteractionMarkup)), __LINE__);
        }
        if (is_null($userInteractionMarkup) || (is_array($userInteractionMarkup) && empty($userInteractionMarkup))) {
            unset($this->UserInteractionMarkup);
        } else {
            $this->UserInteractionMarkup = $userInteractionMarkup;
        }
        return $this;
    }
    /**
     * Get UserInteractionUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserInteractionUrl()
    {
        return isset($this->UserInteractionUrl) ? $this->UserInteractionUrl : null;
    }
    /**
     * Set UserInteractionUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userInteractionUrl
     * @return \patest\StructType\BizAction_Payment_CreateOnlinePaymentToken_Request
     */
    public function setUserInteractionUrl($userInteractionUrl = null)
    {
        // validation for constraint: string
        if (!is_null($userInteractionUrl) && !is_string($userInteractionUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userInteractionUrl, true), gettype($userInteractionUrl)), __LINE__);
        }
        if (is_null($userInteractionUrl) || (is_array($userInteractionUrl) && empty($userInteractionUrl))) {
            unset($this->UserInteractionUrl);
        } else {
            $this->UserInteractionUrl = $userInteractionUrl;
        }
        return $this;
    }
}
