<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Payment.BINCodesBatchOperation.PreviewItem
 * StructType
 * @subpackage Structs
 */
class BizAction_Payment_BINCodesBatchOperation_PreviewItem extends AnyEntity
{
    /**
     * The BINCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BINCode;
    /**
     * The CardName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardName;
    /**
     * The CardType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardType;
    /**
     * The IsValid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsValid;
    /**
     * The ValidationMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ValidationMessage;
    /**
     * Constructor method for BizAction.Payment.BINCodesBatchOperation.PreviewItem
     * @uses BizAction_Payment_BINCodesBatchOperation_PreviewItem::setBINCode()
     * @uses BizAction_Payment_BINCodesBatchOperation_PreviewItem::setCardName()
     * @uses BizAction_Payment_BINCodesBatchOperation_PreviewItem::setCardType()
     * @uses BizAction_Payment_BINCodesBatchOperation_PreviewItem::setIsValid()
     * @uses BizAction_Payment_BINCodesBatchOperation_PreviewItem::setValidationMessage()
     * @param string $bINCode
     * @param string $cardName
     * @param string $cardType
     * @param bool $isValid
     * @param string $validationMessage
     */
    public function __construct($bINCode = null, $cardName = null, $cardType = null, $isValid = null, $validationMessage = null)
    {
        $this
            ->setBINCode($bINCode)
            ->setCardName($cardName)
            ->setCardType($cardType)
            ->setIsValid($isValid)
            ->setValidationMessage($validationMessage);
    }
    /**
     * Get BINCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBINCode()
    {
        return isset($this->BINCode) ? $this->BINCode : null;
    }
    /**
     * Set BINCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bINCode
     * @return \patest\StructType\BizAction_Payment_BINCodesBatchOperation_PreviewItem
     */
    public function setBINCode($bINCode = null)
    {
        // validation for constraint: string
        if (!is_null($bINCode) && !is_string($bINCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bINCode, true), gettype($bINCode)), __LINE__);
        }
        if (is_null($bINCode) || (is_array($bINCode) && empty($bINCode))) {
            unset($this->BINCode);
        } else {
            $this->BINCode = $bINCode;
        }
        return $this;
    }
    /**
     * Get CardName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardName()
    {
        return isset($this->CardName) ? $this->CardName : null;
    }
    /**
     * Set CardName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardName
     * @return \patest\StructType\BizAction_Payment_BINCodesBatchOperation_PreviewItem
     */
    public function setCardName($cardName = null)
    {
        // validation for constraint: string
        if (!is_null($cardName) && !is_string($cardName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardName, true), gettype($cardName)), __LINE__);
        }
        if (is_null($cardName) || (is_array($cardName) && empty($cardName))) {
            unset($this->CardName);
        } else {
            $this->CardName = $cardName;
        }
        return $this;
    }
    /**
     * Get CardType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardType()
    {
        return isset($this->CardType) ? $this->CardType : null;
    }
    /**
     * Set CardType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\CreditCardTypeKind::valueIsValid()
     * @uses \patest\EnumType\CreditCardTypeKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $cardType
     * @return \patest\StructType\BizAction_Payment_BINCodesBatchOperation_PreviewItem
     */
    public function setCardType($cardType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\CreditCardTypeKind::valueIsValid($cardType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\CreditCardTypeKind', is_array($cardType) ? implode(', ', $cardType) : var_export($cardType, true), implode(', ', \patest\EnumType\CreditCardTypeKind::getValidValues())), __LINE__);
        }
        if (is_null($cardType) || (is_array($cardType) && empty($cardType))) {
            unset($this->CardType);
        } else {
            $this->CardType = $cardType;
        }
        return $this;
    }
    /**
     * Get IsValid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsValid()
    {
        return isset($this->IsValid) ? $this->IsValid : null;
    }
    /**
     * Set IsValid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isValid
     * @return \patest\StructType\BizAction_Payment_BINCodesBatchOperation_PreviewItem
     */
    public function setIsValid($isValid = null)
    {
        // validation for constraint: boolean
        if (!is_null($isValid) && !is_bool($isValid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isValid, true), gettype($isValid)), __LINE__);
        }
        if (is_null($isValid) || (is_array($isValid) && empty($isValid))) {
            unset($this->IsValid);
        } else {
            $this->IsValid = $isValid;
        }
        return $this;
    }
    /**
     * Get ValidationMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValidationMessage()
    {
        return isset($this->ValidationMessage) ? $this->ValidationMessage : null;
    }
    /**
     * Set ValidationMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $validationMessage
     * @return \patest\StructType\BizAction_Payment_BINCodesBatchOperation_PreviewItem
     */
    public function setValidationMessage($validationMessage = null)
    {
        // validation for constraint: string
        if (!is_null($validationMessage) && !is_string($validationMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validationMessage, true), gettype($validationMessage)), __LINE__);
        }
        if (is_null($validationMessage) || (is_array($validationMessage) && empty($validationMessage))) {
            unset($this->ValidationMessage);
        } else {
            $this->ValidationMessage = $validationMessage;
        }
        return $this;
    }
}
