<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Merchandise.PrintInventoryForm.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Merchandise_PrintInventoryForm_Request extends BizAction_Merchandise_Print_BaseRequest
{
    /**
     * The FormId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $FormId;
    /**
     * Constructor method for BizAction.Merchandise.PrintInventoryForm.Request
     * @uses BizAction_Merchandise_PrintInventoryForm_Request::setFormId()
     * @param string $formId
     */
    public function __construct($formId = null)
    {
        $this
            ->setFormId($formId);
    }
    /**
     * Get FormId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFormId()
    {
        return isset($this->FormId) ? $this->FormId : null;
    }
    /**
     * Set FormId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $formId
     * @return \patest\StructType\BizAction_Merchandise_PrintInventoryForm_Request
     */
    public function setFormId($formId = null)
    {
        // validation for constraint: string
        if (!is_null($formId) && !is_string($formId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($formId, true), gettype($formId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($formId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $formId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($formId, true)), __LINE__);
        }
        if (is_null($formId) || (is_array($formId) && empty($formId))) {
            unset($this->FormId);
        } else {
            $this->FormId = $formId;
        }
        return $this;
    }
}
