<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Merchandise.PrintInventoryBarcodes.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Merchandise_PrintInventoryBarcodes_Request extends BizAction_Merchandise_Print_BaseRequest
{
    /**
     * The BarcodesCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $BarcodesCount;
    /**
     * The MerchandiseId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MerchandiseId;
    /**
     * The PrintTestPage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $PrintTestPage;
    /**
     * The SelectedAdditionalMerchandiseBarcode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SelectedAdditionalMerchandiseBarcode;
    /**
     * Constructor method for BizAction.Merchandise.PrintInventoryBarcodes.Request
     * @uses BizAction_Merchandise_PrintInventoryBarcodes_Request::setBarcodesCount()
     * @uses BizAction_Merchandise_PrintInventoryBarcodes_Request::setMerchandiseId()
     * @uses BizAction_Merchandise_PrintInventoryBarcodes_Request::setPrintTestPage()
     * @uses BizAction_Merchandise_PrintInventoryBarcodes_Request::setSelectedAdditionalMerchandiseBarcode()
     * @param int $barcodesCount
     * @param string $merchandiseId
     * @param bool $printTestPage
     * @param string $selectedAdditionalMerchandiseBarcode
     */
    public function __construct($barcodesCount = null, $merchandiseId = null, $printTestPage = null, $selectedAdditionalMerchandiseBarcode = null)
    {
        $this
            ->setBarcodesCount($barcodesCount)
            ->setMerchandiseId($merchandiseId)
            ->setPrintTestPage($printTestPage)
            ->setSelectedAdditionalMerchandiseBarcode($selectedAdditionalMerchandiseBarcode);
    }
    /**
     * Get BarcodesCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getBarcodesCount()
    {
        return isset($this->BarcodesCount) ? $this->BarcodesCount : null;
    }
    /**
     * Set BarcodesCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $barcodesCount
     * @return \patest\StructType\BizAction_Merchandise_PrintInventoryBarcodes_Request
     */
    public function setBarcodesCount($barcodesCount = null)
    {
        // validation for constraint: int
        if (!is_null($barcodesCount) && !(is_int($barcodesCount) || ctype_digit($barcodesCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($barcodesCount, true), gettype($barcodesCount)), __LINE__);
        }
        if (is_null($barcodesCount) || (is_array($barcodesCount) && empty($barcodesCount))) {
            unset($this->BarcodesCount);
        } else {
            $this->BarcodesCount = $barcodesCount;
        }
        return $this;
    }
    /**
     * Get MerchandiseId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMerchandiseId()
    {
        return isset($this->MerchandiseId) ? $this->MerchandiseId : null;
    }
    /**
     * Set MerchandiseId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $merchandiseId
     * @return \patest\StructType\BizAction_Merchandise_PrintInventoryBarcodes_Request
     */
    public function setMerchandiseId($merchandiseId = null)
    {
        // validation for constraint: string
        if (!is_null($merchandiseId) && !is_string($merchandiseId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($merchandiseId, true), gettype($merchandiseId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($merchandiseId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $merchandiseId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($merchandiseId, true)), __LINE__);
        }
        if (is_null($merchandiseId) || (is_array($merchandiseId) && empty($merchandiseId))) {
            unset($this->MerchandiseId);
        } else {
            $this->MerchandiseId = $merchandiseId;
        }
        return $this;
    }
    /**
     * Get PrintTestPage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPrintTestPage()
    {
        return isset($this->PrintTestPage) ? $this->PrintTestPage : null;
    }
    /**
     * Set PrintTestPage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $printTestPage
     * @return \patest\StructType\BizAction_Merchandise_PrintInventoryBarcodes_Request
     */
    public function setPrintTestPage($printTestPage = null)
    {
        // validation for constraint: boolean
        if (!is_null($printTestPage) && !is_bool($printTestPage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($printTestPage, true), gettype($printTestPage)), __LINE__);
        }
        if (is_null($printTestPage) || (is_array($printTestPage) && empty($printTestPage))) {
            unset($this->PrintTestPage);
        } else {
            $this->PrintTestPage = $printTestPage;
        }
        return $this;
    }
    /**
     * Get SelectedAdditionalMerchandiseBarcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSelectedAdditionalMerchandiseBarcode()
    {
        return isset($this->SelectedAdditionalMerchandiseBarcode) ? $this->SelectedAdditionalMerchandiseBarcode : null;
    }
    /**
     * Set SelectedAdditionalMerchandiseBarcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $selectedAdditionalMerchandiseBarcode
     * @return \patest\StructType\BizAction_Merchandise_PrintInventoryBarcodes_Request
     */
    public function setSelectedAdditionalMerchandiseBarcode($selectedAdditionalMerchandiseBarcode = null)
    {
        // validation for constraint: string
        if (!is_null($selectedAdditionalMerchandiseBarcode) && !is_string($selectedAdditionalMerchandiseBarcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($selectedAdditionalMerchandiseBarcode, true), gettype($selectedAdditionalMerchandiseBarcode)), __LINE__);
        }
        if (is_null($selectedAdditionalMerchandiseBarcode) || (is_array($selectedAdditionalMerchandiseBarcode) && empty($selectedAdditionalMerchandiseBarcode))) {
            unset($this->SelectedAdditionalMerchandiseBarcode);
        } else {
            $this->SelectedAdditionalMerchandiseBarcode = $selectedAdditionalMerchandiseBarcode;
        }
        return $this;
    }
}
