<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * BizAction.Merchandise.LoadSupplierOrderToTransferInForm.Request StructType
 * @subpackage Structs
 */
class BizAction_Merchandise_LoadSupplierOrderToTransferInForm_Request extends AnyEntity
{
    /**
     * The FormHeaderId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $FormHeaderId;
    /**
     * The SupplierId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SupplierId;
    /**
     * The SupplierOrderFormId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SupplierOrderFormId;
    /**
     * Constructor method for
     * BizAction.Merchandise.LoadSupplierOrderToTransferInForm.Request
     * @uses BizAction_Merchandise_LoadSupplierOrderToTransferInForm_Request::setFormHeaderId()
     * @uses BizAction_Merchandise_LoadSupplierOrderToTransferInForm_Request::setSupplierId()
     * @uses BizAction_Merchandise_LoadSupplierOrderToTransferInForm_Request::setSupplierOrderFormId()
     * @param string $formHeaderId
     * @param string $supplierId
     * @param string $supplierOrderFormId
     */
    public function __construct($formHeaderId = null, $supplierId = null, $supplierOrderFormId = null)
    {
        $this
            ->setFormHeaderId($formHeaderId)
            ->setSupplierId($supplierId)
            ->setSupplierOrderFormId($supplierOrderFormId);
    }
    /**
     * Get FormHeaderId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFormHeaderId()
    {
        return isset($this->FormHeaderId) ? $this->FormHeaderId : null;
    }
    /**
     * Set FormHeaderId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $formHeaderId
     * @return \patest\StructType\BizAction_Merchandise_LoadSupplierOrderToTransferInForm_Request
     */
    public function setFormHeaderId($formHeaderId = null)
    {
        // validation for constraint: string
        if (!is_null($formHeaderId) && !is_string($formHeaderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($formHeaderId, true), gettype($formHeaderId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($formHeaderId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $formHeaderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($formHeaderId, true)), __LINE__);
        }
        if (is_null($formHeaderId) || (is_array($formHeaderId) && empty($formHeaderId))) {
            unset($this->FormHeaderId);
        } else {
            $this->FormHeaderId = $formHeaderId;
        }
        return $this;
    }
    /**
     * Get SupplierId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSupplierId()
    {
        return isset($this->SupplierId) ? $this->SupplierId : null;
    }
    /**
     * Set SupplierId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $supplierId
     * @return \patest\StructType\BizAction_Merchandise_LoadSupplierOrderToTransferInForm_Request
     */
    public function setSupplierId($supplierId = null)
    {
        // validation for constraint: string
        if (!is_null($supplierId) && !is_string($supplierId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierId, true), gettype($supplierId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($supplierId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $supplierId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($supplierId, true)), __LINE__);
        }
        if (is_null($supplierId) || (is_array($supplierId) && empty($supplierId))) {
            unset($this->SupplierId);
        } else {
            $this->SupplierId = $supplierId;
        }
        return $this;
    }
    /**
     * Get SupplierOrderFormId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSupplierOrderFormId()
    {
        return isset($this->SupplierOrderFormId) ? $this->SupplierOrderFormId : null;
    }
    /**
     * Set SupplierOrderFormId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $supplierOrderFormId
     * @return \patest\StructType\BizAction_Merchandise_LoadSupplierOrderToTransferInForm_Request
     */
    public function setSupplierOrderFormId($supplierOrderFormId = null)
    {
        // validation for constraint: string
        if (!is_null($supplierOrderFormId) && !is_string($supplierOrderFormId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierOrderFormId, true), gettype($supplierOrderFormId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($supplierOrderFormId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $supplierOrderFormId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($supplierOrderFormId, true)), __LINE__);
        }
        if (is_null($supplierOrderFormId) || (is_array($supplierOrderFormId) && empty($supplierOrderFormId))) {
            unset($this->SupplierOrderFormId);
        } else {
            $this->SupplierOrderFormId = $supplierOrderFormId;
        }
        return $this;
    }
}
