<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * BizAction.Membership.ProcessMembershipAutoRenewBatch.Request StructType
 * @subpackage Structs
 */
class BizAction_Membership_ProcessMembershipAutoRenewBatch_Request extends AnyEntity
{
    /**
     * The AllowNonActivePaymentMethods
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AllowNonActivePaymentMethods;
    /**
     * The BatchId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BatchId;
    /**
     * The ClientTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientTypes;
    /**
     * The EnrollmentsCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $EnrollmentsCount;
    /**
     * The FromDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FromDate;
    /**
     * The IsFromScheduledAutoRenewal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsFromScheduledAutoRenewal;
    /**
     * The IsVerificationOnly
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsVerificationOnly;
    /**
     * The MaxMembershipsToRenew
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxMembershipsToRenew;
    /**
     * The MaxMembershipsToTest
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxMembershipsToTest;
    /**
     * The PaymentMethods
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentMethods;
    /**
     * The PendingCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PendingCount;
    /**
     * The PriceTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PriceTypes;
    /**
     * The SkipFailed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SkipFailed;
    /**
     * The SkipPreviouslyFailedTesting
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SkipPreviouslyFailedTesting;
    /**
     * The SkipPreviouslyVerified
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SkipPreviouslyVerified;
    /**
     * The TargetPaymentMethod
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TargetPaymentMethod;
    /**
     * The ToDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ToDate;
    /**
     * Constructor method for
     * BizAction.Membership.ProcessMembershipAutoRenewBatch.Request
     * @uses BizAction_Membership_ProcessMembershipAutoRenewBatch_Request::setAllowNonActivePaymentMethods()
     * @uses BizAction_Membership_ProcessMembershipAutoRenewBatch_Request::setBatchId()
     * @uses BizAction_Membership_ProcessMembershipAutoRenewBatch_Request::setClientTypes()
     * @uses BizAction_Membership_ProcessMembershipAutoRenewBatch_Request::setEnrollmentsCount()
     * @uses BizAction_Membership_ProcessMembershipAutoRenewBatch_Request::setFromDate()
     * @uses BizAction_Membership_ProcessMembershipAutoRenewBatch_Request::setIsFromScheduledAutoRenewal()
     * @uses BizAction_Membership_ProcessMembershipAutoRenewBatch_Request::setIsVerificationOnly()
     * @uses BizAction_Membership_ProcessMembershipAutoRenewBatch_Request::setMaxMembershipsToRenew()
     * @uses BizAction_Membership_ProcessMembershipAutoRenewBatch_Request::setMaxMembershipsToTest()
     * @uses BizAction_Membership_ProcessMembershipAutoRenewBatch_Request::setPaymentMethods()
     * @uses BizAction_Membership_ProcessMembershipAutoRenewBatch_Request::setPendingCount()
     * @uses BizAction_Membership_ProcessMembershipAutoRenewBatch_Request::setPriceTypes()
     * @uses BizAction_Membership_ProcessMembershipAutoRenewBatch_Request::setSkipFailed()
     * @uses BizAction_Membership_ProcessMembershipAutoRenewBatch_Request::setSkipPreviouslyFailedTesting()
     * @uses BizAction_Membership_ProcessMembershipAutoRenewBatch_Request::setSkipPreviouslyVerified()
     * @uses BizAction_Membership_ProcessMembershipAutoRenewBatch_Request::setTargetPaymentMethod()
     * @uses BizAction_Membership_ProcessMembershipAutoRenewBatch_Request::setToDate()
     * @param bool $allowNonActivePaymentMethods
     * @param string $batchId
     * @param string $clientTypes
     * @param int $enrollmentsCount
     * @param string $fromDate
     * @param bool $isFromScheduledAutoRenewal
     * @param bool $isVerificationOnly
     * @param int $maxMembershipsToRenew
     * @param int $maxMembershipsToTest
     * @param string $paymentMethods
     * @param int $pendingCount
     * @param string $priceTypes
     * @param bool $skipFailed
     * @param bool $skipPreviouslyFailedTesting
     * @param bool $skipPreviouslyVerified
     * @param string $targetPaymentMethod
     * @param string $toDate
     */
    public function __construct($allowNonActivePaymentMethods = null, $batchId = null, $clientTypes = null, $enrollmentsCount = null, $fromDate = null, $isFromScheduledAutoRenewal = null, $isVerificationOnly = null, $maxMembershipsToRenew = null, $maxMembershipsToTest = null, $paymentMethods = null, $pendingCount = null, $priceTypes = null, $skipFailed = null, $skipPreviouslyFailedTesting = null, $skipPreviouslyVerified = null, $targetPaymentMethod = null, $toDate = null)
    {
        $this
            ->setAllowNonActivePaymentMethods($allowNonActivePaymentMethods)
            ->setBatchId($batchId)
            ->setClientTypes($clientTypes)
            ->setEnrollmentsCount($enrollmentsCount)
            ->setFromDate($fromDate)
            ->setIsFromScheduledAutoRenewal($isFromScheduledAutoRenewal)
            ->setIsVerificationOnly($isVerificationOnly)
            ->setMaxMembershipsToRenew($maxMembershipsToRenew)
            ->setMaxMembershipsToTest($maxMembershipsToTest)
            ->setPaymentMethods($paymentMethods)
            ->setPendingCount($pendingCount)
            ->setPriceTypes($priceTypes)
            ->setSkipFailed($skipFailed)
            ->setSkipPreviouslyFailedTesting($skipPreviouslyFailedTesting)
            ->setSkipPreviouslyVerified($skipPreviouslyVerified)
            ->setTargetPaymentMethod($targetPaymentMethod)
            ->setToDate($toDate);
    }
    /**
     * Get AllowNonActivePaymentMethods value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAllowNonActivePaymentMethods()
    {
        return isset($this->AllowNonActivePaymentMethods) ? $this->AllowNonActivePaymentMethods : null;
    }
    /**
     * Set AllowNonActivePaymentMethods value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $allowNonActivePaymentMethods
     * @return \patest\StructType\BizAction_Membership_ProcessMembershipAutoRenewBatch_Request
     */
    public function setAllowNonActivePaymentMethods($allowNonActivePaymentMethods = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowNonActivePaymentMethods) && !is_bool($allowNonActivePaymentMethods)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowNonActivePaymentMethods, true), gettype($allowNonActivePaymentMethods)), __LINE__);
        }
        if (is_null($allowNonActivePaymentMethods) || (is_array($allowNonActivePaymentMethods) && empty($allowNonActivePaymentMethods))) {
            unset($this->AllowNonActivePaymentMethods);
        } else {
            $this->AllowNonActivePaymentMethods = $allowNonActivePaymentMethods;
        }
        return $this;
    }
    /**
     * Get BatchId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBatchId()
    {
        return isset($this->BatchId) ? $this->BatchId : null;
    }
    /**
     * Set BatchId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $batchId
     * @return \patest\StructType\BizAction_Membership_ProcessMembershipAutoRenewBatch_Request
     */
    public function setBatchId($batchId = null)
    {
        // validation for constraint: string
        if (!is_null($batchId) && !is_string($batchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($batchId, true), gettype($batchId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($batchId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $batchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($batchId, true)), __LINE__);
        }
        if (is_null($batchId) || (is_array($batchId) && empty($batchId))) {
            unset($this->BatchId);
        } else {
            $this->BatchId = $batchId;
        }
        return $this;
    }
    /**
     * Get ClientTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientTypes()
    {
        return isset($this->ClientTypes) ? $this->ClientTypes : null;
    }
    /**
     * Set ClientTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientTypes
     * @return \patest\StructType\BizAction_Membership_ProcessMembershipAutoRenewBatch_Request
     */
    public function setClientTypes($clientTypes = null)
    {
        // validation for constraint: string
        if (!is_null($clientTypes) && !is_string($clientTypes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientTypes, true), gettype($clientTypes)), __LINE__);
        }
        if (is_null($clientTypes) || (is_array($clientTypes) && empty($clientTypes))) {
            unset($this->ClientTypes);
        } else {
            $this->ClientTypes = $clientTypes;
        }
        return $this;
    }
    /**
     * Get EnrollmentsCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getEnrollmentsCount()
    {
        return isset($this->EnrollmentsCount) ? $this->EnrollmentsCount : null;
    }
    /**
     * Set EnrollmentsCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $enrollmentsCount
     * @return \patest\StructType\BizAction_Membership_ProcessMembershipAutoRenewBatch_Request
     */
    public function setEnrollmentsCount($enrollmentsCount = null)
    {
        // validation for constraint: int
        if (!is_null($enrollmentsCount) && !(is_int($enrollmentsCount) || ctype_digit($enrollmentsCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($enrollmentsCount, true), gettype($enrollmentsCount)), __LINE__);
        }
        if (is_null($enrollmentsCount) || (is_array($enrollmentsCount) && empty($enrollmentsCount))) {
            unset($this->EnrollmentsCount);
        } else {
            $this->EnrollmentsCount = $enrollmentsCount;
        }
        return $this;
    }
    /**
     * Get FromDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFromDate()
    {
        return isset($this->FromDate) ? $this->FromDate : null;
    }
    /**
     * Set FromDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fromDate
     * @return \patest\StructType\BizAction_Membership_ProcessMembershipAutoRenewBatch_Request
     */
    public function setFromDate($fromDate = null)
    {
        // validation for constraint: string
        if (!is_null($fromDate) && !is_string($fromDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromDate, true), gettype($fromDate)), __LINE__);
        }
        if (is_null($fromDate) || (is_array($fromDate) && empty($fromDate))) {
            unset($this->FromDate);
        } else {
            $this->FromDate = $fromDate;
        }
        return $this;
    }
    /**
     * Get IsFromScheduledAutoRenewal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsFromScheduledAutoRenewal()
    {
        return isset($this->IsFromScheduledAutoRenewal) ? $this->IsFromScheduledAutoRenewal : null;
    }
    /**
     * Set IsFromScheduledAutoRenewal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isFromScheduledAutoRenewal
     * @return \patest\StructType\BizAction_Membership_ProcessMembershipAutoRenewBatch_Request
     */
    public function setIsFromScheduledAutoRenewal($isFromScheduledAutoRenewal = null)
    {
        // validation for constraint: boolean
        if (!is_null($isFromScheduledAutoRenewal) && !is_bool($isFromScheduledAutoRenewal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isFromScheduledAutoRenewal, true), gettype($isFromScheduledAutoRenewal)), __LINE__);
        }
        if (is_null($isFromScheduledAutoRenewal) || (is_array($isFromScheduledAutoRenewal) && empty($isFromScheduledAutoRenewal))) {
            unset($this->IsFromScheduledAutoRenewal);
        } else {
            $this->IsFromScheduledAutoRenewal = $isFromScheduledAutoRenewal;
        }
        return $this;
    }
    /**
     * Get IsVerificationOnly value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsVerificationOnly()
    {
        return isset($this->IsVerificationOnly) ? $this->IsVerificationOnly : null;
    }
    /**
     * Set IsVerificationOnly value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isVerificationOnly
     * @return \patest\StructType\BizAction_Membership_ProcessMembershipAutoRenewBatch_Request
     */
    public function setIsVerificationOnly($isVerificationOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($isVerificationOnly) && !is_bool($isVerificationOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isVerificationOnly, true), gettype($isVerificationOnly)), __LINE__);
        }
        if (is_null($isVerificationOnly) || (is_array($isVerificationOnly) && empty($isVerificationOnly))) {
            unset($this->IsVerificationOnly);
        } else {
            $this->IsVerificationOnly = $isVerificationOnly;
        }
        return $this;
    }
    /**
     * Get MaxMembershipsToRenew value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxMembershipsToRenew()
    {
        return isset($this->MaxMembershipsToRenew) ? $this->MaxMembershipsToRenew : null;
    }
    /**
     * Set MaxMembershipsToRenew value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxMembershipsToRenew
     * @return \patest\StructType\BizAction_Membership_ProcessMembershipAutoRenewBatch_Request
     */
    public function setMaxMembershipsToRenew($maxMembershipsToRenew = null)
    {
        // validation for constraint: int
        if (!is_null($maxMembershipsToRenew) && !(is_int($maxMembershipsToRenew) || ctype_digit($maxMembershipsToRenew))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxMembershipsToRenew, true), gettype($maxMembershipsToRenew)), __LINE__);
        }
        if (is_null($maxMembershipsToRenew) || (is_array($maxMembershipsToRenew) && empty($maxMembershipsToRenew))) {
            unset($this->MaxMembershipsToRenew);
        } else {
            $this->MaxMembershipsToRenew = $maxMembershipsToRenew;
        }
        return $this;
    }
    /**
     * Get MaxMembershipsToTest value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxMembershipsToTest()
    {
        return isset($this->MaxMembershipsToTest) ? $this->MaxMembershipsToTest : null;
    }
    /**
     * Set MaxMembershipsToTest value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxMembershipsToTest
     * @return \patest\StructType\BizAction_Membership_ProcessMembershipAutoRenewBatch_Request
     */
    public function setMaxMembershipsToTest($maxMembershipsToTest = null)
    {
        // validation for constraint: int
        if (!is_null($maxMembershipsToTest) && !(is_int($maxMembershipsToTest) || ctype_digit($maxMembershipsToTest))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxMembershipsToTest, true), gettype($maxMembershipsToTest)), __LINE__);
        }
        if (is_null($maxMembershipsToTest) || (is_array($maxMembershipsToTest) && empty($maxMembershipsToTest))) {
            unset($this->MaxMembershipsToTest);
        } else {
            $this->MaxMembershipsToTest = $maxMembershipsToTest;
        }
        return $this;
    }
    /**
     * Get PaymentMethods value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethods()
    {
        return isset($this->PaymentMethods) ? $this->PaymentMethods : null;
    }
    /**
     * Set PaymentMethods value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMethods
     * @return \patest\StructType\BizAction_Membership_ProcessMembershipAutoRenewBatch_Request
     */
    public function setPaymentMethods($paymentMethods = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethods) && !is_string($paymentMethods)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethods, true), gettype($paymentMethods)), __LINE__);
        }
        if (is_null($paymentMethods) || (is_array($paymentMethods) && empty($paymentMethods))) {
            unset($this->PaymentMethods);
        } else {
            $this->PaymentMethods = $paymentMethods;
        }
        return $this;
    }
    /**
     * Get PendingCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPendingCount()
    {
        return isset($this->PendingCount) ? $this->PendingCount : null;
    }
    /**
     * Set PendingCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $pendingCount
     * @return \patest\StructType\BizAction_Membership_ProcessMembershipAutoRenewBatch_Request
     */
    public function setPendingCount($pendingCount = null)
    {
        // validation for constraint: int
        if (!is_null($pendingCount) && !(is_int($pendingCount) || ctype_digit($pendingCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pendingCount, true), gettype($pendingCount)), __LINE__);
        }
        if (is_null($pendingCount) || (is_array($pendingCount) && empty($pendingCount))) {
            unset($this->PendingCount);
        } else {
            $this->PendingCount = $pendingCount;
        }
        return $this;
    }
    /**
     * Get PriceTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceTypes()
    {
        return isset($this->PriceTypes) ? $this->PriceTypes : null;
    }
    /**
     * Set PriceTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceTypes
     * @return \patest\StructType\BizAction_Membership_ProcessMembershipAutoRenewBatch_Request
     */
    public function setPriceTypes($priceTypes = null)
    {
        // validation for constraint: string
        if (!is_null($priceTypes) && !is_string($priceTypes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceTypes, true), gettype($priceTypes)), __LINE__);
        }
        if (is_null($priceTypes) || (is_array($priceTypes) && empty($priceTypes))) {
            unset($this->PriceTypes);
        } else {
            $this->PriceTypes = $priceTypes;
        }
        return $this;
    }
    /**
     * Get SkipFailed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSkipFailed()
    {
        return isset($this->SkipFailed) ? $this->SkipFailed : null;
    }
    /**
     * Set SkipFailed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $skipFailed
     * @return \patest\StructType\BizAction_Membership_ProcessMembershipAutoRenewBatch_Request
     */
    public function setSkipFailed($skipFailed = null)
    {
        // validation for constraint: boolean
        if (!is_null($skipFailed) && !is_bool($skipFailed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($skipFailed, true), gettype($skipFailed)), __LINE__);
        }
        if (is_null($skipFailed) || (is_array($skipFailed) && empty($skipFailed))) {
            unset($this->SkipFailed);
        } else {
            $this->SkipFailed = $skipFailed;
        }
        return $this;
    }
    /**
     * Get SkipPreviouslyFailedTesting value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSkipPreviouslyFailedTesting()
    {
        return isset($this->SkipPreviouslyFailedTesting) ? $this->SkipPreviouslyFailedTesting : null;
    }
    /**
     * Set SkipPreviouslyFailedTesting value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $skipPreviouslyFailedTesting
     * @return \patest\StructType\BizAction_Membership_ProcessMembershipAutoRenewBatch_Request
     */
    public function setSkipPreviouslyFailedTesting($skipPreviouslyFailedTesting = null)
    {
        // validation for constraint: boolean
        if (!is_null($skipPreviouslyFailedTesting) && !is_bool($skipPreviouslyFailedTesting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($skipPreviouslyFailedTesting, true), gettype($skipPreviouslyFailedTesting)), __LINE__);
        }
        if (is_null($skipPreviouslyFailedTesting) || (is_array($skipPreviouslyFailedTesting) && empty($skipPreviouslyFailedTesting))) {
            unset($this->SkipPreviouslyFailedTesting);
        } else {
            $this->SkipPreviouslyFailedTesting = $skipPreviouslyFailedTesting;
        }
        return $this;
    }
    /**
     * Get SkipPreviouslyVerified value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSkipPreviouslyVerified()
    {
        return isset($this->SkipPreviouslyVerified) ? $this->SkipPreviouslyVerified : null;
    }
    /**
     * Set SkipPreviouslyVerified value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $skipPreviouslyVerified
     * @return \patest\StructType\BizAction_Membership_ProcessMembershipAutoRenewBatch_Request
     */
    public function setSkipPreviouslyVerified($skipPreviouslyVerified = null)
    {
        // validation for constraint: boolean
        if (!is_null($skipPreviouslyVerified) && !is_bool($skipPreviouslyVerified)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($skipPreviouslyVerified, true), gettype($skipPreviouslyVerified)), __LINE__);
        }
        if (is_null($skipPreviouslyVerified) || (is_array($skipPreviouslyVerified) && empty($skipPreviouslyVerified))) {
            unset($this->SkipPreviouslyVerified);
        } else {
            $this->SkipPreviouslyVerified = $skipPreviouslyVerified;
        }
        return $this;
    }
    /**
     * Get TargetPaymentMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetPaymentMethod()
    {
        return isset($this->TargetPaymentMethod) ? $this->TargetPaymentMethod : null;
    }
    /**
     * Set TargetPaymentMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetPaymentMethod
     * @return \patest\StructType\BizAction_Membership_ProcessMembershipAutoRenewBatch_Request
     */
    public function setTargetPaymentMethod($targetPaymentMethod = null)
    {
        // validation for constraint: string
        if (!is_null($targetPaymentMethod) && !is_string($targetPaymentMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetPaymentMethod, true), gettype($targetPaymentMethod)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($targetPaymentMethod) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $targetPaymentMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($targetPaymentMethod, true)), __LINE__);
        }
        if (is_null($targetPaymentMethod) || (is_array($targetPaymentMethod) && empty($targetPaymentMethod))) {
            unset($this->TargetPaymentMethod);
        } else {
            $this->TargetPaymentMethod = $targetPaymentMethod;
        }
        return $this;
    }
    /**
     * Get ToDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToDate()
    {
        return isset($this->ToDate) ? $this->ToDate : null;
    }
    /**
     * Set ToDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $toDate
     * @return \patest\StructType\BizAction_Membership_ProcessMembershipAutoRenewBatch_Request
     */
    public function setToDate($toDate = null)
    {
        // validation for constraint: string
        if (!is_null($toDate) && !is_string($toDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toDate, true), gettype($toDate)), __LINE__);
        }
        if (is_null($toDate) || (is_array($toDate) && empty($toDate))) {
            unset($this->ToDate);
        } else {
            $this->ToDate = $toDate;
        }
        return $this;
    }
}
