<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Membership.Freeze.Request StructType
 * @subpackage Structs
 */
class BizAction_Membership_Freeze_Request extends AnyEntity
{
    /**
     * The MembershipId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MembershipId;
    /**
     * The MembershipIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\MembershipIds
     */
    public $MembershipIds;
    /**
     * Constructor method for BizAction.Membership.Freeze.Request
     * @uses BizAction_Membership_Freeze_Request::setMembershipId()
     * @uses BizAction_Membership_Freeze_Request::setMembershipIds()
     * @param string $membershipId
     * @param \patest\StructType\MembershipIds $membershipIds
     */
    public function __construct($membershipId = null, \patest\StructType\MembershipIds $membershipIds = null)
    {
        $this
            ->setMembershipId($membershipId)
            ->setMembershipIds($membershipIds);
    }
    /**
     * Get MembershipId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMembershipId()
    {
        return isset($this->MembershipId) ? $this->MembershipId : null;
    }
    /**
     * Set MembershipId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $membershipId
     * @return \patest\StructType\BizAction_Membership_Freeze_Request
     */
    public function setMembershipId($membershipId = null)
    {
        // validation for constraint: string
        if (!is_null($membershipId) && !is_string($membershipId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($membershipId, true), gettype($membershipId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($membershipId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $membershipId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($membershipId, true)), __LINE__);
        }
        if (is_null($membershipId) || (is_array($membershipId) && empty($membershipId))) {
            unset($this->MembershipId);
        } else {
            $this->MembershipId = $membershipId;
        }
        return $this;
    }
    /**
     * Get MembershipIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\MembershipIds|null
     */
    public function getMembershipIds()
    {
        return isset($this->MembershipIds) ? $this->MembershipIds : null;
    }
    /**
     * Set MembershipIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\MembershipIds $membershipIds
     * @return \patest\StructType\BizAction_Membership_Freeze_Request
     */
    public function setMembershipIds(\patest\StructType\MembershipIds $membershipIds = null)
    {
        if (is_null($membershipIds) || (is_array($membershipIds) && empty($membershipIds))) {
            unset($this->MembershipIds);
        } else {
            $this->MembershipIds = $membershipIds;
        }
        return $this;
    }
}
