<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Marketing.Appeal.Schedule.Request StructType
 * @subpackage Structs
 */
class BizAction_Marketing_Appeal_Schedule_Request extends BizActionLogics_Foundation_ProcessSchedule_Schedule_Request
{
    /**
     * The AppealId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AppealId;
    /**
     * Constructor method for BizAction.Marketing.Appeal.Schedule.Request
     * @uses BizAction_Marketing_Appeal_Schedule_Request::setAppealId()
     * @param string $appealId
     */
    public function __construct($appealId = null)
    {
        $this
            ->setAppealId($appealId);
    }
    /**
     * Get AppealId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAppealId()
    {
        return isset($this->AppealId) ? $this->AppealId : null;
    }
    /**
     * Set AppealId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $appealId
     * @return \patest\StructType\BizAction_Marketing_Appeal_Schedule_Request
     */
    public function setAppealId($appealId = null)
    {
        // validation for constraint: string
        if (!is_null($appealId) && !is_string($appealId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($appealId, true), gettype($appealId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($appealId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $appealId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($appealId, true)), __LINE__);
        }
        if (is_null($appealId) || (is_array($appealId) && empty($appealId))) {
            unset($this->AppealId);
        } else {
            $this->AppealId = $appealId;
        }
        return $this;
    }
}
