<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Marketing.AdvertisingClientFeedback.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Marketing_AdvertisingClientFeedback_Request extends AnyEntity
{
    /**
     * The AppealCandidates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AppealCandidates;
    /**
     * The AppealId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AppealId;
    /**
     * The BasketItemIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BasketItemIds;
    /**
     * The CampaignId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CampaignId;
    /**
     * The ChannelId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ChannelId;
    /**
     * The Frequency
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Frequency;
    /**
     * The NeedToDisplayScreen
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $NeedToDisplayScreen;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * Constructor method for BizAction.Marketing.AdvertisingClientFeedback.Request
     * @uses BizAction_Marketing_AdvertisingClientFeedback_Request::setAppealCandidates()
     * @uses BizAction_Marketing_AdvertisingClientFeedback_Request::setAppealId()
     * @uses BizAction_Marketing_AdvertisingClientFeedback_Request::setBasketItemIds()
     * @uses BizAction_Marketing_AdvertisingClientFeedback_Request::setCampaignId()
     * @uses BizAction_Marketing_AdvertisingClientFeedback_Request::setChannelId()
     * @uses BizAction_Marketing_AdvertisingClientFeedback_Request::setFrequency()
     * @uses BizAction_Marketing_AdvertisingClientFeedback_Request::setNeedToDisplayScreen()
     * @uses BizAction_Marketing_AdvertisingClientFeedback_Request::setTransactionGuid()
     * @param string $appealCandidates
     * @param string $appealId
     * @param string $basketItemIds
     * @param string $campaignId
     * @param string $channelId
     * @param int $frequency
     * @param bool $needToDisplayScreen
     * @param string $transactionGuid
     */
    public function __construct($appealCandidates = null, $appealId = null, $basketItemIds = null, $campaignId = null, $channelId = null, $frequency = null, $needToDisplayScreen = null, $transactionGuid = null)
    {
        $this
            ->setAppealCandidates($appealCandidates)
            ->setAppealId($appealId)
            ->setBasketItemIds($basketItemIds)
            ->setCampaignId($campaignId)
            ->setChannelId($channelId)
            ->setFrequency($frequency)
            ->setNeedToDisplayScreen($needToDisplayScreen)
            ->setTransactionGuid($transactionGuid);
    }
    /**
     * Get AppealCandidates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAppealCandidates()
    {
        return isset($this->AppealCandidates) ? $this->AppealCandidates : null;
    }
    /**
     * Set AppealCandidates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $appealCandidates
     * @return \patest\StructType\BizAction_Marketing_AdvertisingClientFeedback_Request
     */
    public function setAppealCandidates($appealCandidates = null)
    {
        // validation for constraint: string
        if (!is_null($appealCandidates) && !is_string($appealCandidates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($appealCandidates, true), gettype($appealCandidates)), __LINE__);
        }
        if (is_null($appealCandidates) || (is_array($appealCandidates) && empty($appealCandidates))) {
            unset($this->AppealCandidates);
        } else {
            $this->AppealCandidates = $appealCandidates;
        }
        return $this;
    }
    /**
     * Get AppealId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAppealId()
    {
        return isset($this->AppealId) ? $this->AppealId : null;
    }
    /**
     * Set AppealId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $appealId
     * @return \patest\StructType\BizAction_Marketing_AdvertisingClientFeedback_Request
     */
    public function setAppealId($appealId = null)
    {
        // validation for constraint: string
        if (!is_null($appealId) && !is_string($appealId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($appealId, true), gettype($appealId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($appealId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $appealId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($appealId, true)), __LINE__);
        }
        if (is_null($appealId) || (is_array($appealId) && empty($appealId))) {
            unset($this->AppealId);
        } else {
            $this->AppealId = $appealId;
        }
        return $this;
    }
    /**
     * Get BasketItemIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBasketItemIds()
    {
        return isset($this->BasketItemIds) ? $this->BasketItemIds : null;
    }
    /**
     * Set BasketItemIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $basketItemIds
     * @return \patest\StructType\BizAction_Marketing_AdvertisingClientFeedback_Request
     */
    public function setBasketItemIds($basketItemIds = null)
    {
        // validation for constraint: string
        if (!is_null($basketItemIds) && !is_string($basketItemIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($basketItemIds, true), gettype($basketItemIds)), __LINE__);
        }
        if (is_null($basketItemIds) || (is_array($basketItemIds) && empty($basketItemIds))) {
            unset($this->BasketItemIds);
        } else {
            $this->BasketItemIds = $basketItemIds;
        }
        return $this;
    }
    /**
     * Get CampaignId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCampaignId()
    {
        return isset($this->CampaignId) ? $this->CampaignId : null;
    }
    /**
     * Set CampaignId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $campaignId
     * @return \patest\StructType\BizAction_Marketing_AdvertisingClientFeedback_Request
     */
    public function setCampaignId($campaignId = null)
    {
        // validation for constraint: string
        if (!is_null($campaignId) && !is_string($campaignId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($campaignId, true), gettype($campaignId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($campaignId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $campaignId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($campaignId, true)), __LINE__);
        }
        if (is_null($campaignId) || (is_array($campaignId) && empty($campaignId))) {
            unset($this->CampaignId);
        } else {
            $this->CampaignId = $campaignId;
        }
        return $this;
    }
    /**
     * Get ChannelId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChannelId()
    {
        return isset($this->ChannelId) ? $this->ChannelId : null;
    }
    /**
     * Set ChannelId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $channelId
     * @return \patest\StructType\BizAction_Marketing_AdvertisingClientFeedback_Request
     */
    public function setChannelId($channelId = null)
    {
        // validation for constraint: string
        if (!is_null($channelId) && !is_string($channelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($channelId, true), gettype($channelId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($channelId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $channelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($channelId, true)), __LINE__);
        }
        if (is_null($channelId) || (is_array($channelId) && empty($channelId))) {
            unset($this->ChannelId);
        } else {
            $this->ChannelId = $channelId;
        }
        return $this;
    }
    /**
     * Get Frequency value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getFrequency()
    {
        return isset($this->Frequency) ? $this->Frequency : null;
    }
    /**
     * Set Frequency value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $frequency
     * @return \patest\StructType\BizAction_Marketing_AdvertisingClientFeedback_Request
     */
    public function setFrequency($frequency = null)
    {
        // validation for constraint: int
        if (!is_null($frequency) && !(is_int($frequency) || ctype_digit($frequency))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($frequency, true), gettype($frequency)), __LINE__);
        }
        if (is_null($frequency) || (is_array($frequency) && empty($frequency))) {
            unset($this->Frequency);
        } else {
            $this->Frequency = $frequency;
        }
        return $this;
    }
    /**
     * Get NeedToDisplayScreen value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getNeedToDisplayScreen()
    {
        return isset($this->NeedToDisplayScreen) ? $this->NeedToDisplayScreen : null;
    }
    /**
     * Set NeedToDisplayScreen value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $needToDisplayScreen
     * @return \patest\StructType\BizAction_Marketing_AdvertisingClientFeedback_Request
     */
    public function setNeedToDisplayScreen($needToDisplayScreen = null)
    {
        // validation for constraint: boolean
        if (!is_null($needToDisplayScreen) && !is_bool($needToDisplayScreen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($needToDisplayScreen, true), gettype($needToDisplayScreen)), __LINE__);
        }
        if (is_null($needToDisplayScreen) || (is_array($needToDisplayScreen) && empty($needToDisplayScreen))) {
            unset($this->NeedToDisplayScreen);
        } else {
            $this->NeedToDisplayScreen = $needToDisplayScreen;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return isset($this->TransactionGuid) ? $this->TransactionGuid : null;
    }
    /**
     * Set TransactionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionGuid
     * @return \patest\StructType\BizAction_Marketing_AdvertisingClientFeedback_Request
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        if (is_null($transactionGuid) || (is_array($transactionGuid) && empty($transactionGuid))) {
            unset($this->TransactionGuid);
        } else {
            $this->TransactionGuid = $transactionGuid;
        }
        return $this;
    }
}
