<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.HelpDesk.SetServiceRequestStatus.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_HelpDesk_SetServiceRequestStatus_Request extends AnyEntity
{
    /**
     * The ExplanationId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ExplanationId;
    /**
     * The InteractiveMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $InteractiveMode;
    /**
     * The OtherExplanation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OtherExplanation;
    /**
     * The RequestId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RequestId;
    /**
     * The StatusId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $StatusId;
    /**
     * Constructor method for BizAction.HelpDesk.SetServiceRequestStatus.Request
     * @uses BizAction_HelpDesk_SetServiceRequestStatus_Request::setExplanationId()
     * @uses BizAction_HelpDesk_SetServiceRequestStatus_Request::setInteractiveMode()
     * @uses BizAction_HelpDesk_SetServiceRequestStatus_Request::setOtherExplanation()
     * @uses BizAction_HelpDesk_SetServiceRequestStatus_Request::setRequestId()
     * @uses BizAction_HelpDesk_SetServiceRequestStatus_Request::setStatusId()
     * @param string $explanationId
     * @param bool $interactiveMode
     * @param string $otherExplanation
     * @param string $requestId
     * @param string $statusId
     */
    public function __construct($explanationId = null, $interactiveMode = null, $otherExplanation = null, $requestId = null, $statusId = null)
    {
        $this
            ->setExplanationId($explanationId)
            ->setInteractiveMode($interactiveMode)
            ->setOtherExplanation($otherExplanation)
            ->setRequestId($requestId)
            ->setStatusId($statusId);
    }
    /**
     * Get ExplanationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExplanationId()
    {
        return isset($this->ExplanationId) ? $this->ExplanationId : null;
    }
    /**
     * Set ExplanationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $explanationId
     * @return \patest\StructType\BizAction_HelpDesk_SetServiceRequestStatus_Request
     */
    public function setExplanationId($explanationId = null)
    {
        // validation for constraint: string
        if (!is_null($explanationId) && !is_string($explanationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($explanationId, true), gettype($explanationId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($explanationId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $explanationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($explanationId, true)), __LINE__);
        }
        if (is_null($explanationId) || (is_array($explanationId) && empty($explanationId))) {
            unset($this->ExplanationId);
        } else {
            $this->ExplanationId = $explanationId;
        }
        return $this;
    }
    /**
     * Get InteractiveMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getInteractiveMode()
    {
        return isset($this->InteractiveMode) ? $this->InteractiveMode : null;
    }
    /**
     * Set InteractiveMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $interactiveMode
     * @return \patest\StructType\BizAction_HelpDesk_SetServiceRequestStatus_Request
     */
    public function setInteractiveMode($interactiveMode = null)
    {
        // validation for constraint: boolean
        if (!is_null($interactiveMode) && !is_bool($interactiveMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($interactiveMode, true), gettype($interactiveMode)), __LINE__);
        }
        if (is_null($interactiveMode) || (is_array($interactiveMode) && empty($interactiveMode))) {
            unset($this->InteractiveMode);
        } else {
            $this->InteractiveMode = $interactiveMode;
        }
        return $this;
    }
    /**
     * Get OtherExplanation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOtherExplanation()
    {
        return isset($this->OtherExplanation) ? $this->OtherExplanation : null;
    }
    /**
     * Set OtherExplanation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $otherExplanation
     * @return \patest\StructType\BizAction_HelpDesk_SetServiceRequestStatus_Request
     */
    public function setOtherExplanation($otherExplanation = null)
    {
        // validation for constraint: string
        if (!is_null($otherExplanation) && !is_string($otherExplanation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($otherExplanation, true), gettype($otherExplanation)), __LINE__);
        }
        if (is_null($otherExplanation) || (is_array($otherExplanation) && empty($otherExplanation))) {
            unset($this->OtherExplanation);
        } else {
            $this->OtherExplanation = $otherExplanation;
        }
        return $this;
    }
    /**
     * Get RequestId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestId()
    {
        return isset($this->RequestId) ? $this->RequestId : null;
    }
    /**
     * Set RequestId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestId
     * @return \patest\StructType\BizAction_HelpDesk_SetServiceRequestStatus_Request
     */
    public function setRequestId($requestId = null)
    {
        // validation for constraint: string
        if (!is_null($requestId) && !is_string($requestId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestId, true), gettype($requestId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($requestId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $requestId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($requestId, true)), __LINE__);
        }
        if (is_null($requestId) || (is_array($requestId) && empty($requestId))) {
            unset($this->RequestId);
        } else {
            $this->RequestId = $requestId;
        }
        return $this;
    }
    /**
     * Get StatusId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatusId()
    {
        return isset($this->StatusId) ? $this->StatusId : null;
    }
    /**
     * Set StatusId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $statusId
     * @return \patest\StructType\BizAction_HelpDesk_SetServiceRequestStatus_Request
     */
    public function setStatusId($statusId = null)
    {
        // validation for constraint: string
        if (!is_null($statusId) && !is_string($statusId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusId, true), gettype($statusId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($statusId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $statusId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($statusId, true)), __LINE__);
        }
        if (is_null($statusId) || (is_array($statusId) && empty($statusId))) {
            unset($this->StatusId);
        } else {
            $this->StatusId = $statusId;
        }
        return $this;
    }
}
