<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.HelpDesk.BulkChange.Request StructType
 * @subpackage Structs
 */
class BizAction_HelpDesk_BulkChange_Request extends HelpDesk_CommonFindRequest
{
    /**
     * The ChangeAssignedTo
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ChangeAssignedTo;
    /**
     * The ChangeExpiryDateTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ChangeExpiryDateTo;
    /**
     * The ChangeExplanationIdTo
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ChangeExplanationIdTo;
    /**
     * The ChangeOtherExplanationTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ChangeOtherExplanationTo;
    /**
     * The ChangePriorityTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ChangePriorityTo;
    /**
     * The ChangeStatusTo
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ChangeStatusTo;
    /**
     * The NumToChange
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumToChange;
    /**
     * The RecordsToUpdateCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RecordsToUpdateCount;
    /**
     * Constructor method for BizAction.HelpDesk.BulkChange.Request
     * @uses BizAction_HelpDesk_BulkChange_Request::setChangeAssignedTo()
     * @uses BizAction_HelpDesk_BulkChange_Request::setChangeExpiryDateTo()
     * @uses BizAction_HelpDesk_BulkChange_Request::setChangeExplanationIdTo()
     * @uses BizAction_HelpDesk_BulkChange_Request::setChangeOtherExplanationTo()
     * @uses BizAction_HelpDesk_BulkChange_Request::setChangePriorityTo()
     * @uses BizAction_HelpDesk_BulkChange_Request::setChangeStatusTo()
     * @uses BizAction_HelpDesk_BulkChange_Request::setNumToChange()
     * @uses BizAction_HelpDesk_BulkChange_Request::setRecordsToUpdateCount()
     * @param string $changeAssignedTo
     * @param string $changeExpiryDateTo
     * @param string $changeExplanationIdTo
     * @param string $changeOtherExplanationTo
     * @param string $changePriorityTo
     * @param string $changeStatusTo
     * @param int $numToChange
     * @param int $recordsToUpdateCount
     */
    public function __construct($changeAssignedTo = null, $changeExpiryDateTo = null, $changeExplanationIdTo = null, $changeOtherExplanationTo = null, $changePriorityTo = null, $changeStatusTo = null, $numToChange = null, $recordsToUpdateCount = null)
    {
        $this
            ->setChangeAssignedTo($changeAssignedTo)
            ->setChangeExpiryDateTo($changeExpiryDateTo)
            ->setChangeExplanationIdTo($changeExplanationIdTo)
            ->setChangeOtherExplanationTo($changeOtherExplanationTo)
            ->setChangePriorityTo($changePriorityTo)
            ->setChangeStatusTo($changeStatusTo)
            ->setNumToChange($numToChange)
            ->setRecordsToUpdateCount($recordsToUpdateCount);
    }
    /**
     * Get ChangeAssignedTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChangeAssignedTo()
    {
        return isset($this->ChangeAssignedTo) ? $this->ChangeAssignedTo : null;
    }
    /**
     * Set ChangeAssignedTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $changeAssignedTo
     * @return \patest\StructType\BizAction_HelpDesk_BulkChange_Request
     */
    public function setChangeAssignedTo($changeAssignedTo = null)
    {
        // validation for constraint: string
        if (!is_null($changeAssignedTo) && !is_string($changeAssignedTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($changeAssignedTo, true), gettype($changeAssignedTo)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($changeAssignedTo) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $changeAssignedTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($changeAssignedTo, true)), __LINE__);
        }
        if (is_null($changeAssignedTo) || (is_array($changeAssignedTo) && empty($changeAssignedTo))) {
            unset($this->ChangeAssignedTo);
        } else {
            $this->ChangeAssignedTo = $changeAssignedTo;
        }
        return $this;
    }
    /**
     * Get ChangeExpiryDateTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChangeExpiryDateTo()
    {
        return isset($this->ChangeExpiryDateTo) ? $this->ChangeExpiryDateTo : null;
    }
    /**
     * Set ChangeExpiryDateTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $changeExpiryDateTo
     * @return \patest\StructType\BizAction_HelpDesk_BulkChange_Request
     */
    public function setChangeExpiryDateTo($changeExpiryDateTo = null)
    {
        // validation for constraint: string
        if (!is_null($changeExpiryDateTo) && !is_string($changeExpiryDateTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($changeExpiryDateTo, true), gettype($changeExpiryDateTo)), __LINE__);
        }
        if (is_null($changeExpiryDateTo) || (is_array($changeExpiryDateTo) && empty($changeExpiryDateTo))) {
            unset($this->ChangeExpiryDateTo);
        } else {
            $this->ChangeExpiryDateTo = $changeExpiryDateTo;
        }
        return $this;
    }
    /**
     * Get ChangeExplanationIdTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChangeExplanationIdTo()
    {
        return isset($this->ChangeExplanationIdTo) ? $this->ChangeExplanationIdTo : null;
    }
    /**
     * Set ChangeExplanationIdTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $changeExplanationIdTo
     * @return \patest\StructType\BizAction_HelpDesk_BulkChange_Request
     */
    public function setChangeExplanationIdTo($changeExplanationIdTo = null)
    {
        // validation for constraint: string
        if (!is_null($changeExplanationIdTo) && !is_string($changeExplanationIdTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($changeExplanationIdTo, true), gettype($changeExplanationIdTo)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($changeExplanationIdTo) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $changeExplanationIdTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($changeExplanationIdTo, true)), __LINE__);
        }
        if (is_null($changeExplanationIdTo) || (is_array($changeExplanationIdTo) && empty($changeExplanationIdTo))) {
            unset($this->ChangeExplanationIdTo);
        } else {
            $this->ChangeExplanationIdTo = $changeExplanationIdTo;
        }
        return $this;
    }
    /**
     * Get ChangeOtherExplanationTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChangeOtherExplanationTo()
    {
        return isset($this->ChangeOtherExplanationTo) ? $this->ChangeOtherExplanationTo : null;
    }
    /**
     * Set ChangeOtherExplanationTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $changeOtherExplanationTo
     * @return \patest\StructType\BizAction_HelpDesk_BulkChange_Request
     */
    public function setChangeOtherExplanationTo($changeOtherExplanationTo = null)
    {
        // validation for constraint: string
        if (!is_null($changeOtherExplanationTo) && !is_string($changeOtherExplanationTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($changeOtherExplanationTo, true), gettype($changeOtherExplanationTo)), __LINE__);
        }
        if (is_null($changeOtherExplanationTo) || (is_array($changeOtherExplanationTo) && empty($changeOtherExplanationTo))) {
            unset($this->ChangeOtherExplanationTo);
        } else {
            $this->ChangeOtherExplanationTo = $changeOtherExplanationTo;
        }
        return $this;
    }
    /**
     * Get ChangePriorityTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChangePriorityTo()
    {
        return isset($this->ChangePriorityTo) ? $this->ChangePriorityTo : null;
    }
    /**
     * Set ChangePriorityTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\RequestPriority::valueIsValid()
     * @uses \patest\EnumType\RequestPriority::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $changePriorityTo
     * @return \patest\StructType\BizAction_HelpDesk_BulkChange_Request
     */
    public function setChangePriorityTo($changePriorityTo = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\RequestPriority::valueIsValid($changePriorityTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\RequestPriority', is_array($changePriorityTo) ? implode(', ', $changePriorityTo) : var_export($changePriorityTo, true), implode(', ', \patest\EnumType\RequestPriority::getValidValues())), __LINE__);
        }
        if (is_null($changePriorityTo) || (is_array($changePriorityTo) && empty($changePriorityTo))) {
            unset($this->ChangePriorityTo);
        } else {
            $this->ChangePriorityTo = $changePriorityTo;
        }
        return $this;
    }
    /**
     * Get ChangeStatusTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChangeStatusTo()
    {
        return isset($this->ChangeStatusTo) ? $this->ChangeStatusTo : null;
    }
    /**
     * Set ChangeStatusTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $changeStatusTo
     * @return \patest\StructType\BizAction_HelpDesk_BulkChange_Request
     */
    public function setChangeStatusTo($changeStatusTo = null)
    {
        // validation for constraint: string
        if (!is_null($changeStatusTo) && !is_string($changeStatusTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($changeStatusTo, true), gettype($changeStatusTo)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($changeStatusTo) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $changeStatusTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($changeStatusTo, true)), __LINE__);
        }
        if (is_null($changeStatusTo) || (is_array($changeStatusTo) && empty($changeStatusTo))) {
            unset($this->ChangeStatusTo);
        } else {
            $this->ChangeStatusTo = $changeStatusTo;
        }
        return $this;
    }
    /**
     * Get NumToChange value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumToChange()
    {
        return isset($this->NumToChange) ? $this->NumToChange : null;
    }
    /**
     * Set NumToChange value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numToChange
     * @return \patest\StructType\BizAction_HelpDesk_BulkChange_Request
     */
    public function setNumToChange($numToChange = null)
    {
        // validation for constraint: int
        if (!is_null($numToChange) && !(is_int($numToChange) || ctype_digit($numToChange))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numToChange, true), gettype($numToChange)), __LINE__);
        }
        if (is_null($numToChange) || (is_array($numToChange) && empty($numToChange))) {
            unset($this->NumToChange);
        } else {
            $this->NumToChange = $numToChange;
        }
        return $this;
    }
    /**
     * Get RecordsToUpdateCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRecordsToUpdateCount()
    {
        return isset($this->RecordsToUpdateCount) ? $this->RecordsToUpdateCount : null;
    }
    /**
     * Set RecordsToUpdateCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $recordsToUpdateCount
     * @return \patest\StructType\BizAction_HelpDesk_BulkChange_Request
     */
    public function setRecordsToUpdateCount($recordsToUpdateCount = null)
    {
        // validation for constraint: int
        if (!is_null($recordsToUpdateCount) && !(is_int($recordsToUpdateCount) || ctype_digit($recordsToUpdateCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($recordsToUpdateCount, true), gettype($recordsToUpdateCount)), __LINE__);
        }
        if (is_null($recordsToUpdateCount) || (is_array($recordsToUpdateCount) && empty($recordsToUpdateCount))) {
            unset($this->RecordsToUpdateCount);
        } else {
            $this->RecordsToUpdateCount = $recordsToUpdateCount;
        }
        return $this;
    }
}
