<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.GiftVoucher.Coupon.AddCouponIds.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_GiftVoucher_Coupon_AddCouponIds_Request extends AnyEntity
{
    /**
     * The CouponDefinitionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CouponDefinitionId;
    /**
     * The IdentityType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IdentityType;
    /**
     * The IncrementBy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $IncrementBy;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Quantity;
    /**
     * The SalesRepId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SalesRepId;
    /**
     * The StartingId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StartingId;
    /**
     * Constructor method for BizAction.GiftVoucher.Coupon.AddCouponIds.Request
     * @uses BizAction_GiftVoucher_Coupon_AddCouponIds_Request::setCouponDefinitionId()
     * @uses BizAction_GiftVoucher_Coupon_AddCouponIds_Request::setIdentityType()
     * @uses BizAction_GiftVoucher_Coupon_AddCouponIds_Request::setIncrementBy()
     * @uses BizAction_GiftVoucher_Coupon_AddCouponIds_Request::setQuantity()
     * @uses BizAction_GiftVoucher_Coupon_AddCouponIds_Request::setSalesRepId()
     * @uses BizAction_GiftVoucher_Coupon_AddCouponIds_Request::setStartingId()
     * @param string $couponDefinitionId
     * @param string $identityType
     * @param int $incrementBy
     * @param int $quantity
     * @param string $salesRepId
     * @param string $startingId
     */
    public function __construct($couponDefinitionId = null, $identityType = null, $incrementBy = null, $quantity = null, $salesRepId = null, $startingId = null)
    {
        $this
            ->setCouponDefinitionId($couponDefinitionId)
            ->setIdentityType($identityType)
            ->setIncrementBy($incrementBy)
            ->setQuantity($quantity)
            ->setSalesRepId($salesRepId)
            ->setStartingId($startingId);
    }
    /**
     * Get CouponDefinitionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCouponDefinitionId()
    {
        return isset($this->CouponDefinitionId) ? $this->CouponDefinitionId : null;
    }
    /**
     * Set CouponDefinitionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $couponDefinitionId
     * @return \patest\StructType\BizAction_GiftVoucher_Coupon_AddCouponIds_Request
     */
    public function setCouponDefinitionId($couponDefinitionId = null)
    {
        // validation for constraint: string
        if (!is_null($couponDefinitionId) && !is_string($couponDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($couponDefinitionId, true), gettype($couponDefinitionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($couponDefinitionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $couponDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($couponDefinitionId, true)), __LINE__);
        }
        if (is_null($couponDefinitionId) || (is_array($couponDefinitionId) && empty($couponDefinitionId))) {
            unset($this->CouponDefinitionId);
        } else {
            $this->CouponDefinitionId = $couponDefinitionId;
        }
        return $this;
    }
    /**
     * Get IdentityType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdentityType()
    {
        return isset($this->IdentityType) ? $this->IdentityType : null;
    }
    /**
     * Set IdentityType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\CouponIdentityType::valueIsValid()
     * @uses \patest\EnumType\CouponIdentityType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $identityType
     * @return \patest\StructType\BizAction_GiftVoucher_Coupon_AddCouponIds_Request
     */
    public function setIdentityType($identityType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\CouponIdentityType::valueIsValid($identityType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\CouponIdentityType', is_array($identityType) ? implode(', ', $identityType) : var_export($identityType, true), implode(', ', \patest\EnumType\CouponIdentityType::getValidValues())), __LINE__);
        }
        if (is_null($identityType) || (is_array($identityType) && empty($identityType))) {
            unset($this->IdentityType);
        } else {
            $this->IdentityType = $identityType;
        }
        return $this;
    }
    /**
     * Get IncrementBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getIncrementBy()
    {
        return isset($this->IncrementBy) ? $this->IncrementBy : null;
    }
    /**
     * Set IncrementBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $incrementBy
     * @return \patest\StructType\BizAction_GiftVoucher_Coupon_AddCouponIds_Request
     */
    public function setIncrementBy($incrementBy = null)
    {
        // validation for constraint: int
        if (!is_null($incrementBy) && !(is_int($incrementBy) || ctype_digit($incrementBy))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($incrementBy, true), gettype($incrementBy)), __LINE__);
        }
        if (is_null($incrementBy) || (is_array($incrementBy) && empty($incrementBy))) {
            unset($this->IncrementBy);
        } else {
            $this->IncrementBy = $incrementBy;
        }
        return $this;
    }
    /**
     * Get Quantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getQuantity()
    {
        return isset($this->Quantity) ? $this->Quantity : null;
    }
    /**
     * Set Quantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $quantity
     * @return \patest\StructType\BizAction_GiftVoucher_Coupon_AddCouponIds_Request
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        if (is_null($quantity) || (is_array($quantity) && empty($quantity))) {
            unset($this->Quantity);
        } else {
            $this->Quantity = $quantity;
        }
        return $this;
    }
    /**
     * Get SalesRepId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSalesRepId()
    {
        return isset($this->SalesRepId) ? $this->SalesRepId : null;
    }
    /**
     * Set SalesRepId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $salesRepId
     * @return \patest\StructType\BizAction_GiftVoucher_Coupon_AddCouponIds_Request
     */
    public function setSalesRepId($salesRepId = null)
    {
        // validation for constraint: string
        if (!is_null($salesRepId) && !is_string($salesRepId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesRepId, true), gettype($salesRepId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($salesRepId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $salesRepId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($salesRepId, true)), __LINE__);
        }
        if (is_null($salesRepId) || (is_array($salesRepId) && empty($salesRepId))) {
            unset($this->SalesRepId);
        } else {
            $this->SalesRepId = $salesRepId;
        }
        return $this;
    }
    /**
     * Get StartingId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStartingId()
    {
        return isset($this->StartingId) ? $this->StartingId : null;
    }
    /**
     * Set StartingId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $startingId
     * @return \patest\StructType\BizAction_GiftVoucher_Coupon_AddCouponIds_Request
     */
    public function setStartingId($startingId = null)
    {
        // validation for constraint: string
        if (!is_null($startingId) && !is_string($startingId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startingId, true), gettype($startingId)), __LINE__);
        }
        if (is_null($startingId) || (is_array($startingId) && empty($startingId))) {
            unset($this->StartingId);
        } else {
            $this->StartingId = $startingId;
        }
        return $this;
    }
}
