<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.GiftCard.DeactivateCard.Request StructType
 * @subpackage Structs
 */
class BizAction_GiftCard_DeactivateCard_Request extends AnyEntity
{
    /**
     * The Balances
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfBizAction_GiftCard_CardBalance
     */
    public $Balances;
    /**
     * The CardNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardNumber;
    /**
     * The CardTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CardTypeId;
    /**
     * The ErrorMsg
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ErrorMsg;
    /**
     * Constructor method for BizAction.GiftCard.DeactivateCard.Request
     * @uses BizAction_GiftCard_DeactivateCard_Request::setBalances()
     * @uses BizAction_GiftCard_DeactivateCard_Request::setCardNumber()
     * @uses BizAction_GiftCard_DeactivateCard_Request::setCardTypeId()
     * @uses BizAction_GiftCard_DeactivateCard_Request::setErrorMsg()
     * @param \patest\StructType\RecordSetOfBizAction_GiftCard_CardBalance $balances
     * @param string $cardNumber
     * @param string $cardTypeId
     * @param string $errorMsg
     */
    public function __construct(\patest\StructType\RecordSetOfBizAction_GiftCard_CardBalance $balances = null, $cardNumber = null, $cardTypeId = null, $errorMsg = null)
    {
        $this
            ->setBalances($balances)
            ->setCardNumber($cardNumber)
            ->setCardTypeId($cardTypeId)
            ->setErrorMsg($errorMsg);
    }
    /**
     * Get Balances value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfBizAction_GiftCard_CardBalance|null
     */
    public function getBalances()
    {
        return isset($this->Balances) ? $this->Balances : null;
    }
    /**
     * Set Balances value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfBizAction_GiftCard_CardBalance $balances
     * @return \patest\StructType\BizAction_GiftCard_DeactivateCard_Request
     */
    public function setBalances(\patest\StructType\RecordSetOfBizAction_GiftCard_CardBalance $balances = null)
    {
        if (is_null($balances) || (is_array($balances) && empty($balances))) {
            unset($this->Balances);
        } else {
            $this->Balances = $balances;
        }
        return $this;
    }
    /**
     * Get CardNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardNumber()
    {
        return isset($this->CardNumber) ? $this->CardNumber : null;
    }
    /**
     * Set CardNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardNumber
     * @return \patest\StructType\BizAction_GiftCard_DeactivateCard_Request
     */
    public function setCardNumber($cardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cardNumber) && !is_string($cardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardNumber, true), gettype($cardNumber)), __LINE__);
        }
        if (is_null($cardNumber) || (is_array($cardNumber) && empty($cardNumber))) {
            unset($this->CardNumber);
        } else {
            $this->CardNumber = $cardNumber;
        }
        return $this;
    }
    /**
     * Get CardTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardTypeId()
    {
        return isset($this->CardTypeId) ? $this->CardTypeId : null;
    }
    /**
     * Set CardTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardTypeId
     * @return \patest\StructType\BizAction_GiftCard_DeactivateCard_Request
     */
    public function setCardTypeId($cardTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($cardTypeId) && !is_string($cardTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardTypeId, true), gettype($cardTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($cardTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $cardTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($cardTypeId, true)), __LINE__);
        }
        if (is_null($cardTypeId) || (is_array($cardTypeId) && empty($cardTypeId))) {
            unset($this->CardTypeId);
        } else {
            $this->CardTypeId = $cardTypeId;
        }
        return $this;
    }
    /**
     * Get ErrorMsg value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErrorMsg()
    {
        return isset($this->ErrorMsg) ? $this->ErrorMsg : null;
    }
    /**
     * Set ErrorMsg value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $errorMsg
     * @return \patest\StructType\BizAction_GiftCard_DeactivateCard_Request
     */
    public function setErrorMsg($errorMsg = null)
    {
        // validation for constraint: string
        if (!is_null($errorMsg) && !is_string($errorMsg)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMsg, true), gettype($errorMsg)), __LINE__);
        }
        if (is_null($errorMsg) || (is_array($errorMsg) && empty($errorMsg))) {
            unset($this->ErrorMsg);
        } else {
            $this->ErrorMsg = $errorMsg;
        }
        return $this;
    }
}
