<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Foundation.UploadAttachment.Request StructType
 * @subpackage Structs
 */
class BizAction_Foundation_UploadAttachment_Request extends AnyEntity
{
    /**
     * The Comment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Comment;
    /**
     * The FileData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FileData;
    /**
     * The FileName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FileName;
    /**
     * The LinkUrlOrPath
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LinkUrlOrPath;
    /**
     * The RelatedEntityId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RelatedEntityId;
    /**
     * The RelatedEntityName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RelatedEntityName;
    /**
     * Constructor method for BizAction.Foundation.UploadAttachment.Request
     * @uses BizAction_Foundation_UploadAttachment_Request::setComment()
     * @uses BizAction_Foundation_UploadAttachment_Request::setFileData()
     * @uses BizAction_Foundation_UploadAttachment_Request::setFileName()
     * @uses BizAction_Foundation_UploadAttachment_Request::setLinkUrlOrPath()
     * @uses BizAction_Foundation_UploadAttachment_Request::setRelatedEntityId()
     * @uses BizAction_Foundation_UploadAttachment_Request::setRelatedEntityName()
     * @param \patest\StructType\GlobalString $comment
     * @param string $fileData
     * @param string $fileName
     * @param string $linkUrlOrPath
     * @param string $relatedEntityId
     * @param string $relatedEntityName
     */
    public function __construct(\patest\StructType\GlobalString $comment = null, $fileData = null, $fileName = null, $linkUrlOrPath = null, $relatedEntityId = null, $relatedEntityName = null)
    {
        $this
            ->setComment($comment)
            ->setFileData($fileData)
            ->setFileName($fileName)
            ->setLinkUrlOrPath($linkUrlOrPath)
            ->setRelatedEntityId($relatedEntityId)
            ->setRelatedEntityName($relatedEntityName);
    }
    /**
     * Get Comment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getComment()
    {
        return isset($this->Comment) ? $this->Comment : null;
    }
    /**
     * Set Comment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $comment
     * @return \patest\StructType\BizAction_Foundation_UploadAttachment_Request
     */
    public function setComment(\patest\StructType\GlobalString $comment = null)
    {
        if (is_null($comment) || (is_array($comment) && empty($comment))) {
            unset($this->Comment);
        } else {
            $this->Comment = $comment;
        }
        return $this;
    }
    /**
     * Get FileData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFileData()
    {
        return isset($this->FileData) ? $this->FileData : null;
    }
    /**
     * Set FileData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fileData
     * @return \patest\StructType\BizAction_Foundation_UploadAttachment_Request
     */
    public function setFileData($fileData = null)
    {
        // validation for constraint: string
        if (!is_null($fileData) && !is_string($fileData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileData, true), gettype($fileData)), __LINE__);
        }
        if (is_null($fileData) || (is_array($fileData) && empty($fileData))) {
            unset($this->FileData);
        } else {
            $this->FileData = $fileData;
        }
        return $this;
    }
    /**
     * Get FileName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFileName()
    {
        return isset($this->FileName) ? $this->FileName : null;
    }
    /**
     * Set FileName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fileName
     * @return \patest\StructType\BizAction_Foundation_UploadAttachment_Request
     */
    public function setFileName($fileName = null)
    {
        // validation for constraint: string
        if (!is_null($fileName) && !is_string($fileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileName, true), gettype($fileName)), __LINE__);
        }
        if (is_null($fileName) || (is_array($fileName) && empty($fileName))) {
            unset($this->FileName);
        } else {
            $this->FileName = $fileName;
        }
        return $this;
    }
    /**
     * Get LinkUrlOrPath value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLinkUrlOrPath()
    {
        return isset($this->LinkUrlOrPath) ? $this->LinkUrlOrPath : null;
    }
    /**
     * Set LinkUrlOrPath value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $linkUrlOrPath
     * @return \patest\StructType\BizAction_Foundation_UploadAttachment_Request
     */
    public function setLinkUrlOrPath($linkUrlOrPath = null)
    {
        // validation for constraint: string
        if (!is_null($linkUrlOrPath) && !is_string($linkUrlOrPath)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($linkUrlOrPath, true), gettype($linkUrlOrPath)), __LINE__);
        }
        if (is_null($linkUrlOrPath) || (is_array($linkUrlOrPath) && empty($linkUrlOrPath))) {
            unset($this->LinkUrlOrPath);
        } else {
            $this->LinkUrlOrPath = $linkUrlOrPath;
        }
        return $this;
    }
    /**
     * Get RelatedEntityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelatedEntityId()
    {
        return isset($this->RelatedEntityId) ? $this->RelatedEntityId : null;
    }
    /**
     * Set RelatedEntityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relatedEntityId
     * @return \patest\StructType\BizAction_Foundation_UploadAttachment_Request
     */
    public function setRelatedEntityId($relatedEntityId = null)
    {
        // validation for constraint: string
        if (!is_null($relatedEntityId) && !is_string($relatedEntityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relatedEntityId, true), gettype($relatedEntityId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($relatedEntityId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $relatedEntityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($relatedEntityId, true)), __LINE__);
        }
        if (is_null($relatedEntityId) || (is_array($relatedEntityId) && empty($relatedEntityId))) {
            unset($this->RelatedEntityId);
        } else {
            $this->RelatedEntityId = $relatedEntityId;
        }
        return $this;
    }
    /**
     * Get RelatedEntityName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelatedEntityName()
    {
        return isset($this->RelatedEntityName) ? $this->RelatedEntityName : null;
    }
    /**
     * Set RelatedEntityName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relatedEntityName
     * @return \patest\StructType\BizAction_Foundation_UploadAttachment_Request
     */
    public function setRelatedEntityName($relatedEntityName = null)
    {
        // validation for constraint: string
        if (!is_null($relatedEntityName) && !is_string($relatedEntityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relatedEntityName, true), gettype($relatedEntityName)), __LINE__);
        }
        if (is_null($relatedEntityName) || (is_array($relatedEntityName) && empty($relatedEntityName))) {
            unset($this->RelatedEntityName);
        } else {
            $this->RelatedEntityName = $relatedEntityName;
        }
        return $this;
    }
}
