<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Facade.HandleBundle.Request StructType
 * @subpackage Structs
 */
class BizAction_Facade_HandleBundle_Request extends AnyEntity
{
    /**
     * The BundleId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BundleId;
    /**
     * The EventsPart
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Facade_BundleRelatedEventsPart
     */
    public $EventsPart;
    /**
     * The GiftVouchersPart
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Facade_BundleRelatedGiftVouchersPart
     */
    public $GiftVouchersPart;
    /**
     * The MembershipsPart
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Facade_BundleRelatedMembershipsPart
     */
    public $MembershipsPart;
    /**
     * The MerchandisePart
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Facade_BundleRelatedMerchandisePart
     */
    public $MerchandisePart;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Quantity;
    /**
     * The QuantityPerPriceType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfFacade_PriceTypeBundleQuantity
     */
    public $QuantityPerPriceType;
    /**
     * The SeriesPart
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Facade_BundleRelatedSeriesPart
     */
    public $SeriesPart;
    /**
     * The TransactionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionId;
    /**
     * Constructor method for BizAction.Facade.HandleBundle.Request
     * @uses BizAction_Facade_HandleBundle_Request::setBundleId()
     * @uses BizAction_Facade_HandleBundle_Request::setEventsPart()
     * @uses BizAction_Facade_HandleBundle_Request::setGiftVouchersPart()
     * @uses BizAction_Facade_HandleBundle_Request::setMembershipsPart()
     * @uses BizAction_Facade_HandleBundle_Request::setMerchandisePart()
     * @uses BizAction_Facade_HandleBundle_Request::setQuantity()
     * @uses BizAction_Facade_HandleBundle_Request::setQuantityPerPriceType()
     * @uses BizAction_Facade_HandleBundle_Request::setSeriesPart()
     * @uses BizAction_Facade_HandleBundle_Request::setTransactionId()
     * @param string $bundleId
     * @param \patest\StructType\Facade_BundleRelatedEventsPart $eventsPart
     * @param \patest\StructType\Facade_BundleRelatedGiftVouchersPart $giftVouchersPart
     * @param \patest\StructType\Facade_BundleRelatedMembershipsPart $membershipsPart
     * @param \patest\StructType\Facade_BundleRelatedMerchandisePart $merchandisePart
     * @param int $quantity
     * @param \patest\StructType\RecordSetOfFacade_PriceTypeBundleQuantity $quantityPerPriceType
     * @param \patest\StructType\Facade_BundleRelatedSeriesPart $seriesPart
     * @param string $transactionId
     */
    public function __construct($bundleId = null, \patest\StructType\Facade_BundleRelatedEventsPart $eventsPart = null, \patest\StructType\Facade_BundleRelatedGiftVouchersPart $giftVouchersPart = null, \patest\StructType\Facade_BundleRelatedMembershipsPart $membershipsPart = null, \patest\StructType\Facade_BundleRelatedMerchandisePart $merchandisePart = null, $quantity = null, \patest\StructType\RecordSetOfFacade_PriceTypeBundleQuantity $quantityPerPriceType = null, \patest\StructType\Facade_BundleRelatedSeriesPart $seriesPart = null, $transactionId = null)
    {
        $this
            ->setBundleId($bundleId)
            ->setEventsPart($eventsPart)
            ->setGiftVouchersPart($giftVouchersPart)
            ->setMembershipsPart($membershipsPart)
            ->setMerchandisePart($merchandisePart)
            ->setQuantity($quantity)
            ->setQuantityPerPriceType($quantityPerPriceType)
            ->setSeriesPart($seriesPart)
            ->setTransactionId($transactionId);
    }
    /**
     * Get BundleId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBundleId()
    {
        return isset($this->BundleId) ? $this->BundleId : null;
    }
    /**
     * Set BundleId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bundleId
     * @return \patest\StructType\BizAction_Facade_HandleBundle_Request
     */
    public function setBundleId($bundleId = null)
    {
        // validation for constraint: string
        if (!is_null($bundleId) && !is_string($bundleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bundleId, true), gettype($bundleId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($bundleId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $bundleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($bundleId, true)), __LINE__);
        }
        if (is_null($bundleId) || (is_array($bundleId) && empty($bundleId))) {
            unset($this->BundleId);
        } else {
            $this->BundleId = $bundleId;
        }
        return $this;
    }
    /**
     * Get EventsPart value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Facade_BundleRelatedEventsPart|null
     */
    public function getEventsPart()
    {
        return isset($this->EventsPart) ? $this->EventsPart : null;
    }
    /**
     * Set EventsPart value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Facade_BundleRelatedEventsPart $eventsPart
     * @return \patest\StructType\BizAction_Facade_HandleBundle_Request
     */
    public function setEventsPart(\patest\StructType\Facade_BundleRelatedEventsPart $eventsPart = null)
    {
        if (is_null($eventsPart) || (is_array($eventsPart) && empty($eventsPart))) {
            unset($this->EventsPart);
        } else {
            $this->EventsPart = $eventsPart;
        }
        return $this;
    }
    /**
     * Get GiftVouchersPart value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Facade_BundleRelatedGiftVouchersPart|null
     */
    public function getGiftVouchersPart()
    {
        return isset($this->GiftVouchersPart) ? $this->GiftVouchersPart : null;
    }
    /**
     * Set GiftVouchersPart value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Facade_BundleRelatedGiftVouchersPart $giftVouchersPart
     * @return \patest\StructType\BizAction_Facade_HandleBundle_Request
     */
    public function setGiftVouchersPart(\patest\StructType\Facade_BundleRelatedGiftVouchersPart $giftVouchersPart = null)
    {
        if (is_null($giftVouchersPart) || (is_array($giftVouchersPart) && empty($giftVouchersPart))) {
            unset($this->GiftVouchersPart);
        } else {
            $this->GiftVouchersPart = $giftVouchersPart;
        }
        return $this;
    }
    /**
     * Get MembershipsPart value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Facade_BundleRelatedMembershipsPart|null
     */
    public function getMembershipsPart()
    {
        return isset($this->MembershipsPart) ? $this->MembershipsPart : null;
    }
    /**
     * Set MembershipsPart value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Facade_BundleRelatedMembershipsPart $membershipsPart
     * @return \patest\StructType\BizAction_Facade_HandleBundle_Request
     */
    public function setMembershipsPart(\patest\StructType\Facade_BundleRelatedMembershipsPart $membershipsPart = null)
    {
        if (is_null($membershipsPart) || (is_array($membershipsPart) && empty($membershipsPart))) {
            unset($this->MembershipsPart);
        } else {
            $this->MembershipsPart = $membershipsPart;
        }
        return $this;
    }
    /**
     * Get MerchandisePart value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Facade_BundleRelatedMerchandisePart|null
     */
    public function getMerchandisePart()
    {
        return isset($this->MerchandisePart) ? $this->MerchandisePart : null;
    }
    /**
     * Set MerchandisePart value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Facade_BundleRelatedMerchandisePart $merchandisePart
     * @return \patest\StructType\BizAction_Facade_HandleBundle_Request
     */
    public function setMerchandisePart(\patest\StructType\Facade_BundleRelatedMerchandisePart $merchandisePart = null)
    {
        if (is_null($merchandisePart) || (is_array($merchandisePart) && empty($merchandisePart))) {
            unset($this->MerchandisePart);
        } else {
            $this->MerchandisePart = $merchandisePart;
        }
        return $this;
    }
    /**
     * Get Quantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getQuantity()
    {
        return isset($this->Quantity) ? $this->Quantity : null;
    }
    /**
     * Set Quantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $quantity
     * @return \patest\StructType\BizAction_Facade_HandleBundle_Request
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        if (is_null($quantity) || (is_array($quantity) && empty($quantity))) {
            unset($this->Quantity);
        } else {
            $this->Quantity = $quantity;
        }
        return $this;
    }
    /**
     * Get QuantityPerPriceType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfFacade_PriceTypeBundleQuantity|null
     */
    public function getQuantityPerPriceType()
    {
        return isset($this->QuantityPerPriceType) ? $this->QuantityPerPriceType : null;
    }
    /**
     * Set QuantityPerPriceType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfFacade_PriceTypeBundleQuantity $quantityPerPriceType
     * @return \patest\StructType\BizAction_Facade_HandleBundle_Request
     */
    public function setQuantityPerPriceType(\patest\StructType\RecordSetOfFacade_PriceTypeBundleQuantity $quantityPerPriceType = null)
    {
        if (is_null($quantityPerPriceType) || (is_array($quantityPerPriceType) && empty($quantityPerPriceType))) {
            unset($this->QuantityPerPriceType);
        } else {
            $this->QuantityPerPriceType = $quantityPerPriceType;
        }
        return $this;
    }
    /**
     * Get SeriesPart value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Facade_BundleRelatedSeriesPart|null
     */
    public function getSeriesPart()
    {
        return isset($this->SeriesPart) ? $this->SeriesPart : null;
    }
    /**
     * Set SeriesPart value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Facade_BundleRelatedSeriesPart $seriesPart
     * @return \patest\StructType\BizAction_Facade_HandleBundle_Request
     */
    public function setSeriesPart(\patest\StructType\Facade_BundleRelatedSeriesPart $seriesPart = null)
    {
        if (is_null($seriesPart) || (is_array($seriesPart) && empty($seriesPart))) {
            unset($this->SeriesPart);
        } else {
            $this->SeriesPart = $seriesPart;
        }
        return $this;
    }
    /**
     * Get TransactionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionId()
    {
        return isset($this->TransactionId) ? $this->TransactionId : null;
    }
    /**
     * Set TransactionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionId
     * @return \patest\StructType\BizAction_Facade_HandleBundle_Request
     */
    public function setTransactionId($transactionId = null)
    {
        // validation for constraint: string
        if (!is_null($transactionId) && !is_string($transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionId, true), gettype($transactionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionId, true)), __LINE__);
        }
        if (is_null($transactionId) || (is_array($transactionId) && empty($transactionId))) {
            unset($this->TransactionId);
        } else {
            $this->TransactionId = $transactionId;
        }
        return $this;
    }
}
