<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Donation.PrintMatchingGifts.Request StructType
 * @subpackage Structs
 */
class BizAction_Donation_PrintMatchingGifts_Request extends BizAction_Donation_MatchingGifts_Request_Base
{
    /**
     * The SendBy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SendBy;
    /**
     * The TargetPrinterId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TargetPrinterId;
    /**
     * Constructor method for BizAction.Donation.PrintMatchingGifts.Request
     * @uses BizAction_Donation_PrintMatchingGifts_Request::setSendBy()
     * @uses BizAction_Donation_PrintMatchingGifts_Request::setTargetPrinterId()
     * @param string $sendBy
     * @param string $targetPrinterId
     */
    public function __construct($sendBy = null, $targetPrinterId = null)
    {
        $this
            ->setSendBy($sendBy)
            ->setTargetPrinterId($targetPrinterId);
    }
    /**
     * Get SendBy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSendBy()
    {
        return isset($this->SendBy) ? $this->SendBy : null;
    }
    /**
     * Set SendBy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PrintMatchingGiftsSendBy::valueIsValid()
     * @uses \patest\EnumType\PrintMatchingGiftsSendBy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sendBy
     * @return \patest\StructType\BizAction_Donation_PrintMatchingGifts_Request
     */
    public function setSendBy($sendBy = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PrintMatchingGiftsSendBy::valueIsValid($sendBy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PrintMatchingGiftsSendBy', is_array($sendBy) ? implode(', ', $sendBy) : var_export($sendBy, true), implode(', ', \patest\EnumType\PrintMatchingGiftsSendBy::getValidValues())), __LINE__);
        }
        if (is_null($sendBy) || (is_array($sendBy) && empty($sendBy))) {
            unset($this->SendBy);
        } else {
            $this->SendBy = $sendBy;
        }
        return $this;
    }
    /**
     * Get TargetPrinterId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetPrinterId()
    {
        return isset($this->TargetPrinterId) ? $this->TargetPrinterId : null;
    }
    /**
     * Set TargetPrinterId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetPrinterId
     * @return \patest\StructType\BizAction_Donation_PrintMatchingGifts_Request
     */
    public function setTargetPrinterId($targetPrinterId = null)
    {
        // validation for constraint: string
        if (!is_null($targetPrinterId) && !is_string($targetPrinterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetPrinterId, true), gettype($targetPrinterId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($targetPrinterId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $targetPrinterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($targetPrinterId, true)), __LINE__);
        }
        if (is_null($targetPrinterId) || (is_array($targetPrinterId) && empty($targetPrinterId))) {
            unset($this->TargetPrinterId);
        } else {
            $this->TargetPrinterId = $targetPrinterId;
        }
        return $this;
    }
}
