<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Donation.MatchingGifts.Request.Base StructType
 * @subpackage Structs
 */
class BizAction_Donation_MatchingGifts_Request_Base extends AnyEntity
{
    /**
     * The BatchId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BatchId;
    /**
     * The ClientsInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfDonation_MatchingGiftsForClient
     */
    public $ClientsInfo;
    /**
     * Constructor method for BizAction.Donation.MatchingGifts.Request.Base
     * @uses BizAction_Donation_MatchingGifts_Request_Base::setBatchId()
     * @uses BizAction_Donation_MatchingGifts_Request_Base::setClientsInfo()
     * @param string $batchId
     * @param \patest\StructType\RecordSetOfDonation_MatchingGiftsForClient $clientsInfo
     */
    public function __construct($batchId = null, \patest\StructType\RecordSetOfDonation_MatchingGiftsForClient $clientsInfo = null)
    {
        $this
            ->setBatchId($batchId)
            ->setClientsInfo($clientsInfo);
    }
    /**
     * Get BatchId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBatchId()
    {
        return isset($this->BatchId) ? $this->BatchId : null;
    }
    /**
     * Set BatchId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $batchId
     * @return \patest\StructType\BizAction_Donation_MatchingGifts_Request_Base
     */
    public function setBatchId($batchId = null)
    {
        // validation for constraint: string
        if (!is_null($batchId) && !is_string($batchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($batchId, true), gettype($batchId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($batchId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $batchId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($batchId, true)), __LINE__);
        }
        if (is_null($batchId) || (is_array($batchId) && empty($batchId))) {
            unset($this->BatchId);
        } else {
            $this->BatchId = $batchId;
        }
        return $this;
    }
    /**
     * Get ClientsInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfDonation_MatchingGiftsForClient|null
     */
    public function getClientsInfo()
    {
        return isset($this->ClientsInfo) ? $this->ClientsInfo : null;
    }
    /**
     * Set ClientsInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfDonation_MatchingGiftsForClient $clientsInfo
     * @return \patest\StructType\BizAction_Donation_MatchingGifts_Request_Base
     */
    public function setClientsInfo(\patest\StructType\RecordSetOfDonation_MatchingGiftsForClient $clientsInfo = null)
    {
        if (is_null($clientsInfo) || (is_array($clientsInfo) && empty($clientsInfo))) {
            unset($this->ClientsInfo);
        } else {
            $this->ClientsInfo = $clientsInfo;
        }
        return $this;
    }
}
