<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Donation.CheckInstallmentDate.Request StructType
 * @subpackage Structs
 */
class BizAction_Donation_CheckInstallmentDate_Request extends AnyEntity
{
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Date;
    /**
     * The InstallmentId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $InstallmentId;
    /**
     * The PledgeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PledgeId;
    /**
     * Constructor method for BizAction.Donation.CheckInstallmentDate.Request
     * @uses BizAction_Donation_CheckInstallmentDate_Request::setDate()
     * @uses BizAction_Donation_CheckInstallmentDate_Request::setInstallmentId()
     * @uses BizAction_Donation_CheckInstallmentDate_Request::setPledgeId()
     * @param string $date
     * @param string $installmentId
     * @param string $pledgeId
     */
    public function __construct($date = null, $installmentId = null, $pledgeId = null)
    {
        $this
            ->setDate($date)
            ->setInstallmentId($installmentId)
            ->setPledgeId($pledgeId);
    }
    /**
     * Get Date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDate()
    {
        return isset($this->Date) ? $this->Date : null;
    }
    /**
     * Set Date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $date
     * @return \patest\StructType\BizAction_Donation_CheckInstallmentDate_Request
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        if (is_null($date) || (is_array($date) && empty($date))) {
            unset($this->Date);
        } else {
            $this->Date = $date;
        }
        return $this;
    }
    /**
     * Get InstallmentId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInstallmentId()
    {
        return isset($this->InstallmentId) ? $this->InstallmentId : null;
    }
    /**
     * Set InstallmentId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $installmentId
     * @return \patest\StructType\BizAction_Donation_CheckInstallmentDate_Request
     */
    public function setInstallmentId($installmentId = null)
    {
        // validation for constraint: string
        if (!is_null($installmentId) && !is_string($installmentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($installmentId, true), gettype($installmentId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($installmentId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $installmentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($installmentId, true)), __LINE__);
        }
        if (is_null($installmentId) || (is_array($installmentId) && empty($installmentId))) {
            unset($this->InstallmentId);
        } else {
            $this->InstallmentId = $installmentId;
        }
        return $this;
    }
    /**
     * Get PledgeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPledgeId()
    {
        return isset($this->PledgeId) ? $this->PledgeId : null;
    }
    /**
     * Set PledgeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pledgeId
     * @return \patest\StructType\BizAction_Donation_CheckInstallmentDate_Request
     */
    public function setPledgeId($pledgeId = null)
    {
        // validation for constraint: string
        if (!is_null($pledgeId) && !is_string($pledgeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pledgeId, true), gettype($pledgeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($pledgeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $pledgeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($pledgeId, true)), __LINE__);
        }
        if (is_null($pledgeId) || (is_array($pledgeId) && empty($pledgeId))) {
            unset($this->PledgeId);
        } else {
            $this->PledgeId = $pledgeId;
        }
        return $this;
    }
}
