<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Crm.RelationshipTypeMaxAllowedOverride
 * StructType
 * @subpackage Structs
 */
class BizAction_Crm_RelationshipTypeMaxAllowedOverride extends AnyEntity
{
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The DefaultMaxAllowed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $DefaultMaxAllowed;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Id;
    /**
     * The IsNew
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsNew;
    /**
     * The MaxAllowedOverride
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxAllowedOverride;
    /**
     * The RelationshipTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RelationshipTypeId;
    /**
     * Constructor method for BizAction.Crm.RelationshipTypeMaxAllowedOverride
     * @uses BizAction_Crm_RelationshipTypeMaxAllowedOverride::setClientId()
     * @uses BizAction_Crm_RelationshipTypeMaxAllowedOverride::setDefaultMaxAllowed()
     * @uses BizAction_Crm_RelationshipTypeMaxAllowedOverride::setId()
     * @uses BizAction_Crm_RelationshipTypeMaxAllowedOverride::setIsNew()
     * @uses BizAction_Crm_RelationshipTypeMaxAllowedOverride::setMaxAllowedOverride()
     * @uses BizAction_Crm_RelationshipTypeMaxAllowedOverride::setRelationshipTypeId()
     * @param string $clientId
     * @param int $defaultMaxAllowed
     * @param string $id
     * @param bool $isNew
     * @param int $maxAllowedOverride
     * @param string $relationshipTypeId
     */
    public function __construct($clientId = null, $defaultMaxAllowed = null, $id = null, $isNew = null, $maxAllowedOverride = null, $relationshipTypeId = null)
    {
        $this
            ->setClientId($clientId)
            ->setDefaultMaxAllowed($defaultMaxAllowed)
            ->setId($id)
            ->setIsNew($isNew)
            ->setMaxAllowedOverride($maxAllowedOverride)
            ->setRelationshipTypeId($relationshipTypeId);
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\BizAction_Crm_RelationshipTypeMaxAllowedOverride
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get DefaultMaxAllowed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDefaultMaxAllowed()
    {
        return isset($this->DefaultMaxAllowed) ? $this->DefaultMaxAllowed : null;
    }
    /**
     * Set DefaultMaxAllowed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $defaultMaxAllowed
     * @return \patest\StructType\BizAction_Crm_RelationshipTypeMaxAllowedOverride
     */
    public function setDefaultMaxAllowed($defaultMaxAllowed = null)
    {
        // validation for constraint: int
        if (!is_null($defaultMaxAllowed) && !(is_int($defaultMaxAllowed) || ctype_digit($defaultMaxAllowed))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($defaultMaxAllowed, true), gettype($defaultMaxAllowed)), __LINE__);
        }
        if (is_null($defaultMaxAllowed) || (is_array($defaultMaxAllowed) && empty($defaultMaxAllowed))) {
            unset($this->DefaultMaxAllowed);
        } else {
            $this->DefaultMaxAllowed = $defaultMaxAllowed;
        }
        return $this;
    }
    /**
     * Get Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getId()
    {
        return isset($this->Id) ? $this->Id : null;
    }
    /**
     * Set Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $id
     * @return \patest\StructType\BizAction_Crm_RelationshipTypeMaxAllowedOverride
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($id, true)), __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->Id);
        } else {
            $this->Id = $id;
        }
        return $this;
    }
    /**
     * Get IsNew value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsNew()
    {
        return isset($this->IsNew) ? $this->IsNew : null;
    }
    /**
     * Set IsNew value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isNew
     * @return \patest\StructType\BizAction_Crm_RelationshipTypeMaxAllowedOverride
     */
    public function setIsNew($isNew = null)
    {
        // validation for constraint: boolean
        if (!is_null($isNew) && !is_bool($isNew)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isNew, true), gettype($isNew)), __LINE__);
        }
        if (is_null($isNew) || (is_array($isNew) && empty($isNew))) {
            unset($this->IsNew);
        } else {
            $this->IsNew = $isNew;
        }
        return $this;
    }
    /**
     * Get MaxAllowedOverride value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxAllowedOverride()
    {
        return isset($this->MaxAllowedOverride) ? $this->MaxAllowedOverride : null;
    }
    /**
     * Set MaxAllowedOverride value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxAllowedOverride
     * @return \patest\StructType\BizAction_Crm_RelationshipTypeMaxAllowedOverride
     */
    public function setMaxAllowedOverride($maxAllowedOverride = null)
    {
        // validation for constraint: int
        if (!is_null($maxAllowedOverride) && !(is_int($maxAllowedOverride) || ctype_digit($maxAllowedOverride))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxAllowedOverride, true), gettype($maxAllowedOverride)), __LINE__);
        }
        if (is_null($maxAllowedOverride) || (is_array($maxAllowedOverride) && empty($maxAllowedOverride))) {
            unset($this->MaxAllowedOverride);
        } else {
            $this->MaxAllowedOverride = $maxAllowedOverride;
        }
        return $this;
    }
    /**
     * Get RelationshipTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelationshipTypeId()
    {
        return isset($this->RelationshipTypeId) ? $this->RelationshipTypeId : null;
    }
    /**
     * Set RelationshipTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relationshipTypeId
     * @return \patest\StructType\BizAction_Crm_RelationshipTypeMaxAllowedOverride
     */
    public function setRelationshipTypeId($relationshipTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($relationshipTypeId) && !is_string($relationshipTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relationshipTypeId, true), gettype($relationshipTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($relationshipTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $relationshipTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($relationshipTypeId, true)), __LINE__);
        }
        if (is_null($relationshipTypeId) || (is_array($relationshipTypeId) && empty($relationshipTypeId))) {
            unset($this->RelationshipTypeId);
        } else {
            $this->RelationshipTypeId = $relationshipTypeId;
        }
        return $this;
    }
}
