<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Crm.RegisterClientInteraction.Request StructType
 * @subpackage Structs
 */
class BizAction_Crm_RegisterClientInteraction_Request extends AnyEntity
{
    /**
     * The AddLog
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AddLog;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The ContactDetail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContactDetail;
    /**
     * The ContactTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ContactTypeId;
    /**
     * The RemarkTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RemarkTypeId;
    /**
     * The Summary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Summary;
    /**
     * Constructor method for BizAction.Crm.RegisterClientInteraction.Request
     * @uses BizAction_Crm_RegisterClientInteraction_Request::setAddLog()
     * @uses BizAction_Crm_RegisterClientInteraction_Request::setClientId()
     * @uses BizAction_Crm_RegisterClientInteraction_Request::setContactDetail()
     * @uses BizAction_Crm_RegisterClientInteraction_Request::setContactTypeId()
     * @uses BizAction_Crm_RegisterClientInteraction_Request::setRemarkTypeId()
     * @uses BizAction_Crm_RegisterClientInteraction_Request::setSummary()
     * @param bool $addLog
     * @param string $clientId
     * @param string $contactDetail
     * @param string $contactTypeId
     * @param string $remarkTypeId
     * @param string $summary
     */
    public function __construct($addLog = null, $clientId = null, $contactDetail = null, $contactTypeId = null, $remarkTypeId = null, $summary = null)
    {
        $this
            ->setAddLog($addLog)
            ->setClientId($clientId)
            ->setContactDetail($contactDetail)
            ->setContactTypeId($contactTypeId)
            ->setRemarkTypeId($remarkTypeId)
            ->setSummary($summary);
    }
    /**
     * Get AddLog value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAddLog()
    {
        return isset($this->AddLog) ? $this->AddLog : null;
    }
    /**
     * Set AddLog value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $addLog
     * @return \patest\StructType\BizAction_Crm_RegisterClientInteraction_Request
     */
    public function setAddLog($addLog = null)
    {
        // validation for constraint: boolean
        if (!is_null($addLog) && !is_bool($addLog)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($addLog, true), gettype($addLog)), __LINE__);
        }
        if (is_null($addLog) || (is_array($addLog) && empty($addLog))) {
            unset($this->AddLog);
        } else {
            $this->AddLog = $addLog;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\BizAction_Crm_RegisterClientInteraction_Request
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get ContactDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContactDetail()
    {
        return isset($this->ContactDetail) ? $this->ContactDetail : null;
    }
    /**
     * Set ContactDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contactDetail
     * @return \patest\StructType\BizAction_Crm_RegisterClientInteraction_Request
     */
    public function setContactDetail($contactDetail = null)
    {
        // validation for constraint: string
        if (!is_null($contactDetail) && !is_string($contactDetail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactDetail, true), gettype($contactDetail)), __LINE__);
        }
        if (is_null($contactDetail) || (is_array($contactDetail) && empty($contactDetail))) {
            unset($this->ContactDetail);
        } else {
            $this->ContactDetail = $contactDetail;
        }
        return $this;
    }
    /**
     * Get ContactTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContactTypeId()
    {
        return isset($this->ContactTypeId) ? $this->ContactTypeId : null;
    }
    /**
     * Set ContactTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contactTypeId
     * @return \patest\StructType\BizAction_Crm_RegisterClientInteraction_Request
     */
    public function setContactTypeId($contactTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($contactTypeId) && !is_string($contactTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactTypeId, true), gettype($contactTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($contactTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $contactTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($contactTypeId, true)), __LINE__);
        }
        if (is_null($contactTypeId) || (is_array($contactTypeId) && empty($contactTypeId))) {
            unset($this->ContactTypeId);
        } else {
            $this->ContactTypeId = $contactTypeId;
        }
        return $this;
    }
    /**
     * Get RemarkTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRemarkTypeId()
    {
        return isset($this->RemarkTypeId) ? $this->RemarkTypeId : null;
    }
    /**
     * Set RemarkTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $remarkTypeId
     * @return \patest\StructType\BizAction_Crm_RegisterClientInteraction_Request
     */
    public function setRemarkTypeId($remarkTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($remarkTypeId) && !is_string($remarkTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remarkTypeId, true), gettype($remarkTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($remarkTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $remarkTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($remarkTypeId, true)), __LINE__);
        }
        if (is_null($remarkTypeId) || (is_array($remarkTypeId) && empty($remarkTypeId))) {
            unset($this->RemarkTypeId);
        } else {
            $this->RemarkTypeId = $remarkTypeId;
        }
        return $this;
    }
    /**
     * Get Summary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSummary()
    {
        return isset($this->Summary) ? $this->Summary : null;
    }
    /**
     * Set Summary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $summary
     * @return \patest\StructType\BizAction_Crm_RegisterClientInteraction_Request
     */
    public function setSummary($summary = null)
    {
        // validation for constraint: string
        if (!is_null($summary) && !is_string($summary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($summary, true), gettype($summary)), __LINE__);
        }
        if (is_null($summary) || (is_array($summary) && empty($summary))) {
            unset($this->Summary);
        } else {
            $this->Summary = $summary;
        }
        return $this;
    }
}
