<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Crm.MergeCities.Request StructType
 * @subpackage Structs
 */
class BizAction_Crm_MergeCities_Request extends AnyEntity
{
    /**
     * The AllCityIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\AllCityIds
     */
    public $AllCityIds;
    /**
     * The TargetCityId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TargetCityId;
    /**
     * Constructor method for BizAction.Crm.MergeCities.Request
     * @uses BizAction_Crm_MergeCities_Request::setAllCityIds()
     * @uses BizAction_Crm_MergeCities_Request::setTargetCityId()
     * @param \patest\StructType\AllCityIds $allCityIds
     * @param string $targetCityId
     */
    public function __construct(\patest\StructType\AllCityIds $allCityIds = null, $targetCityId = null)
    {
        $this
            ->setAllCityIds($allCityIds)
            ->setTargetCityId($targetCityId);
    }
    /**
     * Get AllCityIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\AllCityIds|null
     */
    public function getAllCityIds()
    {
        return isset($this->AllCityIds) ? $this->AllCityIds : null;
    }
    /**
     * Set AllCityIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\AllCityIds $allCityIds
     * @return \patest\StructType\BizAction_Crm_MergeCities_Request
     */
    public function setAllCityIds(\patest\StructType\AllCityIds $allCityIds = null)
    {
        if (is_null($allCityIds) || (is_array($allCityIds) && empty($allCityIds))) {
            unset($this->AllCityIds);
        } else {
            $this->AllCityIds = $allCityIds;
        }
        return $this;
    }
    /**
     * Get TargetCityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetCityId()
    {
        return isset($this->TargetCityId) ? $this->TargetCityId : null;
    }
    /**
     * Set TargetCityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetCityId
     * @return \patest\StructType\BizAction_Crm_MergeCities_Request
     */
    public function setTargetCityId($targetCityId = null)
    {
        // validation for constraint: string
        if (!is_null($targetCityId) && !is_string($targetCityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetCityId, true), gettype($targetCityId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($targetCityId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $targetCityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($targetCityId, true)), __LINE__);
        }
        if (is_null($targetCityId) || (is_array($targetCityId) && empty($targetCityId))) {
            unset($this->TargetCityId);
        } else {
            $this->TargetCityId = $targetCityId;
        }
        return $this;
    }
}
