<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Crm.MembershipAutoRenewalEnrollments.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Crm_MembershipAutoRenewalEnrollments_Request extends AnyEntity
{
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The DirectDebitMandateId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DirectDebitMandateId;
    /**
     * The EnrolledMemberships
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfBizAction_Crm_AutoRenewalClientEnrollment
     */
    public $EnrolledMemberships;
    /**
     * The IsEnrollWithoutPaymentDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsEnrollWithoutPaymentDetails;
    /**
     * The IsOnlyNewEnrollments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsOnlyNewEnrollments;
    /**
     * The IsRemoveEnrolledMemberships
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsRemoveEnrolledMemberships;
    /**
     * The MembershipDefinitionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MembershipDefinitionId;
    /**
     * The MembershipId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MembershipId;
    /**
     * The MembershipName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $MembershipName;
    /**
     * The PaymentMethodId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentMethodId;
    /**
     * The PaymentMethodType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentMethodType;
    /**
     * The PaymentTokenId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentTokenId;
    /**
     * Constructor method for BizAction.Crm.MembershipAutoRenewalEnrollments.Request
     * @uses BizAction_Crm_MembershipAutoRenewalEnrollments_Request::setClientId()
     * @uses BizAction_Crm_MembershipAutoRenewalEnrollments_Request::setDirectDebitMandateId()
     * @uses BizAction_Crm_MembershipAutoRenewalEnrollments_Request::setEnrolledMemberships()
     * @uses BizAction_Crm_MembershipAutoRenewalEnrollments_Request::setIsEnrollWithoutPaymentDetails()
     * @uses BizAction_Crm_MembershipAutoRenewalEnrollments_Request::setIsOnlyNewEnrollments()
     * @uses BizAction_Crm_MembershipAutoRenewalEnrollments_Request::setIsRemoveEnrolledMemberships()
     * @uses BizAction_Crm_MembershipAutoRenewalEnrollments_Request::setMembershipDefinitionId()
     * @uses BizAction_Crm_MembershipAutoRenewalEnrollments_Request::setMembershipId()
     * @uses BizAction_Crm_MembershipAutoRenewalEnrollments_Request::setMembershipName()
     * @uses BizAction_Crm_MembershipAutoRenewalEnrollments_Request::setPaymentMethodId()
     * @uses BizAction_Crm_MembershipAutoRenewalEnrollments_Request::setPaymentMethodType()
     * @uses BizAction_Crm_MembershipAutoRenewalEnrollments_Request::setPaymentTokenId()
     * @param string $clientId
     * @param string $directDebitMandateId
     * @param \patest\StructType\RecordSetOfBizAction_Crm_AutoRenewalClientEnrollment $enrolledMemberships
     * @param bool $isEnrollWithoutPaymentDetails
     * @param bool $isOnlyNewEnrollments
     * @param bool $isRemoveEnrolledMemberships
     * @param string $membershipDefinitionId
     * @param string $membershipId
     * @param \patest\StructType\GlobalString $membershipName
     * @param string $paymentMethodId
     * @param string $paymentMethodType
     * @param string $paymentTokenId
     */
    public function __construct($clientId = null, $directDebitMandateId = null, \patest\StructType\RecordSetOfBizAction_Crm_AutoRenewalClientEnrollment $enrolledMemberships = null, $isEnrollWithoutPaymentDetails = null, $isOnlyNewEnrollments = null, $isRemoveEnrolledMemberships = null, $membershipDefinitionId = null, $membershipId = null, \patest\StructType\GlobalString $membershipName = null, $paymentMethodId = null, $paymentMethodType = null, $paymentTokenId = null)
    {
        $this
            ->setClientId($clientId)
            ->setDirectDebitMandateId($directDebitMandateId)
            ->setEnrolledMemberships($enrolledMemberships)
            ->setIsEnrollWithoutPaymentDetails($isEnrollWithoutPaymentDetails)
            ->setIsOnlyNewEnrollments($isOnlyNewEnrollments)
            ->setIsRemoveEnrolledMemberships($isRemoveEnrolledMemberships)
            ->setMembershipDefinitionId($membershipDefinitionId)
            ->setMembershipId($membershipId)
            ->setMembershipName($membershipName)
            ->setPaymentMethodId($paymentMethodId)
            ->setPaymentMethodType($paymentMethodType)
            ->setPaymentTokenId($paymentTokenId);
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\BizAction_Crm_MembershipAutoRenewalEnrollments_Request
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get DirectDebitMandateId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDirectDebitMandateId()
    {
        return isset($this->DirectDebitMandateId) ? $this->DirectDebitMandateId : null;
    }
    /**
     * Set DirectDebitMandateId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $directDebitMandateId
     * @return \patest\StructType\BizAction_Crm_MembershipAutoRenewalEnrollments_Request
     */
    public function setDirectDebitMandateId($directDebitMandateId = null)
    {
        // validation for constraint: string
        if (!is_null($directDebitMandateId) && !is_string($directDebitMandateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($directDebitMandateId, true), gettype($directDebitMandateId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($directDebitMandateId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $directDebitMandateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($directDebitMandateId, true)), __LINE__);
        }
        if (is_null($directDebitMandateId) || (is_array($directDebitMandateId) && empty($directDebitMandateId))) {
            unset($this->DirectDebitMandateId);
        } else {
            $this->DirectDebitMandateId = $directDebitMandateId;
        }
        return $this;
    }
    /**
     * Get EnrolledMemberships value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfBizAction_Crm_AutoRenewalClientEnrollment|null
     */
    public function getEnrolledMemberships()
    {
        return isset($this->EnrolledMemberships) ? $this->EnrolledMemberships : null;
    }
    /**
     * Set EnrolledMemberships value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfBizAction_Crm_AutoRenewalClientEnrollment $enrolledMemberships
     * @return \patest\StructType\BizAction_Crm_MembershipAutoRenewalEnrollments_Request
     */
    public function setEnrolledMemberships(\patest\StructType\RecordSetOfBizAction_Crm_AutoRenewalClientEnrollment $enrolledMemberships = null)
    {
        if (is_null($enrolledMemberships) || (is_array($enrolledMemberships) && empty($enrolledMemberships))) {
            unset($this->EnrolledMemberships);
        } else {
            $this->EnrolledMemberships = $enrolledMemberships;
        }
        return $this;
    }
    /**
     * Get IsEnrollWithoutPaymentDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsEnrollWithoutPaymentDetails()
    {
        return isset($this->IsEnrollWithoutPaymentDetails) ? $this->IsEnrollWithoutPaymentDetails : null;
    }
    /**
     * Set IsEnrollWithoutPaymentDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isEnrollWithoutPaymentDetails
     * @return \patest\StructType\BizAction_Crm_MembershipAutoRenewalEnrollments_Request
     */
    public function setIsEnrollWithoutPaymentDetails($isEnrollWithoutPaymentDetails = null)
    {
        // validation for constraint: boolean
        if (!is_null($isEnrollWithoutPaymentDetails) && !is_bool($isEnrollWithoutPaymentDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isEnrollWithoutPaymentDetails, true), gettype($isEnrollWithoutPaymentDetails)), __LINE__);
        }
        if (is_null($isEnrollWithoutPaymentDetails) || (is_array($isEnrollWithoutPaymentDetails) && empty($isEnrollWithoutPaymentDetails))) {
            unset($this->IsEnrollWithoutPaymentDetails);
        } else {
            $this->IsEnrollWithoutPaymentDetails = $isEnrollWithoutPaymentDetails;
        }
        return $this;
    }
    /**
     * Get IsOnlyNewEnrollments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsOnlyNewEnrollments()
    {
        return isset($this->IsOnlyNewEnrollments) ? $this->IsOnlyNewEnrollments : null;
    }
    /**
     * Set IsOnlyNewEnrollments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isOnlyNewEnrollments
     * @return \patest\StructType\BizAction_Crm_MembershipAutoRenewalEnrollments_Request
     */
    public function setIsOnlyNewEnrollments($isOnlyNewEnrollments = null)
    {
        // validation for constraint: boolean
        if (!is_null($isOnlyNewEnrollments) && !is_bool($isOnlyNewEnrollments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isOnlyNewEnrollments, true), gettype($isOnlyNewEnrollments)), __LINE__);
        }
        if (is_null($isOnlyNewEnrollments) || (is_array($isOnlyNewEnrollments) && empty($isOnlyNewEnrollments))) {
            unset($this->IsOnlyNewEnrollments);
        } else {
            $this->IsOnlyNewEnrollments = $isOnlyNewEnrollments;
        }
        return $this;
    }
    /**
     * Get IsRemoveEnrolledMemberships value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsRemoveEnrolledMemberships()
    {
        return isset($this->IsRemoveEnrolledMemberships) ? $this->IsRemoveEnrolledMemberships : null;
    }
    /**
     * Set IsRemoveEnrolledMemberships value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isRemoveEnrolledMemberships
     * @return \patest\StructType\BizAction_Crm_MembershipAutoRenewalEnrollments_Request
     */
    public function setIsRemoveEnrolledMemberships($isRemoveEnrolledMemberships = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRemoveEnrolledMemberships) && !is_bool($isRemoveEnrolledMemberships)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isRemoveEnrolledMemberships, true), gettype($isRemoveEnrolledMemberships)), __LINE__);
        }
        if (is_null($isRemoveEnrolledMemberships) || (is_array($isRemoveEnrolledMemberships) && empty($isRemoveEnrolledMemberships))) {
            unset($this->IsRemoveEnrolledMemberships);
        } else {
            $this->IsRemoveEnrolledMemberships = $isRemoveEnrolledMemberships;
        }
        return $this;
    }
    /**
     * Get MembershipDefinitionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMembershipDefinitionId()
    {
        return isset($this->MembershipDefinitionId) ? $this->MembershipDefinitionId : null;
    }
    /**
     * Set MembershipDefinitionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $membershipDefinitionId
     * @return \patest\StructType\BizAction_Crm_MembershipAutoRenewalEnrollments_Request
     */
    public function setMembershipDefinitionId($membershipDefinitionId = null)
    {
        // validation for constraint: string
        if (!is_null($membershipDefinitionId) && !is_string($membershipDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($membershipDefinitionId, true), gettype($membershipDefinitionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($membershipDefinitionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $membershipDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($membershipDefinitionId, true)), __LINE__);
        }
        if (is_null($membershipDefinitionId) || (is_array($membershipDefinitionId) && empty($membershipDefinitionId))) {
            unset($this->MembershipDefinitionId);
        } else {
            $this->MembershipDefinitionId = $membershipDefinitionId;
        }
        return $this;
    }
    /**
     * Get MembershipId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMembershipId()
    {
        return isset($this->MembershipId) ? $this->MembershipId : null;
    }
    /**
     * Set MembershipId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $membershipId
     * @return \patest\StructType\BizAction_Crm_MembershipAutoRenewalEnrollments_Request
     */
    public function setMembershipId($membershipId = null)
    {
        // validation for constraint: string
        if (!is_null($membershipId) && !is_string($membershipId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($membershipId, true), gettype($membershipId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($membershipId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $membershipId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($membershipId, true)), __LINE__);
        }
        if (is_null($membershipId) || (is_array($membershipId) && empty($membershipId))) {
            unset($this->MembershipId);
        } else {
            $this->MembershipId = $membershipId;
        }
        return $this;
    }
    /**
     * Get MembershipName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getMembershipName()
    {
        return isset($this->MembershipName) ? $this->MembershipName : null;
    }
    /**
     * Set MembershipName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $membershipName
     * @return \patest\StructType\BizAction_Crm_MembershipAutoRenewalEnrollments_Request
     */
    public function setMembershipName(\patest\StructType\GlobalString $membershipName = null)
    {
        if (is_null($membershipName) || (is_array($membershipName) && empty($membershipName))) {
            unset($this->MembershipName);
        } else {
            $this->MembershipName = $membershipName;
        }
        return $this;
    }
    /**
     * Get PaymentMethodId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodId()
    {
        return isset($this->PaymentMethodId) ? $this->PaymentMethodId : null;
    }
    /**
     * Set PaymentMethodId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMethodId
     * @return \patest\StructType\BizAction_Crm_MembershipAutoRenewalEnrollments_Request
     */
    public function setPaymentMethodId($paymentMethodId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodId) && !is_string($paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodId, true), gettype($paymentMethodId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentMethodId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentMethodId, true)), __LINE__);
        }
        if (is_null($paymentMethodId) || (is_array($paymentMethodId) && empty($paymentMethodId))) {
            unset($this->PaymentMethodId);
        } else {
            $this->PaymentMethodId = $paymentMethodId;
        }
        return $this;
    }
    /**
     * Get PaymentMethodType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodType()
    {
        return isset($this->PaymentMethodType) ? $this->PaymentMethodType : null;
    }
    /**
     * Set PaymentMethodType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PaymentMethodType::valueIsValid()
     * @uses \patest\EnumType\PaymentMethodType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentMethodType
     * @return \patest\StructType\BizAction_Crm_MembershipAutoRenewalEnrollments_Request
     */
    public function setPaymentMethodType($paymentMethodType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PaymentMethodType::valueIsValid($paymentMethodType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PaymentMethodType', is_array($paymentMethodType) ? implode(', ', $paymentMethodType) : var_export($paymentMethodType, true), implode(', ', \patest\EnumType\PaymentMethodType::getValidValues())), __LINE__);
        }
        if (is_null($paymentMethodType) || (is_array($paymentMethodType) && empty($paymentMethodType))) {
            unset($this->PaymentMethodType);
        } else {
            $this->PaymentMethodType = $paymentMethodType;
        }
        return $this;
    }
    /**
     * Get PaymentTokenId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentTokenId()
    {
        return isset($this->PaymentTokenId) ? $this->PaymentTokenId : null;
    }
    /**
     * Set PaymentTokenId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentTokenId
     * @return \patest\StructType\BizAction_Crm_MembershipAutoRenewalEnrollments_Request
     */
    public function setPaymentTokenId($paymentTokenId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentTokenId) && !is_string($paymentTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentTokenId, true), gettype($paymentTokenId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentTokenId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentTokenId, true)), __LINE__);
        }
        if (is_null($paymentTokenId) || (is_array($paymentTokenId) && empty($paymentTokenId))) {
            unset($this->PaymentTokenId);
        } else {
            $this->PaymentTokenId = $paymentTokenId;
        }
        return $this;
    }
}
