<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Crm.ImportUpdateCustomersFile.Request StructType
 * @subpackage Structs
 */
class BizAction_Crm_ImportUpdateCustomersFile_Request extends AnyEntity
{
    /**
     * The CustomerIdentifierField
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CustomerIdentifierField;
    /**
     * The CustomerMapping
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfCrm_CustomerExternalManipulations_ColumnMapping
     */
    public $CustomerMapping;
    /**
     * The CustomersMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CustomersMode;
    /**
     * The DateTimeFormat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DateTimeFormat;
    /**
     * The Delimiter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Delimiter;
    /**
     * The FileData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FileData;
    /**
     * The FileName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FileName;
    /**
     * The forImport
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $forImport;
    /**
     * The ImportUpdateCustomersErrorsLogId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ImportUpdateCustomersErrorsLogId;
    /**
     * The IsDownloadResults
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDownloadResults;
    /**
     * The IsFirstRowIsHeaderColumn
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsFirstRowIsHeaderColumn;
    /**
     * The Notes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Notes;
    /**
     * The NotSuccessResults
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NotSuccessResults;
    /**
     * The previewData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $previewData;
    /**
     * The SkipClientDuplicationCheck
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SkipClientDuplicationCheck;
    /**
     * The SuccessResults
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SuccessResults;
    /**
     * The UploadedDataId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $UploadedDataId;
    /**
     * Constructor method for BizAction.Crm.ImportUpdateCustomersFile.Request
     * @uses BizAction_Crm_ImportUpdateCustomersFile_Request::setCustomerIdentifierField()
     * @uses BizAction_Crm_ImportUpdateCustomersFile_Request::setCustomerMapping()
     * @uses BizAction_Crm_ImportUpdateCustomersFile_Request::setCustomersMode()
     * @uses BizAction_Crm_ImportUpdateCustomersFile_Request::setDateTimeFormat()
     * @uses BizAction_Crm_ImportUpdateCustomersFile_Request::setDelimiter()
     * @uses BizAction_Crm_ImportUpdateCustomersFile_Request::setFileData()
     * @uses BizAction_Crm_ImportUpdateCustomersFile_Request::setFileName()
     * @uses BizAction_Crm_ImportUpdateCustomersFile_Request::setForImport()
     * @uses BizAction_Crm_ImportUpdateCustomersFile_Request::setImportUpdateCustomersErrorsLogId()
     * @uses BizAction_Crm_ImportUpdateCustomersFile_Request::setIsDownloadResults()
     * @uses BizAction_Crm_ImportUpdateCustomersFile_Request::setIsFirstRowIsHeaderColumn()
     * @uses BizAction_Crm_ImportUpdateCustomersFile_Request::setNotes()
     * @uses BizAction_Crm_ImportUpdateCustomersFile_Request::setNotSuccessResults()
     * @uses BizAction_Crm_ImportUpdateCustomersFile_Request::setPreviewData()
     * @uses BizAction_Crm_ImportUpdateCustomersFile_Request::setSkipClientDuplicationCheck()
     * @uses BizAction_Crm_ImportUpdateCustomersFile_Request::setSuccessResults()
     * @uses BizAction_Crm_ImportUpdateCustomersFile_Request::setUploadedDataId()
     * @param string $customerIdentifierField
     * @param \patest\StructType\RecordSetOfCrm_CustomerExternalManipulations_ColumnMapping $customerMapping
     * @param string $customersMode
     * @param string $dateTimeFormat
     * @param string $delimiter
     * @param string $fileData
     * @param string $fileName
     * @param string $forImport
     * @param string $importUpdateCustomersErrorsLogId
     * @param bool $isDownloadResults
     * @param bool $isFirstRowIsHeaderColumn
     * @param string $notes
     * @param int $notSuccessResults
     * @param string $previewData
     * @param bool $skipClientDuplicationCheck
     * @param int $successResults
     * @param string $uploadedDataId
     */
    public function __construct($customerIdentifierField = null, \patest\StructType\RecordSetOfCrm_CustomerExternalManipulations_ColumnMapping $customerMapping = null, $customersMode = null, $dateTimeFormat = null, $delimiter = null, $fileData = null, $fileName = null, $forImport = null, $importUpdateCustomersErrorsLogId = null, $isDownloadResults = null, $isFirstRowIsHeaderColumn = null, $notes = null, $notSuccessResults = null, $previewData = null, $skipClientDuplicationCheck = null, $successResults = null, $uploadedDataId = null)
    {
        $this
            ->setCustomerIdentifierField($customerIdentifierField)
            ->setCustomerMapping($customerMapping)
            ->setCustomersMode($customersMode)
            ->setDateTimeFormat($dateTimeFormat)
            ->setDelimiter($delimiter)
            ->setFileData($fileData)
            ->setFileName($fileName)
            ->setForImport($forImport)
            ->setImportUpdateCustomersErrorsLogId($importUpdateCustomersErrorsLogId)
            ->setIsDownloadResults($isDownloadResults)
            ->setIsFirstRowIsHeaderColumn($isFirstRowIsHeaderColumn)
            ->setNotes($notes)
            ->setNotSuccessResults($notSuccessResults)
            ->setPreviewData($previewData)
            ->setSkipClientDuplicationCheck($skipClientDuplicationCheck)
            ->setSuccessResults($successResults)
            ->setUploadedDataId($uploadedDataId);
    }
    /**
     * Get CustomerIdentifierField value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCustomerIdentifierField()
    {
        return isset($this->CustomerIdentifierField) ? $this->CustomerIdentifierField : null;
    }
    /**
     * Set CustomerIdentifierField value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\CustomerIdentifierFieldForBatch::valueIsValid()
     * @uses \patest\EnumType\CustomerIdentifierFieldForBatch::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $customerIdentifierField
     * @return \patest\StructType\BizAction_Crm_ImportUpdateCustomersFile_Request
     */
    public function setCustomerIdentifierField($customerIdentifierField = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\CustomerIdentifierFieldForBatch::valueIsValid($customerIdentifierField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\CustomerIdentifierFieldForBatch', is_array($customerIdentifierField) ? implode(', ', $customerIdentifierField) : var_export($customerIdentifierField, true), implode(', ', \patest\EnumType\CustomerIdentifierFieldForBatch::getValidValues())), __LINE__);
        }
        if (is_null($customerIdentifierField) || (is_array($customerIdentifierField) && empty($customerIdentifierField))) {
            unset($this->CustomerIdentifierField);
        } else {
            $this->CustomerIdentifierField = $customerIdentifierField;
        }
        return $this;
    }
    /**
     * Get CustomerMapping value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfCrm_CustomerExternalManipulations_ColumnMapping|null
     */
    public function getCustomerMapping()
    {
        return isset($this->CustomerMapping) ? $this->CustomerMapping : null;
    }
    /**
     * Set CustomerMapping value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfCrm_CustomerExternalManipulations_ColumnMapping $customerMapping
     * @return \patest\StructType\BizAction_Crm_ImportUpdateCustomersFile_Request
     */
    public function setCustomerMapping(\patest\StructType\RecordSetOfCrm_CustomerExternalManipulations_ColumnMapping $customerMapping = null)
    {
        if (is_null($customerMapping) || (is_array($customerMapping) && empty($customerMapping))) {
            unset($this->CustomerMapping);
        } else {
            $this->CustomerMapping = $customerMapping;
        }
        return $this;
    }
    /**
     * Get CustomersMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCustomersMode()
    {
        return isset($this->CustomersMode) ? $this->CustomersMode : null;
    }
    /**
     * Set CustomersMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $customersMode
     * @return \patest\StructType\BizAction_Crm_ImportUpdateCustomersFile_Request
     */
    public function setCustomersMode($customersMode = null)
    {
        // validation for constraint: string
        if (!is_null($customersMode) && !is_string($customersMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customersMode, true), gettype($customersMode)), __LINE__);
        }
        if (is_null($customersMode) || (is_array($customersMode) && empty($customersMode))) {
            unset($this->CustomersMode);
        } else {
            $this->CustomersMode = $customersMode;
        }
        return $this;
    }
    /**
     * Get DateTimeFormat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDateTimeFormat()
    {
        return isset($this->DateTimeFormat) ? $this->DateTimeFormat : null;
    }
    /**
     * Set DateTimeFormat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dateTimeFormat
     * @return \patest\StructType\BizAction_Crm_ImportUpdateCustomersFile_Request
     */
    public function setDateTimeFormat($dateTimeFormat = null)
    {
        // validation for constraint: string
        if (!is_null($dateTimeFormat) && !is_string($dateTimeFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateTimeFormat, true), gettype($dateTimeFormat)), __LINE__);
        }
        if (is_null($dateTimeFormat) || (is_array($dateTimeFormat) && empty($dateTimeFormat))) {
            unset($this->DateTimeFormat);
        } else {
            $this->DateTimeFormat = $dateTimeFormat;
        }
        return $this;
    }
    /**
     * Get Delimiter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDelimiter()
    {
        return isset($this->Delimiter) ? $this->Delimiter : null;
    }
    /**
     * Set Delimiter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $delimiter
     * @return \patest\StructType\BizAction_Crm_ImportUpdateCustomersFile_Request
     */
    public function setDelimiter($delimiter = null)
    {
        // validation for constraint: string
        if (!is_null($delimiter) && !is_string($delimiter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($delimiter, true), gettype($delimiter)), __LINE__);
        }
        if (is_null($delimiter) || (is_array($delimiter) && empty($delimiter))) {
            unset($this->Delimiter);
        } else {
            $this->Delimiter = $delimiter;
        }
        return $this;
    }
    /**
     * Get FileData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFileData()
    {
        return isset($this->FileData) ? $this->FileData : null;
    }
    /**
     * Set FileData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fileData
     * @return \patest\StructType\BizAction_Crm_ImportUpdateCustomersFile_Request
     */
    public function setFileData($fileData = null)
    {
        // validation for constraint: string
        if (!is_null($fileData) && !is_string($fileData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileData, true), gettype($fileData)), __LINE__);
        }
        if (is_null($fileData) || (is_array($fileData) && empty($fileData))) {
            unset($this->FileData);
        } else {
            $this->FileData = $fileData;
        }
        return $this;
    }
    /**
     * Get FileName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFileName()
    {
        return isset($this->FileName) ? $this->FileName : null;
    }
    /**
     * Set FileName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fileName
     * @return \patest\StructType\BizAction_Crm_ImportUpdateCustomersFile_Request
     */
    public function setFileName($fileName = null)
    {
        // validation for constraint: string
        if (!is_null($fileName) && !is_string($fileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileName, true), gettype($fileName)), __LINE__);
        }
        if (is_null($fileName) || (is_array($fileName) && empty($fileName))) {
            unset($this->FileName);
        } else {
            $this->FileName = $fileName;
        }
        return $this;
    }
    /**
     * Get forImport value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getForImport()
    {
        return isset($this->forImport) ? $this->forImport : null;
    }
    /**
     * Set forImport value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $forImport
     * @return \patest\StructType\BizAction_Crm_ImportUpdateCustomersFile_Request
     */
    public function setForImport($forImport = null)
    {
        // validation for constraint: string
        if (!is_null($forImport) && !is_string($forImport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($forImport, true), gettype($forImport)), __LINE__);
        }
        if (is_null($forImport) || (is_array($forImport) && empty($forImport))) {
            unset($this->forImport);
        } else {
            $this->forImport = $forImport;
        }
        return $this;
    }
    /**
     * Get ImportUpdateCustomersErrorsLogId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getImportUpdateCustomersErrorsLogId()
    {
        return isset($this->ImportUpdateCustomersErrorsLogId) ? $this->ImportUpdateCustomersErrorsLogId : null;
    }
    /**
     * Set ImportUpdateCustomersErrorsLogId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $importUpdateCustomersErrorsLogId
     * @return \patest\StructType\BizAction_Crm_ImportUpdateCustomersFile_Request
     */
    public function setImportUpdateCustomersErrorsLogId($importUpdateCustomersErrorsLogId = null)
    {
        // validation for constraint: string
        if (!is_null($importUpdateCustomersErrorsLogId) && !is_string($importUpdateCustomersErrorsLogId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($importUpdateCustomersErrorsLogId, true), gettype($importUpdateCustomersErrorsLogId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($importUpdateCustomersErrorsLogId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $importUpdateCustomersErrorsLogId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($importUpdateCustomersErrorsLogId, true)), __LINE__);
        }
        if (is_null($importUpdateCustomersErrorsLogId) || (is_array($importUpdateCustomersErrorsLogId) && empty($importUpdateCustomersErrorsLogId))) {
            unset($this->ImportUpdateCustomersErrorsLogId);
        } else {
            $this->ImportUpdateCustomersErrorsLogId = $importUpdateCustomersErrorsLogId;
        }
        return $this;
    }
    /**
     * Get IsDownloadResults value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDownloadResults()
    {
        return isset($this->IsDownloadResults) ? $this->IsDownloadResults : null;
    }
    /**
     * Set IsDownloadResults value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDownloadResults
     * @return \patest\StructType\BizAction_Crm_ImportUpdateCustomersFile_Request
     */
    public function setIsDownloadResults($isDownloadResults = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDownloadResults) && !is_bool($isDownloadResults)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDownloadResults, true), gettype($isDownloadResults)), __LINE__);
        }
        if (is_null($isDownloadResults) || (is_array($isDownloadResults) && empty($isDownloadResults))) {
            unset($this->IsDownloadResults);
        } else {
            $this->IsDownloadResults = $isDownloadResults;
        }
        return $this;
    }
    /**
     * Get IsFirstRowIsHeaderColumn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsFirstRowIsHeaderColumn()
    {
        return isset($this->IsFirstRowIsHeaderColumn) ? $this->IsFirstRowIsHeaderColumn : null;
    }
    /**
     * Set IsFirstRowIsHeaderColumn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isFirstRowIsHeaderColumn
     * @return \patest\StructType\BizAction_Crm_ImportUpdateCustomersFile_Request
     */
    public function setIsFirstRowIsHeaderColumn($isFirstRowIsHeaderColumn = null)
    {
        // validation for constraint: boolean
        if (!is_null($isFirstRowIsHeaderColumn) && !is_bool($isFirstRowIsHeaderColumn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isFirstRowIsHeaderColumn, true), gettype($isFirstRowIsHeaderColumn)), __LINE__);
        }
        if (is_null($isFirstRowIsHeaderColumn) || (is_array($isFirstRowIsHeaderColumn) && empty($isFirstRowIsHeaderColumn))) {
            unset($this->IsFirstRowIsHeaderColumn);
        } else {
            $this->IsFirstRowIsHeaderColumn = $isFirstRowIsHeaderColumn;
        }
        return $this;
    }
    /**
     * Get Notes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNotes()
    {
        return isset($this->Notes) ? $this->Notes : null;
    }
    /**
     * Set Notes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $notes
     * @return \patest\StructType\BizAction_Crm_ImportUpdateCustomersFile_Request
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notes, true), gettype($notes)), __LINE__);
        }
        if (is_null($notes) || (is_array($notes) && empty($notes))) {
            unset($this->Notes);
        } else {
            $this->Notes = $notes;
        }
        return $this;
    }
    /**
     * Get NotSuccessResults value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNotSuccessResults()
    {
        return isset($this->NotSuccessResults) ? $this->NotSuccessResults : null;
    }
    /**
     * Set NotSuccessResults value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $notSuccessResults
     * @return \patest\StructType\BizAction_Crm_ImportUpdateCustomersFile_Request
     */
    public function setNotSuccessResults($notSuccessResults = null)
    {
        // validation for constraint: int
        if (!is_null($notSuccessResults) && !(is_int($notSuccessResults) || ctype_digit($notSuccessResults))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($notSuccessResults, true), gettype($notSuccessResults)), __LINE__);
        }
        if (is_null($notSuccessResults) || (is_array($notSuccessResults) && empty($notSuccessResults))) {
            unset($this->NotSuccessResults);
        } else {
            $this->NotSuccessResults = $notSuccessResults;
        }
        return $this;
    }
    /**
     * Get previewData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPreviewData()
    {
        return isset($this->previewData) ? $this->previewData : null;
    }
    /**
     * Set previewData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $previewData
     * @return \patest\StructType\BizAction_Crm_ImportUpdateCustomersFile_Request
     */
    public function setPreviewData($previewData = null)
    {
        // validation for constraint: string
        if (!is_null($previewData) && !is_string($previewData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($previewData, true), gettype($previewData)), __LINE__);
        }
        if (is_null($previewData) || (is_array($previewData) && empty($previewData))) {
            unset($this->previewData);
        } else {
            $this->previewData = $previewData;
        }
        return $this;
    }
    /**
     * Get SkipClientDuplicationCheck value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSkipClientDuplicationCheck()
    {
        return isset($this->SkipClientDuplicationCheck) ? $this->SkipClientDuplicationCheck : null;
    }
    /**
     * Set SkipClientDuplicationCheck value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $skipClientDuplicationCheck
     * @return \patest\StructType\BizAction_Crm_ImportUpdateCustomersFile_Request
     */
    public function setSkipClientDuplicationCheck($skipClientDuplicationCheck = null)
    {
        // validation for constraint: boolean
        if (!is_null($skipClientDuplicationCheck) && !is_bool($skipClientDuplicationCheck)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($skipClientDuplicationCheck, true), gettype($skipClientDuplicationCheck)), __LINE__);
        }
        if (is_null($skipClientDuplicationCheck) || (is_array($skipClientDuplicationCheck) && empty($skipClientDuplicationCheck))) {
            unset($this->SkipClientDuplicationCheck);
        } else {
            $this->SkipClientDuplicationCheck = $skipClientDuplicationCheck;
        }
        return $this;
    }
    /**
     * Get SuccessResults value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSuccessResults()
    {
        return isset($this->SuccessResults) ? $this->SuccessResults : null;
    }
    /**
     * Set SuccessResults value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $successResults
     * @return \patest\StructType\BizAction_Crm_ImportUpdateCustomersFile_Request
     */
    public function setSuccessResults($successResults = null)
    {
        // validation for constraint: int
        if (!is_null($successResults) && !(is_int($successResults) || ctype_digit($successResults))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($successResults, true), gettype($successResults)), __LINE__);
        }
        if (is_null($successResults) || (is_array($successResults) && empty($successResults))) {
            unset($this->SuccessResults);
        } else {
            $this->SuccessResults = $successResults;
        }
        return $this;
    }
    /**
     * Get UploadedDataId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUploadedDataId()
    {
        return isset($this->UploadedDataId) ? $this->UploadedDataId : null;
    }
    /**
     * Set UploadedDataId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uploadedDataId
     * @return \patest\StructType\BizAction_Crm_ImportUpdateCustomersFile_Request
     */
    public function setUploadedDataId($uploadedDataId = null)
    {
        // validation for constraint: string
        if (!is_null($uploadedDataId) && !is_string($uploadedDataId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uploadedDataId, true), gettype($uploadedDataId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($uploadedDataId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $uploadedDataId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($uploadedDataId, true)), __LINE__);
        }
        if (is_null($uploadedDataId) || (is_array($uploadedDataId) && empty($uploadedDataId))) {
            unset($this->UploadedDataId);
        } else {
            $this->UploadedDataId = $uploadedDataId;
        }
        return $this;
    }
}
