<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Crm.ConfirmRelationship.Request StructType
 * @subpackage Structs
 */
class BizAction_Crm_ConfirmRelationship_Request extends AnyEntity
{
    /**
     * The IsRelationshipTemporary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsRelationshipTemporary;
    /**
     * The LeftClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $LeftClientId;
    /**
     * The RelationshipId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RelationshipId;
    /**
     * The RelevantClients
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfCrm_Customer
     */
    public $RelevantClients;
    /**
     * The SelectedClientEmail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SelectedClientEmail;
    /**
     * The SelectedClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SelectedClientId;
    /**
     * Constructor method for BizAction.Crm.ConfirmRelationship.Request
     * @uses BizAction_Crm_ConfirmRelationship_Request::setIsRelationshipTemporary()
     * @uses BizAction_Crm_ConfirmRelationship_Request::setLeftClientId()
     * @uses BizAction_Crm_ConfirmRelationship_Request::setRelationshipId()
     * @uses BizAction_Crm_ConfirmRelationship_Request::setRelevantClients()
     * @uses BizAction_Crm_ConfirmRelationship_Request::setSelectedClientEmail()
     * @uses BizAction_Crm_ConfirmRelationship_Request::setSelectedClientId()
     * @param bool $isRelationshipTemporary
     * @param string $leftClientId
     * @param string $relationshipId
     * @param \patest\StructType\RecordSetOfCrm_Customer $relevantClients
     * @param string $selectedClientEmail
     * @param string $selectedClientId
     */
    public function __construct($isRelationshipTemporary = null, $leftClientId = null, $relationshipId = null, \patest\StructType\RecordSetOfCrm_Customer $relevantClients = null, $selectedClientEmail = null, $selectedClientId = null)
    {
        $this
            ->setIsRelationshipTemporary($isRelationshipTemporary)
            ->setLeftClientId($leftClientId)
            ->setRelationshipId($relationshipId)
            ->setRelevantClients($relevantClients)
            ->setSelectedClientEmail($selectedClientEmail)
            ->setSelectedClientId($selectedClientId);
    }
    /**
     * Get IsRelationshipTemporary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsRelationshipTemporary()
    {
        return isset($this->IsRelationshipTemporary) ? $this->IsRelationshipTemporary : null;
    }
    /**
     * Set IsRelationshipTemporary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isRelationshipTemporary
     * @return \patest\StructType\BizAction_Crm_ConfirmRelationship_Request
     */
    public function setIsRelationshipTemporary($isRelationshipTemporary = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRelationshipTemporary) && !is_bool($isRelationshipTemporary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isRelationshipTemporary, true), gettype($isRelationshipTemporary)), __LINE__);
        }
        if (is_null($isRelationshipTemporary) || (is_array($isRelationshipTemporary) && empty($isRelationshipTemporary))) {
            unset($this->IsRelationshipTemporary);
        } else {
            $this->IsRelationshipTemporary = $isRelationshipTemporary;
        }
        return $this;
    }
    /**
     * Get LeftClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLeftClientId()
    {
        return isset($this->LeftClientId) ? $this->LeftClientId : null;
    }
    /**
     * Set LeftClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $leftClientId
     * @return \patest\StructType\BizAction_Crm_ConfirmRelationship_Request
     */
    public function setLeftClientId($leftClientId = null)
    {
        // validation for constraint: string
        if (!is_null($leftClientId) && !is_string($leftClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($leftClientId, true), gettype($leftClientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($leftClientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $leftClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($leftClientId, true)), __LINE__);
        }
        if (is_null($leftClientId) || (is_array($leftClientId) && empty($leftClientId))) {
            unset($this->LeftClientId);
        } else {
            $this->LeftClientId = $leftClientId;
        }
        return $this;
    }
    /**
     * Get RelationshipId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelationshipId()
    {
        return isset($this->RelationshipId) ? $this->RelationshipId : null;
    }
    /**
     * Set RelationshipId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relationshipId
     * @return \patest\StructType\BizAction_Crm_ConfirmRelationship_Request
     */
    public function setRelationshipId($relationshipId = null)
    {
        // validation for constraint: string
        if (!is_null($relationshipId) && !is_string($relationshipId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relationshipId, true), gettype($relationshipId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($relationshipId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $relationshipId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($relationshipId, true)), __LINE__);
        }
        if (is_null($relationshipId) || (is_array($relationshipId) && empty($relationshipId))) {
            unset($this->RelationshipId);
        } else {
            $this->RelationshipId = $relationshipId;
        }
        return $this;
    }
    /**
     * Get RelevantClients value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfCrm_Customer|null
     */
    public function getRelevantClients()
    {
        return isset($this->RelevantClients) ? $this->RelevantClients : null;
    }
    /**
     * Set RelevantClients value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfCrm_Customer $relevantClients
     * @return \patest\StructType\BizAction_Crm_ConfirmRelationship_Request
     */
    public function setRelevantClients(\patest\StructType\RecordSetOfCrm_Customer $relevantClients = null)
    {
        if (is_null($relevantClients) || (is_array($relevantClients) && empty($relevantClients))) {
            unset($this->RelevantClients);
        } else {
            $this->RelevantClients = $relevantClients;
        }
        return $this;
    }
    /**
     * Get SelectedClientEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSelectedClientEmail()
    {
        return isset($this->SelectedClientEmail) ? $this->SelectedClientEmail : null;
    }
    /**
     * Set SelectedClientEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $selectedClientEmail
     * @return \patest\StructType\BizAction_Crm_ConfirmRelationship_Request
     */
    public function setSelectedClientEmail($selectedClientEmail = null)
    {
        // validation for constraint: string
        if (!is_null($selectedClientEmail) && !is_string($selectedClientEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($selectedClientEmail, true), gettype($selectedClientEmail)), __LINE__);
        }
        if (is_null($selectedClientEmail) || (is_array($selectedClientEmail) && empty($selectedClientEmail))) {
            unset($this->SelectedClientEmail);
        } else {
            $this->SelectedClientEmail = $selectedClientEmail;
        }
        return $this;
    }
    /**
     * Get SelectedClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSelectedClientId()
    {
        return isset($this->SelectedClientId) ? $this->SelectedClientId : null;
    }
    /**
     * Set SelectedClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $selectedClientId
     * @return \patest\StructType\BizAction_Crm_ConfirmRelationship_Request
     */
    public function setSelectedClientId($selectedClientId = null)
    {
        // validation for constraint: string
        if (!is_null($selectedClientId) && !is_string($selectedClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($selectedClientId, true), gettype($selectedClientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($selectedClientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $selectedClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($selectedClientId, true)), __LINE__);
        }
        if (is_null($selectedClientId) || (is_array($selectedClientId) && empty($selectedClientId))) {
            unset($this->SelectedClientId);
        } else {
            $this->SelectedClientId = $selectedClientId;
        }
        return $this;
    }
}
