<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Crm.ClientLogin.Request StructType
 * @subpackage Structs
 */
class BizAction_Crm_ClientLogin_Request extends AnyEntity
{
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The EmailForReset
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EmailForReset;
    /**
     * The LoginExists
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $LoginExists;
    /**
     * The LoginName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LoginName;
    /**
     * The OrgUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrgUnitId;
    /**
     * The Password
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Password;
    /**
     * The Reset
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Reset;
    /**
     * Constructor method for BizAction.Crm.ClientLogin.Request
     * @uses BizAction_Crm_ClientLogin_Request::setClientId()
     * @uses BizAction_Crm_ClientLogin_Request::setEmailForReset()
     * @uses BizAction_Crm_ClientLogin_Request::setLoginExists()
     * @uses BizAction_Crm_ClientLogin_Request::setLoginName()
     * @uses BizAction_Crm_ClientLogin_Request::setOrgUnitId()
     * @uses BizAction_Crm_ClientLogin_Request::setPassword()
     * @uses BizAction_Crm_ClientLogin_Request::setReset()
     * @param string $clientId
     * @param string $emailForReset
     * @param bool $loginExists
     * @param string $loginName
     * @param string $orgUnitId
     * @param string $password
     * @param bool $reset
     */
    public function __construct($clientId = null, $emailForReset = null, $loginExists = null, $loginName = null, $orgUnitId = null, $password = null, $reset = null)
    {
        $this
            ->setClientId($clientId)
            ->setEmailForReset($emailForReset)
            ->setLoginExists($loginExists)
            ->setLoginName($loginName)
            ->setOrgUnitId($orgUnitId)
            ->setPassword($password)
            ->setReset($reset);
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\BizAction_Crm_ClientLogin_Request
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get EmailForReset value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmailForReset()
    {
        return isset($this->EmailForReset) ? $this->EmailForReset : null;
    }
    /**
     * Set EmailForReset value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $emailForReset
     * @return \patest\StructType\BizAction_Crm_ClientLogin_Request
     */
    public function setEmailForReset($emailForReset = null)
    {
        // validation for constraint: string
        if (!is_null($emailForReset) && !is_string($emailForReset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailForReset, true), gettype($emailForReset)), __LINE__);
        }
        if (is_null($emailForReset) || (is_array($emailForReset) && empty($emailForReset))) {
            unset($this->EmailForReset);
        } else {
            $this->EmailForReset = $emailForReset;
        }
        return $this;
    }
    /**
     * Get LoginExists value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getLoginExists()
    {
        return isset($this->LoginExists) ? $this->LoginExists : null;
    }
    /**
     * Set LoginExists value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $loginExists
     * @return \patest\StructType\BizAction_Crm_ClientLogin_Request
     */
    public function setLoginExists($loginExists = null)
    {
        // validation for constraint: boolean
        if (!is_null($loginExists) && !is_bool($loginExists)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($loginExists, true), gettype($loginExists)), __LINE__);
        }
        if (is_null($loginExists) || (is_array($loginExists) && empty($loginExists))) {
            unset($this->LoginExists);
        } else {
            $this->LoginExists = $loginExists;
        }
        return $this;
    }
    /**
     * Get LoginName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLoginName()
    {
        return isset($this->LoginName) ? $this->LoginName : null;
    }
    /**
     * Set LoginName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $loginName
     * @return \patest\StructType\BizAction_Crm_ClientLogin_Request
     */
    public function setLoginName($loginName = null)
    {
        // validation for constraint: string
        if (!is_null($loginName) && !is_string($loginName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loginName, true), gettype($loginName)), __LINE__);
        }
        if (is_null($loginName) || (is_array($loginName) && empty($loginName))) {
            unset($this->LoginName);
        } else {
            $this->LoginName = $loginName;
        }
        return $this;
    }
    /**
     * Get OrgUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrgUnitId()
    {
        return isset($this->OrgUnitId) ? $this->OrgUnitId : null;
    }
    /**
     * Set OrgUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orgUnitId
     * @return \patest\StructType\BizAction_Crm_ClientLogin_Request
     */
    public function setOrgUnitId($orgUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($orgUnitId) && !is_string($orgUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orgUnitId, true), gettype($orgUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($orgUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $orgUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($orgUnitId, true)), __LINE__);
        }
        if (is_null($orgUnitId) || (is_array($orgUnitId) && empty($orgUnitId))) {
            unset($this->OrgUnitId);
        } else {
            $this->OrgUnitId = $orgUnitId;
        }
        return $this;
    }
    /**
     * Get Password value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPassword()
    {
        return isset($this->Password) ? $this->Password : null;
    }
    /**
     * Set Password value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $password
     * @return \patest\StructType\BizAction_Crm_ClientLogin_Request
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        if (is_null($password) || (is_array($password) && empty($password))) {
            unset($this->Password);
        } else {
            $this->Password = $password;
        }
        return $this;
    }
    /**
     * Get Reset value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getReset()
    {
        return isset($this->Reset) ? $this->Reset : null;
    }
    /**
     * Set Reset value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $reset
     * @return \patest\StructType\BizAction_Crm_ClientLogin_Request
     */
    public function setReset($reset = null)
    {
        // validation for constraint: boolean
        if (!is_null($reset) && !is_bool($reset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($reset, true), gettype($reset)), __LINE__);
        }
        if (is_null($reset) || (is_array($reset) && empty($reset))) {
            unset($this->Reset);
        } else {
            $this->Reset = $reset;
        }
        return $this;
    }
}
