<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Crm.BulkServiceRepReassignment.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Crm_BulkServiceRepReassignment_Request extends BizAction_Foundation_BulkOperation_Request
{
    /**
     * The SalesRepType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SalesRepType;
    /**
     * Constructor method for BizAction.Crm.BulkServiceRepReassignment.Request
     * @uses BizAction_Crm_BulkServiceRepReassignment_Request::setSalesRepType()
     * @param string $salesRepType
     */
    public function __construct($salesRepType = null)
    {
        $this
            ->setSalesRepType($salesRepType);
    }
    /**
     * Get SalesRepType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSalesRepType()
    {
        return isset($this->SalesRepType) ? $this->SalesRepType : null;
    }
    /**
     * Set SalesRepType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SalesRepType::valueIsValid()
     * @uses \patest\EnumType\SalesRepType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $salesRepType
     * @return \patest\StructType\BizAction_Crm_BulkServiceRepReassignment_Request
     */
    public function setSalesRepType($salesRepType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SalesRepType::valueIsValid($salesRepType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SalesRepType', is_array($salesRepType) ? implode(', ', $salesRepType) : var_export($salesRepType, true), implode(', ', \patest\EnumType\SalesRepType::getValidValues())), __LINE__);
        }
        if (is_null($salesRepType) || (is_array($salesRepType) && empty($salesRepType))) {
            unset($this->SalesRepType);
        } else {
            $this->SalesRepType = $salesRepType;
        }
        return $this;
    }
}
