<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Crm.AnonymiseCustomersBulkOperation.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Crm_AnonymiseCustomersBulkOperation_Request extends BizAction_Foundation_BulkOperation_Request
{
    /**
     * The AnonymiseCustomersWithFutureEvents
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AnonymiseCustomersWithFutureEvents;
    /**
     * The AnonymizationNote
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AnonymizationNote;
    /**
     * The ClientIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ClientIds
     */
    public $ClientIds;
    /**
     * The CountCustomersWithFutureEvents
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CountCustomersWithFutureEvents;
    /**
     * The CountCustomersWithoutFutureEvents
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CountCustomersWithoutFutureEvents;
    /**
     * The CountUploadedRecords
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CountUploadedRecords;
    /**
     * Constructor method for BizAction.Crm.AnonymiseCustomersBulkOperation.Request
     * @uses BizAction_Crm_AnonymiseCustomersBulkOperation_Request::setAnonymiseCustomersWithFutureEvents()
     * @uses BizAction_Crm_AnonymiseCustomersBulkOperation_Request::setAnonymizationNote()
     * @uses BizAction_Crm_AnonymiseCustomersBulkOperation_Request::setClientIds()
     * @uses BizAction_Crm_AnonymiseCustomersBulkOperation_Request::setCountCustomersWithFutureEvents()
     * @uses BizAction_Crm_AnonymiseCustomersBulkOperation_Request::setCountCustomersWithoutFutureEvents()
     * @uses BizAction_Crm_AnonymiseCustomersBulkOperation_Request::setCountUploadedRecords()
     * @param bool $anonymiseCustomersWithFutureEvents
     * @param string $anonymizationNote
     * @param \patest\StructType\ClientIds $clientIds
     * @param int $countCustomersWithFutureEvents
     * @param int $countCustomersWithoutFutureEvents
     * @param int $countUploadedRecords
     */
    public function __construct($anonymiseCustomersWithFutureEvents = null, $anonymizationNote = null, \patest\StructType\ClientIds $clientIds = null, $countCustomersWithFutureEvents = null, $countCustomersWithoutFutureEvents = null, $countUploadedRecords = null)
    {
        $this
            ->setAnonymiseCustomersWithFutureEvents($anonymiseCustomersWithFutureEvents)
            ->setAnonymizationNote($anonymizationNote)
            ->setClientIds($clientIds)
            ->setCountCustomersWithFutureEvents($countCustomersWithFutureEvents)
            ->setCountCustomersWithoutFutureEvents($countCustomersWithoutFutureEvents)
            ->setCountUploadedRecords($countUploadedRecords);
    }
    /**
     * Get AnonymiseCustomersWithFutureEvents value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAnonymiseCustomersWithFutureEvents()
    {
        return isset($this->AnonymiseCustomersWithFutureEvents) ? $this->AnonymiseCustomersWithFutureEvents : null;
    }
    /**
     * Set AnonymiseCustomersWithFutureEvents value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $anonymiseCustomersWithFutureEvents
     * @return \patest\StructType\BizAction_Crm_AnonymiseCustomersBulkOperation_Request
     */
    public function setAnonymiseCustomersWithFutureEvents($anonymiseCustomersWithFutureEvents = null)
    {
        // validation for constraint: boolean
        if (!is_null($anonymiseCustomersWithFutureEvents) && !is_bool($anonymiseCustomersWithFutureEvents)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($anonymiseCustomersWithFutureEvents, true), gettype($anonymiseCustomersWithFutureEvents)), __LINE__);
        }
        if (is_null($anonymiseCustomersWithFutureEvents) || (is_array($anonymiseCustomersWithFutureEvents) && empty($anonymiseCustomersWithFutureEvents))) {
            unset($this->AnonymiseCustomersWithFutureEvents);
        } else {
            $this->AnonymiseCustomersWithFutureEvents = $anonymiseCustomersWithFutureEvents;
        }
        return $this;
    }
    /**
     * Get AnonymizationNote value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAnonymizationNote()
    {
        return isset($this->AnonymizationNote) ? $this->AnonymizationNote : null;
    }
    /**
     * Set AnonymizationNote value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $anonymizationNote
     * @return \patest\StructType\BizAction_Crm_AnonymiseCustomersBulkOperation_Request
     */
    public function setAnonymizationNote($anonymizationNote = null)
    {
        // validation for constraint: string
        if (!is_null($anonymizationNote) && !is_string($anonymizationNote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($anonymizationNote, true), gettype($anonymizationNote)), __LINE__);
        }
        if (is_null($anonymizationNote) || (is_array($anonymizationNote) && empty($anonymizationNote))) {
            unset($this->AnonymizationNote);
        } else {
            $this->AnonymizationNote = $anonymizationNote;
        }
        return $this;
    }
    /**
     * Get ClientIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ClientIds|null
     */
    public function getClientIds()
    {
        return isset($this->ClientIds) ? $this->ClientIds : null;
    }
    /**
     * Set ClientIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ClientIds $clientIds
     * @return \patest\StructType\BizAction_Crm_AnonymiseCustomersBulkOperation_Request
     */
    public function setClientIds(\patest\StructType\ClientIds $clientIds = null)
    {
        if (is_null($clientIds) || (is_array($clientIds) && empty($clientIds))) {
            unset($this->ClientIds);
        } else {
            $this->ClientIds = $clientIds;
        }
        return $this;
    }
    /**
     * Get CountCustomersWithFutureEvents value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCountCustomersWithFutureEvents()
    {
        return isset($this->CountCustomersWithFutureEvents) ? $this->CountCustomersWithFutureEvents : null;
    }
    /**
     * Set CountCustomersWithFutureEvents value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $countCustomersWithFutureEvents
     * @return \patest\StructType\BizAction_Crm_AnonymiseCustomersBulkOperation_Request
     */
    public function setCountCustomersWithFutureEvents($countCustomersWithFutureEvents = null)
    {
        // validation for constraint: int
        if (!is_null($countCustomersWithFutureEvents) && !(is_int($countCustomersWithFutureEvents) || ctype_digit($countCustomersWithFutureEvents))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($countCustomersWithFutureEvents, true), gettype($countCustomersWithFutureEvents)), __LINE__);
        }
        if (is_null($countCustomersWithFutureEvents) || (is_array($countCustomersWithFutureEvents) && empty($countCustomersWithFutureEvents))) {
            unset($this->CountCustomersWithFutureEvents);
        } else {
            $this->CountCustomersWithFutureEvents = $countCustomersWithFutureEvents;
        }
        return $this;
    }
    /**
     * Get CountCustomersWithoutFutureEvents value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCountCustomersWithoutFutureEvents()
    {
        return isset($this->CountCustomersWithoutFutureEvents) ? $this->CountCustomersWithoutFutureEvents : null;
    }
    /**
     * Set CountCustomersWithoutFutureEvents value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $countCustomersWithoutFutureEvents
     * @return \patest\StructType\BizAction_Crm_AnonymiseCustomersBulkOperation_Request
     */
    public function setCountCustomersWithoutFutureEvents($countCustomersWithoutFutureEvents = null)
    {
        // validation for constraint: int
        if (!is_null($countCustomersWithoutFutureEvents) && !(is_int($countCustomersWithoutFutureEvents) || ctype_digit($countCustomersWithoutFutureEvents))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($countCustomersWithoutFutureEvents, true), gettype($countCustomersWithoutFutureEvents)), __LINE__);
        }
        if (is_null($countCustomersWithoutFutureEvents) || (is_array($countCustomersWithoutFutureEvents) && empty($countCustomersWithoutFutureEvents))) {
            unset($this->CountCustomersWithoutFutureEvents);
        } else {
            $this->CountCustomersWithoutFutureEvents = $countCustomersWithoutFutureEvents;
        }
        return $this;
    }
    /**
     * Get CountUploadedRecords value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCountUploadedRecords()
    {
        return isset($this->CountUploadedRecords) ? $this->CountUploadedRecords : null;
    }
    /**
     * Set CountUploadedRecords value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $countUploadedRecords
     * @return \patest\StructType\BizAction_Crm_AnonymiseCustomersBulkOperation_Request
     */
    public function setCountUploadedRecords($countUploadedRecords = null)
    {
        // validation for constraint: int
        if (!is_null($countUploadedRecords) && !(is_int($countUploadedRecords) || ctype_digit($countUploadedRecords))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($countUploadedRecords, true), gettype($countUploadedRecords)), __LINE__);
        }
        if (is_null($countUploadedRecords) || (is_array($countUploadedRecords) && empty($countUploadedRecords))) {
            unset($this->CountUploadedRecords);
        } else {
            $this->CountUploadedRecords = $countUploadedRecords;
        }
        return $this;
    }
}
