<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.BizResource.UpdateVisitArrivals.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_BizResource_UpdateVisitArrivals_Request extends AnyEntity
{
    /**
     * The Arrived
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Arrived;
    /**
     * The OrderVisitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrderVisitId;
    /**
     * Constructor method for BizAction.BizResource.UpdateVisitArrivals.Request
     * @uses BizAction_BizResource_UpdateVisitArrivals_Request::setArrived()
     * @uses BizAction_BizResource_UpdateVisitArrivals_Request::setOrderVisitId()
     * @param int $arrived
     * @param string $orderVisitId
     */
    public function __construct($arrived = null, $orderVisitId = null)
    {
        $this
            ->setArrived($arrived)
            ->setOrderVisitId($orderVisitId);
    }
    /**
     * Get Arrived value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getArrived()
    {
        return isset($this->Arrived) ? $this->Arrived : null;
    }
    /**
     * Set Arrived value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $arrived
     * @return \patest\StructType\BizAction_BizResource_UpdateVisitArrivals_Request
     */
    public function setArrived($arrived = null)
    {
        // validation for constraint: int
        if (!is_null($arrived) && !(is_int($arrived) || ctype_digit($arrived))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($arrived, true), gettype($arrived)), __LINE__);
        }
        if (is_null($arrived) || (is_array($arrived) && empty($arrived))) {
            unset($this->Arrived);
        } else {
            $this->Arrived = $arrived;
        }
        return $this;
    }
    /**
     * Get OrderVisitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderVisitId()
    {
        return isset($this->OrderVisitId) ? $this->OrderVisitId : null;
    }
    /**
     * Set OrderVisitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orderVisitId
     * @return \patest\StructType\BizAction_BizResource_UpdateVisitArrivals_Request
     */
    public function setOrderVisitId($orderVisitId = null)
    {
        // validation for constraint: string
        if (!is_null($orderVisitId) && !is_string($orderVisitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderVisitId, true), gettype($orderVisitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($orderVisitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $orderVisitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($orderVisitId, true)), __LINE__);
        }
        if (is_null($orderVisitId) || (is_array($orderVisitId) && empty($orderVisitId))) {
            unset($this->OrderVisitId);
        } else {
            $this->OrderVisitId = $orderVisitId;
        }
        return $this;
    }
}
