<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.BizResource.SendDocuments.Request StructType
 * @subpackage Structs
 */
class BizAction_BizResource_SendDocuments_Request extends AnyEntity
{
    /**
     * The Documents
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfBizAction_BizResource_SendDocuments_DocumentItem
     */
    public $Documents;
    /**
     * The DocumentsExpiryDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DocumentsExpiryDate;
    /**
     * The EmailBody
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EmailBody;
    /**
     * The EmailSubject
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EmailSubject;
    /**
     * The FileData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FileData;
    /**
     * The FileName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FileName;
    /**
     * The IsSendByEmail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSendByEmail;
    /**
     * The IsUpdateProposal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsUpdateProposal;
    /**
     * The OrderId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OrderId;
    /**
     * The OrderVisitId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OrderVisitId;
    /**
     * The PlaceHolders
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfBizAction_BizResource_SendDocuments_PlaceHolder
     */
    public $PlaceHolders;
    /**
     * The ProposalExpiryDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProposalExpiryDate;
    /**
     * The RecalculateVisitPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $RecalculateVisitPrice;
    /**
     * The Recipients
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfBizAction_BizResource_SendDocuments_Recipient
     */
    public $Recipients;
    /**
     * The TargetPrinterId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TargetPrinterId;
    /**
     * Constructor method for BizAction.BizResource.SendDocuments.Request
     * @uses BizAction_BizResource_SendDocuments_Request::setDocuments()
     * @uses BizAction_BizResource_SendDocuments_Request::setDocumentsExpiryDate()
     * @uses BizAction_BizResource_SendDocuments_Request::setEmailBody()
     * @uses BizAction_BizResource_SendDocuments_Request::setEmailSubject()
     * @uses BizAction_BizResource_SendDocuments_Request::setFileData()
     * @uses BizAction_BizResource_SendDocuments_Request::setFileName()
     * @uses BizAction_BizResource_SendDocuments_Request::setIsSendByEmail()
     * @uses BizAction_BizResource_SendDocuments_Request::setIsUpdateProposal()
     * @uses BizAction_BizResource_SendDocuments_Request::setOrderId()
     * @uses BizAction_BizResource_SendDocuments_Request::setOrderVisitId()
     * @uses BizAction_BizResource_SendDocuments_Request::setPlaceHolders()
     * @uses BizAction_BizResource_SendDocuments_Request::setProposalExpiryDate()
     * @uses BizAction_BizResource_SendDocuments_Request::setRecalculateVisitPrice()
     * @uses BizAction_BizResource_SendDocuments_Request::setRecipients()
     * @uses BizAction_BizResource_SendDocuments_Request::setTargetPrinterId()
     * @param \patest\StructType\RecordSetOfBizAction_BizResource_SendDocuments_DocumentItem $documents
     * @param string $documentsExpiryDate
     * @param string $emailBody
     * @param string $emailSubject
     * @param string $fileData
     * @param string $fileName
     * @param bool $isSendByEmail
     * @param bool $isUpdateProposal
     * @param string $orderId
     * @param string $orderVisitId
     * @param \patest\StructType\RecordSetOfBizAction_BizResource_SendDocuments_PlaceHolder $placeHolders
     * @param string $proposalExpiryDate
     * @param bool $recalculateVisitPrice
     * @param \patest\StructType\RecordSetOfBizAction_BizResource_SendDocuments_Recipient $recipients
     * @param string $targetPrinterId
     */
    public function __construct(\patest\StructType\RecordSetOfBizAction_BizResource_SendDocuments_DocumentItem $documents = null, $documentsExpiryDate = null, $emailBody = null, $emailSubject = null, $fileData = null, $fileName = null, $isSendByEmail = null, $isUpdateProposal = null, $orderId = null, $orderVisitId = null, \patest\StructType\RecordSetOfBizAction_BizResource_SendDocuments_PlaceHolder $placeHolders = null, $proposalExpiryDate = null, $recalculateVisitPrice = null, \patest\StructType\RecordSetOfBizAction_BizResource_SendDocuments_Recipient $recipients = null, $targetPrinterId = null)
    {
        $this
            ->setDocuments($documents)
            ->setDocumentsExpiryDate($documentsExpiryDate)
            ->setEmailBody($emailBody)
            ->setEmailSubject($emailSubject)
            ->setFileData($fileData)
            ->setFileName($fileName)
            ->setIsSendByEmail($isSendByEmail)
            ->setIsUpdateProposal($isUpdateProposal)
            ->setOrderId($orderId)
            ->setOrderVisitId($orderVisitId)
            ->setPlaceHolders($placeHolders)
            ->setProposalExpiryDate($proposalExpiryDate)
            ->setRecalculateVisitPrice($recalculateVisitPrice)
            ->setRecipients($recipients)
            ->setTargetPrinterId($targetPrinterId);
    }
    /**
     * Get Documents value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfBizAction_BizResource_SendDocuments_DocumentItem|null
     */
    public function getDocuments()
    {
        return isset($this->Documents) ? $this->Documents : null;
    }
    /**
     * Set Documents value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfBizAction_BizResource_SendDocuments_DocumentItem $documents
     * @return \patest\StructType\BizAction_BizResource_SendDocuments_Request
     */
    public function setDocuments(\patest\StructType\RecordSetOfBizAction_BizResource_SendDocuments_DocumentItem $documents = null)
    {
        if (is_null($documents) || (is_array($documents) && empty($documents))) {
            unset($this->Documents);
        } else {
            $this->Documents = $documents;
        }
        return $this;
    }
    /**
     * Get DocumentsExpiryDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDocumentsExpiryDate()
    {
        return isset($this->DocumentsExpiryDate) ? $this->DocumentsExpiryDate : null;
    }
    /**
     * Set DocumentsExpiryDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $documentsExpiryDate
     * @return \patest\StructType\BizAction_BizResource_SendDocuments_Request
     */
    public function setDocumentsExpiryDate($documentsExpiryDate = null)
    {
        // validation for constraint: string
        if (!is_null($documentsExpiryDate) && !is_string($documentsExpiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentsExpiryDate, true), gettype($documentsExpiryDate)), __LINE__);
        }
        if (is_null($documentsExpiryDate) || (is_array($documentsExpiryDate) && empty($documentsExpiryDate))) {
            unset($this->DocumentsExpiryDate);
        } else {
            $this->DocumentsExpiryDate = $documentsExpiryDate;
        }
        return $this;
    }
    /**
     * Get EmailBody value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmailBody()
    {
        return isset($this->EmailBody) ? $this->EmailBody : null;
    }
    /**
     * Set EmailBody value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $emailBody
     * @return \patest\StructType\BizAction_BizResource_SendDocuments_Request
     */
    public function setEmailBody($emailBody = null)
    {
        // validation for constraint: string
        if (!is_null($emailBody) && !is_string($emailBody)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailBody, true), gettype($emailBody)), __LINE__);
        }
        if (is_null($emailBody) || (is_array($emailBody) && empty($emailBody))) {
            unset($this->EmailBody);
        } else {
            $this->EmailBody = $emailBody;
        }
        return $this;
    }
    /**
     * Get EmailSubject value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmailSubject()
    {
        return isset($this->EmailSubject) ? $this->EmailSubject : null;
    }
    /**
     * Set EmailSubject value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $emailSubject
     * @return \patest\StructType\BizAction_BizResource_SendDocuments_Request
     */
    public function setEmailSubject($emailSubject = null)
    {
        // validation for constraint: string
        if (!is_null($emailSubject) && !is_string($emailSubject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailSubject, true), gettype($emailSubject)), __LINE__);
        }
        if (is_null($emailSubject) || (is_array($emailSubject) && empty($emailSubject))) {
            unset($this->EmailSubject);
        } else {
            $this->EmailSubject = $emailSubject;
        }
        return $this;
    }
    /**
     * Get FileData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFileData()
    {
        return isset($this->FileData) ? $this->FileData : null;
    }
    /**
     * Set FileData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fileData
     * @return \patest\StructType\BizAction_BizResource_SendDocuments_Request
     */
    public function setFileData($fileData = null)
    {
        // validation for constraint: string
        if (!is_null($fileData) && !is_string($fileData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileData, true), gettype($fileData)), __LINE__);
        }
        if (is_null($fileData) || (is_array($fileData) && empty($fileData))) {
            unset($this->FileData);
        } else {
            $this->FileData = $fileData;
        }
        return $this;
    }
    /**
     * Get FileName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFileName()
    {
        return isset($this->FileName) ? $this->FileName : null;
    }
    /**
     * Set FileName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fileName
     * @return \patest\StructType\BizAction_BizResource_SendDocuments_Request
     */
    public function setFileName($fileName = null)
    {
        // validation for constraint: string
        if (!is_null($fileName) && !is_string($fileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileName, true), gettype($fileName)), __LINE__);
        }
        if (is_null($fileName) || (is_array($fileName) && empty($fileName))) {
            unset($this->FileName);
        } else {
            $this->FileName = $fileName;
        }
        return $this;
    }
    /**
     * Get IsSendByEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSendByEmail()
    {
        return isset($this->IsSendByEmail) ? $this->IsSendByEmail : null;
    }
    /**
     * Set IsSendByEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSendByEmail
     * @return \patest\StructType\BizAction_BizResource_SendDocuments_Request
     */
    public function setIsSendByEmail($isSendByEmail = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSendByEmail) && !is_bool($isSendByEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSendByEmail, true), gettype($isSendByEmail)), __LINE__);
        }
        if (is_null($isSendByEmail) || (is_array($isSendByEmail) && empty($isSendByEmail))) {
            unset($this->IsSendByEmail);
        } else {
            $this->IsSendByEmail = $isSendByEmail;
        }
        return $this;
    }
    /**
     * Get IsUpdateProposal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsUpdateProposal()
    {
        return isset($this->IsUpdateProposal) ? $this->IsUpdateProposal : null;
    }
    /**
     * Set IsUpdateProposal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isUpdateProposal
     * @return \patest\StructType\BizAction_BizResource_SendDocuments_Request
     */
    public function setIsUpdateProposal($isUpdateProposal = null)
    {
        // validation for constraint: boolean
        if (!is_null($isUpdateProposal) && !is_bool($isUpdateProposal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isUpdateProposal, true), gettype($isUpdateProposal)), __LINE__);
        }
        if (is_null($isUpdateProposal) || (is_array($isUpdateProposal) && empty($isUpdateProposal))) {
            unset($this->IsUpdateProposal);
        } else {
            $this->IsUpdateProposal = $isUpdateProposal;
        }
        return $this;
    }
    /**
     * Get OrderId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderId()
    {
        return isset($this->OrderId) ? $this->OrderId : null;
    }
    /**
     * Set OrderId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orderId
     * @return \patest\StructType\BizAction_BizResource_SendDocuments_Request
     */
    public function setOrderId($orderId = null)
    {
        // validation for constraint: string
        if (!is_null($orderId) && !is_string($orderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderId, true), gettype($orderId)), __LINE__);
        }
        if (is_null($orderId) || (is_array($orderId) && empty($orderId))) {
            unset($this->OrderId);
        } else {
            $this->OrderId = $orderId;
        }
        return $this;
    }
    /**
     * Get OrderVisitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderVisitId()
    {
        return isset($this->OrderVisitId) ? $this->OrderVisitId : null;
    }
    /**
     * Set OrderVisitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orderVisitId
     * @return \patest\StructType\BizAction_BizResource_SendDocuments_Request
     */
    public function setOrderVisitId($orderVisitId = null)
    {
        // validation for constraint: string
        if (!is_null($orderVisitId) && !is_string($orderVisitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderVisitId, true), gettype($orderVisitId)), __LINE__);
        }
        if (is_null($orderVisitId) || (is_array($orderVisitId) && empty($orderVisitId))) {
            unset($this->OrderVisitId);
        } else {
            $this->OrderVisitId = $orderVisitId;
        }
        return $this;
    }
    /**
     * Get PlaceHolders value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfBizAction_BizResource_SendDocuments_PlaceHolder|null
     */
    public function getPlaceHolders()
    {
        return isset($this->PlaceHolders) ? $this->PlaceHolders : null;
    }
    /**
     * Set PlaceHolders value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfBizAction_BizResource_SendDocuments_PlaceHolder $placeHolders
     * @return \patest\StructType\BizAction_BizResource_SendDocuments_Request
     */
    public function setPlaceHolders(\patest\StructType\RecordSetOfBizAction_BizResource_SendDocuments_PlaceHolder $placeHolders = null)
    {
        if (is_null($placeHolders) || (is_array($placeHolders) && empty($placeHolders))) {
            unset($this->PlaceHolders);
        } else {
            $this->PlaceHolders = $placeHolders;
        }
        return $this;
    }
    /**
     * Get ProposalExpiryDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProposalExpiryDate()
    {
        return isset($this->ProposalExpiryDate) ? $this->ProposalExpiryDate : null;
    }
    /**
     * Set ProposalExpiryDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $proposalExpiryDate
     * @return \patest\StructType\BizAction_BizResource_SendDocuments_Request
     */
    public function setProposalExpiryDate($proposalExpiryDate = null)
    {
        // validation for constraint: string
        if (!is_null($proposalExpiryDate) && !is_string($proposalExpiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($proposalExpiryDate, true), gettype($proposalExpiryDate)), __LINE__);
        }
        if (is_null($proposalExpiryDate) || (is_array($proposalExpiryDate) && empty($proposalExpiryDate))) {
            unset($this->ProposalExpiryDate);
        } else {
            $this->ProposalExpiryDate = $proposalExpiryDate;
        }
        return $this;
    }
    /**
     * Get RecalculateVisitPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getRecalculateVisitPrice()
    {
        return isset($this->RecalculateVisitPrice) ? $this->RecalculateVisitPrice : null;
    }
    /**
     * Set RecalculateVisitPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $recalculateVisitPrice
     * @return \patest\StructType\BizAction_BizResource_SendDocuments_Request
     */
    public function setRecalculateVisitPrice($recalculateVisitPrice = null)
    {
        // validation for constraint: boolean
        if (!is_null($recalculateVisitPrice) && !is_bool($recalculateVisitPrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($recalculateVisitPrice, true), gettype($recalculateVisitPrice)), __LINE__);
        }
        if (is_null($recalculateVisitPrice) || (is_array($recalculateVisitPrice) && empty($recalculateVisitPrice))) {
            unset($this->RecalculateVisitPrice);
        } else {
            $this->RecalculateVisitPrice = $recalculateVisitPrice;
        }
        return $this;
    }
    /**
     * Get Recipients value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfBizAction_BizResource_SendDocuments_Recipient|null
     */
    public function getRecipients()
    {
        return isset($this->Recipients) ? $this->Recipients : null;
    }
    /**
     * Set Recipients value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfBizAction_BizResource_SendDocuments_Recipient $recipients
     * @return \patest\StructType\BizAction_BizResource_SendDocuments_Request
     */
    public function setRecipients(\patest\StructType\RecordSetOfBizAction_BizResource_SendDocuments_Recipient $recipients = null)
    {
        if (is_null($recipients) || (is_array($recipients) && empty($recipients))) {
            unset($this->Recipients);
        } else {
            $this->Recipients = $recipients;
        }
        return $this;
    }
    /**
     * Get TargetPrinterId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetPrinterId()
    {
        return isset($this->TargetPrinterId) ? $this->TargetPrinterId : null;
    }
    /**
     * Set TargetPrinterId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetPrinterId
     * @return \patest\StructType\BizAction_BizResource_SendDocuments_Request
     */
    public function setTargetPrinterId($targetPrinterId = null)
    {
        // validation for constraint: string
        if (!is_null($targetPrinterId) && !is_string($targetPrinterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetPrinterId, true), gettype($targetPrinterId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($targetPrinterId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $targetPrinterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($targetPrinterId, true)), __LINE__);
        }
        if (is_null($targetPrinterId) || (is_array($targetPrinterId) && empty($targetPrinterId))) {
            unset($this->TargetPrinterId);
        } else {
            $this->TargetPrinterId = $targetPrinterId;
        }
        return $this;
    }
}
