<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.BizResource.CreateOrder.Request StructType
 * @subpackage Structs
 */
class BizAction_BizResource_CreateOrder_Request extends AnyEntity
{
    /**
     * The Classes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Classes;
    /**
     * The GradeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GradeId;
    /**
     * The GroupName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GroupName;
    /**
     * The GroupVisitPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfBizAction_BizResource_CreateOrder_GroupCombination
     */
    public $GroupVisitPrice;
    /**
     * The MinStartTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MinStartTime;
    /**
     * The OrderComment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OrderComment;
    /**
     * The OrderContactEmail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OrderContactEmail;
    /**
     * The OrderContactFax
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OrderContactFax;
    /**
     * The OrderContactHomePhone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OrderContactHomePhone;
    /**
     * The OrderContactId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrderContactId;
    /**
     * The OrderContactMobile
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OrderContactMobile;
    /**
     * The OrderOrganizerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrderOrganizerId;
    /**
     * The OrderType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OrderType;
    /**
     * The PersonVisitPrices
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfBizAction_BizResource_CreateOrder_GroupCombination
     */
    public $PersonVisitPrices;
    /**
     * The PreferredEndDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PreferredEndDate;
    /**
     * The PreferredStartDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PreferredStartDate;
    /**
     * The PricingPerType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PricingPerType;
    /**
     * The VisitComment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VisitComment;
    /**
     * The VisitContactEmail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VisitContactEmail;
    /**
     * The VisitContactFax
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VisitContactFax;
    /**
     * The VisitContactHomePhone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VisitContactHomePhone;
    /**
     * The VisitContactId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $VisitContactId;
    /**
     * The VisitContactMobile
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VisitContactMobile;
    /**
     * The VisitNatureId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $VisitNatureId;
    /**
     * The VisitPayerAccountId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $VisitPayerAccountId;
    /**
     * The VisitPlanId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $VisitPlanId;
    /**
     * The VisitSkills
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\VisitSkills
     */
    public $VisitSkills;
    /**
     * The VisitTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $VisitTypeId;
    /**
     * Constructor method for BizAction.BizResource.CreateOrder.Request
     * @uses BizAction_BizResource_CreateOrder_Request::setClasses()
     * @uses BizAction_BizResource_CreateOrder_Request::setGradeId()
     * @uses BizAction_BizResource_CreateOrder_Request::setGroupName()
     * @uses BizAction_BizResource_CreateOrder_Request::setGroupVisitPrice()
     * @uses BizAction_BizResource_CreateOrder_Request::setMinStartTime()
     * @uses BizAction_BizResource_CreateOrder_Request::setOrderComment()
     * @uses BizAction_BizResource_CreateOrder_Request::setOrderContactEmail()
     * @uses BizAction_BizResource_CreateOrder_Request::setOrderContactFax()
     * @uses BizAction_BizResource_CreateOrder_Request::setOrderContactHomePhone()
     * @uses BizAction_BizResource_CreateOrder_Request::setOrderContactId()
     * @uses BizAction_BizResource_CreateOrder_Request::setOrderContactMobile()
     * @uses BizAction_BizResource_CreateOrder_Request::setOrderOrganizerId()
     * @uses BizAction_BizResource_CreateOrder_Request::setOrderType()
     * @uses BizAction_BizResource_CreateOrder_Request::setPersonVisitPrices()
     * @uses BizAction_BizResource_CreateOrder_Request::setPreferredEndDate()
     * @uses BizAction_BizResource_CreateOrder_Request::setPreferredStartDate()
     * @uses BizAction_BizResource_CreateOrder_Request::setPricingPerType()
     * @uses BizAction_BizResource_CreateOrder_Request::setVisitComment()
     * @uses BizAction_BizResource_CreateOrder_Request::setVisitContactEmail()
     * @uses BizAction_BizResource_CreateOrder_Request::setVisitContactFax()
     * @uses BizAction_BizResource_CreateOrder_Request::setVisitContactHomePhone()
     * @uses BizAction_BizResource_CreateOrder_Request::setVisitContactId()
     * @uses BizAction_BizResource_CreateOrder_Request::setVisitContactMobile()
     * @uses BizAction_BizResource_CreateOrder_Request::setVisitNatureId()
     * @uses BizAction_BizResource_CreateOrder_Request::setVisitPayerAccountId()
     * @uses BizAction_BizResource_CreateOrder_Request::setVisitPlanId()
     * @uses BizAction_BizResource_CreateOrder_Request::setVisitSkills()
     * @uses BizAction_BizResource_CreateOrder_Request::setVisitTypeId()
     * @param string $classes
     * @param string $gradeId
     * @param string $groupName
     * @param \patest\StructType\RecordSetOfBizAction_BizResource_CreateOrder_GroupCombination $groupVisitPrice
     * @param string $minStartTime
     * @param string $orderComment
     * @param string $orderContactEmail
     * @param string $orderContactFax
     * @param string $orderContactHomePhone
     * @param string $orderContactId
     * @param string $orderContactMobile
     * @param string $orderOrganizerId
     * @param string $orderType
     * @param \patest\StructType\RecordSetOfBizAction_BizResource_CreateOrder_GroupCombination $personVisitPrices
     * @param string $preferredEndDate
     * @param string $preferredStartDate
     * @param string $pricingPerType
     * @param string $visitComment
     * @param string $visitContactEmail
     * @param string $visitContactFax
     * @param string $visitContactHomePhone
     * @param string $visitContactId
     * @param string $visitContactMobile
     * @param string $visitNatureId
     * @param string $visitPayerAccountId
     * @param string $visitPlanId
     * @param \patest\StructType\VisitSkills $visitSkills
     * @param string $visitTypeId
     */
    public function __construct($classes = null, $gradeId = null, $groupName = null, \patest\StructType\RecordSetOfBizAction_BizResource_CreateOrder_GroupCombination $groupVisitPrice = null, $minStartTime = null, $orderComment = null, $orderContactEmail = null, $orderContactFax = null, $orderContactHomePhone = null, $orderContactId = null, $orderContactMobile = null, $orderOrganizerId = null, $orderType = null, \patest\StructType\RecordSetOfBizAction_BizResource_CreateOrder_GroupCombination $personVisitPrices = null, $preferredEndDate = null, $preferredStartDate = null, $pricingPerType = null, $visitComment = null, $visitContactEmail = null, $visitContactFax = null, $visitContactHomePhone = null, $visitContactId = null, $visitContactMobile = null, $visitNatureId = null, $visitPayerAccountId = null, $visitPlanId = null, \patest\StructType\VisitSkills $visitSkills = null, $visitTypeId = null)
    {
        $this
            ->setClasses($classes)
            ->setGradeId($gradeId)
            ->setGroupName($groupName)
            ->setGroupVisitPrice($groupVisitPrice)
            ->setMinStartTime($minStartTime)
            ->setOrderComment($orderComment)
            ->setOrderContactEmail($orderContactEmail)
            ->setOrderContactFax($orderContactFax)
            ->setOrderContactHomePhone($orderContactHomePhone)
            ->setOrderContactId($orderContactId)
            ->setOrderContactMobile($orderContactMobile)
            ->setOrderOrganizerId($orderOrganizerId)
            ->setOrderType($orderType)
            ->setPersonVisitPrices($personVisitPrices)
            ->setPreferredEndDate($preferredEndDate)
            ->setPreferredStartDate($preferredStartDate)
            ->setPricingPerType($pricingPerType)
            ->setVisitComment($visitComment)
            ->setVisitContactEmail($visitContactEmail)
            ->setVisitContactFax($visitContactFax)
            ->setVisitContactHomePhone($visitContactHomePhone)
            ->setVisitContactId($visitContactId)
            ->setVisitContactMobile($visitContactMobile)
            ->setVisitNatureId($visitNatureId)
            ->setVisitPayerAccountId($visitPayerAccountId)
            ->setVisitPlanId($visitPlanId)
            ->setVisitSkills($visitSkills)
            ->setVisitTypeId($visitTypeId);
    }
    /**
     * Get Classes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClasses()
    {
        return isset($this->Classes) ? $this->Classes : null;
    }
    /**
     * Set Classes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $classes
     * @return \patest\StructType\BizAction_BizResource_CreateOrder_Request
     */
    public function setClasses($classes = null)
    {
        // validation for constraint: string
        if (!is_null($classes) && !is_string($classes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($classes, true), gettype($classes)), __LINE__);
        }
        if (is_null($classes) || (is_array($classes) && empty($classes))) {
            unset($this->Classes);
        } else {
            $this->Classes = $classes;
        }
        return $this;
    }
    /**
     * Get GradeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGradeId()
    {
        return isset($this->GradeId) ? $this->GradeId : null;
    }
    /**
     * Set GradeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gradeId
     * @return \patest\StructType\BizAction_BizResource_CreateOrder_Request
     */
    public function setGradeId($gradeId = null)
    {
        // validation for constraint: string
        if (!is_null($gradeId) && !is_string($gradeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gradeId, true), gettype($gradeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($gradeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $gradeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($gradeId, true)), __LINE__);
        }
        if (is_null($gradeId) || (is_array($gradeId) && empty($gradeId))) {
            unset($this->GradeId);
        } else {
            $this->GradeId = $gradeId;
        }
        return $this;
    }
    /**
     * Get GroupName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGroupName()
    {
        return isset($this->GroupName) ? $this->GroupName : null;
    }
    /**
     * Set GroupName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $groupName
     * @return \patest\StructType\BizAction_BizResource_CreateOrder_Request
     */
    public function setGroupName($groupName = null)
    {
        // validation for constraint: string
        if (!is_null($groupName) && !is_string($groupName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupName, true), gettype($groupName)), __LINE__);
        }
        if (is_null($groupName) || (is_array($groupName) && empty($groupName))) {
            unset($this->GroupName);
        } else {
            $this->GroupName = $groupName;
        }
        return $this;
    }
    /**
     * Get GroupVisitPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfBizAction_BizResource_CreateOrder_GroupCombination|null
     */
    public function getGroupVisitPrice()
    {
        return isset($this->GroupVisitPrice) ? $this->GroupVisitPrice : null;
    }
    /**
     * Set GroupVisitPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfBizAction_BizResource_CreateOrder_GroupCombination $groupVisitPrice
     * @return \patest\StructType\BizAction_BizResource_CreateOrder_Request
     */
    public function setGroupVisitPrice(\patest\StructType\RecordSetOfBizAction_BizResource_CreateOrder_GroupCombination $groupVisitPrice = null)
    {
        if (is_null($groupVisitPrice) || (is_array($groupVisitPrice) && empty($groupVisitPrice))) {
            unset($this->GroupVisitPrice);
        } else {
            $this->GroupVisitPrice = $groupVisitPrice;
        }
        return $this;
    }
    /**
     * Get MinStartTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMinStartTime()
    {
        return isset($this->MinStartTime) ? $this->MinStartTime : null;
    }
    /**
     * Set MinStartTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $minStartTime
     * @return \patest\StructType\BizAction_BizResource_CreateOrder_Request
     */
    public function setMinStartTime($minStartTime = null)
    {
        // validation for constraint: string
        if (!is_null($minStartTime) && !is_string($minStartTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($minStartTime, true), gettype($minStartTime)), __LINE__);
        }
        if (is_null($minStartTime) || (is_array($minStartTime) && empty($minStartTime))) {
            unset($this->MinStartTime);
        } else {
            $this->MinStartTime = $minStartTime;
        }
        return $this;
    }
    /**
     * Get OrderComment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderComment()
    {
        return isset($this->OrderComment) ? $this->OrderComment : null;
    }
    /**
     * Set OrderComment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orderComment
     * @return \patest\StructType\BizAction_BizResource_CreateOrder_Request
     */
    public function setOrderComment($orderComment = null)
    {
        // validation for constraint: string
        if (!is_null($orderComment) && !is_string($orderComment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderComment, true), gettype($orderComment)), __LINE__);
        }
        if (is_null($orderComment) || (is_array($orderComment) && empty($orderComment))) {
            unset($this->OrderComment);
        } else {
            $this->OrderComment = $orderComment;
        }
        return $this;
    }
    /**
     * Get OrderContactEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderContactEmail()
    {
        return isset($this->OrderContactEmail) ? $this->OrderContactEmail : null;
    }
    /**
     * Set OrderContactEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orderContactEmail
     * @return \patest\StructType\BizAction_BizResource_CreateOrder_Request
     */
    public function setOrderContactEmail($orderContactEmail = null)
    {
        // validation for constraint: string
        if (!is_null($orderContactEmail) && !is_string($orderContactEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderContactEmail, true), gettype($orderContactEmail)), __LINE__);
        }
        if (is_null($orderContactEmail) || (is_array($orderContactEmail) && empty($orderContactEmail))) {
            unset($this->OrderContactEmail);
        } else {
            $this->OrderContactEmail = $orderContactEmail;
        }
        return $this;
    }
    /**
     * Get OrderContactFax value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderContactFax()
    {
        return isset($this->OrderContactFax) ? $this->OrderContactFax : null;
    }
    /**
     * Set OrderContactFax value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orderContactFax
     * @return \patest\StructType\BizAction_BizResource_CreateOrder_Request
     */
    public function setOrderContactFax($orderContactFax = null)
    {
        // validation for constraint: string
        if (!is_null($orderContactFax) && !is_string($orderContactFax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderContactFax, true), gettype($orderContactFax)), __LINE__);
        }
        if (is_null($orderContactFax) || (is_array($orderContactFax) && empty($orderContactFax))) {
            unset($this->OrderContactFax);
        } else {
            $this->OrderContactFax = $orderContactFax;
        }
        return $this;
    }
    /**
     * Get OrderContactHomePhone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderContactHomePhone()
    {
        return isset($this->OrderContactHomePhone) ? $this->OrderContactHomePhone : null;
    }
    /**
     * Set OrderContactHomePhone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orderContactHomePhone
     * @return \patest\StructType\BizAction_BizResource_CreateOrder_Request
     */
    public function setOrderContactHomePhone($orderContactHomePhone = null)
    {
        // validation for constraint: string
        if (!is_null($orderContactHomePhone) && !is_string($orderContactHomePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderContactHomePhone, true), gettype($orderContactHomePhone)), __LINE__);
        }
        if (is_null($orderContactHomePhone) || (is_array($orderContactHomePhone) && empty($orderContactHomePhone))) {
            unset($this->OrderContactHomePhone);
        } else {
            $this->OrderContactHomePhone = $orderContactHomePhone;
        }
        return $this;
    }
    /**
     * Get OrderContactId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderContactId()
    {
        return isset($this->OrderContactId) ? $this->OrderContactId : null;
    }
    /**
     * Set OrderContactId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orderContactId
     * @return \patest\StructType\BizAction_BizResource_CreateOrder_Request
     */
    public function setOrderContactId($orderContactId = null)
    {
        // validation for constraint: string
        if (!is_null($orderContactId) && !is_string($orderContactId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderContactId, true), gettype($orderContactId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($orderContactId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $orderContactId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($orderContactId, true)), __LINE__);
        }
        if (is_null($orderContactId) || (is_array($orderContactId) && empty($orderContactId))) {
            unset($this->OrderContactId);
        } else {
            $this->OrderContactId = $orderContactId;
        }
        return $this;
    }
    /**
     * Get OrderContactMobile value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderContactMobile()
    {
        return isset($this->OrderContactMobile) ? $this->OrderContactMobile : null;
    }
    /**
     * Set OrderContactMobile value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orderContactMobile
     * @return \patest\StructType\BizAction_BizResource_CreateOrder_Request
     */
    public function setOrderContactMobile($orderContactMobile = null)
    {
        // validation for constraint: string
        if (!is_null($orderContactMobile) && !is_string($orderContactMobile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderContactMobile, true), gettype($orderContactMobile)), __LINE__);
        }
        if (is_null($orderContactMobile) || (is_array($orderContactMobile) && empty($orderContactMobile))) {
            unset($this->OrderContactMobile);
        } else {
            $this->OrderContactMobile = $orderContactMobile;
        }
        return $this;
    }
    /**
     * Get OrderOrganizerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderOrganizerId()
    {
        return isset($this->OrderOrganizerId) ? $this->OrderOrganizerId : null;
    }
    /**
     * Set OrderOrganizerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orderOrganizerId
     * @return \patest\StructType\BizAction_BizResource_CreateOrder_Request
     */
    public function setOrderOrganizerId($orderOrganizerId = null)
    {
        // validation for constraint: string
        if (!is_null($orderOrganizerId) && !is_string($orderOrganizerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderOrganizerId, true), gettype($orderOrganizerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($orderOrganizerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $orderOrganizerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($orderOrganizerId, true)), __LINE__);
        }
        if (is_null($orderOrganizerId) || (is_array($orderOrganizerId) && empty($orderOrganizerId))) {
            unset($this->OrderOrganizerId);
        } else {
            $this->OrderOrganizerId = $orderOrganizerId;
        }
        return $this;
    }
    /**
     * Get OrderType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderType()
    {
        return isset($this->OrderType) ? $this->OrderType : null;
    }
    /**
     * Set OrderType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\OrderType::valueIsValid()
     * @uses \patest\EnumType\OrderType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $orderType
     * @return \patest\StructType\BizAction_BizResource_CreateOrder_Request
     */
    public function setOrderType($orderType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\OrderType::valueIsValid($orderType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\OrderType', is_array($orderType) ? implode(', ', $orderType) : var_export($orderType, true), implode(', ', \patest\EnumType\OrderType::getValidValues())), __LINE__);
        }
        if (is_null($orderType) || (is_array($orderType) && empty($orderType))) {
            unset($this->OrderType);
        } else {
            $this->OrderType = $orderType;
        }
        return $this;
    }
    /**
     * Get PersonVisitPrices value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfBizAction_BizResource_CreateOrder_GroupCombination|null
     */
    public function getPersonVisitPrices()
    {
        return isset($this->PersonVisitPrices) ? $this->PersonVisitPrices : null;
    }
    /**
     * Set PersonVisitPrices value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfBizAction_BizResource_CreateOrder_GroupCombination $personVisitPrices
     * @return \patest\StructType\BizAction_BizResource_CreateOrder_Request
     */
    public function setPersonVisitPrices(\patest\StructType\RecordSetOfBizAction_BizResource_CreateOrder_GroupCombination $personVisitPrices = null)
    {
        if (is_null($personVisitPrices) || (is_array($personVisitPrices) && empty($personVisitPrices))) {
            unset($this->PersonVisitPrices);
        } else {
            $this->PersonVisitPrices = $personVisitPrices;
        }
        return $this;
    }
    /**
     * Get PreferredEndDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPreferredEndDate()
    {
        return isset($this->PreferredEndDate) ? $this->PreferredEndDate : null;
    }
    /**
     * Set PreferredEndDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $preferredEndDate
     * @return \patest\StructType\BizAction_BizResource_CreateOrder_Request
     */
    public function setPreferredEndDate($preferredEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($preferredEndDate) && !is_string($preferredEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($preferredEndDate, true), gettype($preferredEndDate)), __LINE__);
        }
        if (is_null($preferredEndDate) || (is_array($preferredEndDate) && empty($preferredEndDate))) {
            unset($this->PreferredEndDate);
        } else {
            $this->PreferredEndDate = $preferredEndDate;
        }
        return $this;
    }
    /**
     * Get PreferredStartDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPreferredStartDate()
    {
        return isset($this->PreferredStartDate) ? $this->PreferredStartDate : null;
    }
    /**
     * Set PreferredStartDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $preferredStartDate
     * @return \patest\StructType\BizAction_BizResource_CreateOrder_Request
     */
    public function setPreferredStartDate($preferredStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($preferredStartDate) && !is_string($preferredStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($preferredStartDate, true), gettype($preferredStartDate)), __LINE__);
        }
        if (is_null($preferredStartDate) || (is_array($preferredStartDate) && empty($preferredStartDate))) {
            unset($this->PreferredStartDate);
        } else {
            $this->PreferredStartDate = $preferredStartDate;
        }
        return $this;
    }
    /**
     * Get PricingPerType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPricingPerType()
    {
        return isset($this->PricingPerType) ? $this->PricingPerType : null;
    }
    /**
     * Set PricingPerType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PricingPerType::valueIsValid()
     * @uses \patest\EnumType\PricingPerType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pricingPerType
     * @return \patest\StructType\BizAction_BizResource_CreateOrder_Request
     */
    public function setPricingPerType($pricingPerType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PricingPerType::valueIsValid($pricingPerType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PricingPerType', is_array($pricingPerType) ? implode(', ', $pricingPerType) : var_export($pricingPerType, true), implode(', ', \patest\EnumType\PricingPerType::getValidValues())), __LINE__);
        }
        if (is_null($pricingPerType) || (is_array($pricingPerType) && empty($pricingPerType))) {
            unset($this->PricingPerType);
        } else {
            $this->PricingPerType = $pricingPerType;
        }
        return $this;
    }
    /**
     * Get VisitComment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVisitComment()
    {
        return isset($this->VisitComment) ? $this->VisitComment : null;
    }
    /**
     * Set VisitComment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $visitComment
     * @return \patest\StructType\BizAction_BizResource_CreateOrder_Request
     */
    public function setVisitComment($visitComment = null)
    {
        // validation for constraint: string
        if (!is_null($visitComment) && !is_string($visitComment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($visitComment, true), gettype($visitComment)), __LINE__);
        }
        if (is_null($visitComment) || (is_array($visitComment) && empty($visitComment))) {
            unset($this->VisitComment);
        } else {
            $this->VisitComment = $visitComment;
        }
        return $this;
    }
    /**
     * Get VisitContactEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVisitContactEmail()
    {
        return isset($this->VisitContactEmail) ? $this->VisitContactEmail : null;
    }
    /**
     * Set VisitContactEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $visitContactEmail
     * @return \patest\StructType\BizAction_BizResource_CreateOrder_Request
     */
    public function setVisitContactEmail($visitContactEmail = null)
    {
        // validation for constraint: string
        if (!is_null($visitContactEmail) && !is_string($visitContactEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($visitContactEmail, true), gettype($visitContactEmail)), __LINE__);
        }
        if (is_null($visitContactEmail) || (is_array($visitContactEmail) && empty($visitContactEmail))) {
            unset($this->VisitContactEmail);
        } else {
            $this->VisitContactEmail = $visitContactEmail;
        }
        return $this;
    }
    /**
     * Get VisitContactFax value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVisitContactFax()
    {
        return isset($this->VisitContactFax) ? $this->VisitContactFax : null;
    }
    /**
     * Set VisitContactFax value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $visitContactFax
     * @return \patest\StructType\BizAction_BizResource_CreateOrder_Request
     */
    public function setVisitContactFax($visitContactFax = null)
    {
        // validation for constraint: string
        if (!is_null($visitContactFax) && !is_string($visitContactFax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($visitContactFax, true), gettype($visitContactFax)), __LINE__);
        }
        if (is_null($visitContactFax) || (is_array($visitContactFax) && empty($visitContactFax))) {
            unset($this->VisitContactFax);
        } else {
            $this->VisitContactFax = $visitContactFax;
        }
        return $this;
    }
    /**
     * Get VisitContactHomePhone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVisitContactHomePhone()
    {
        return isset($this->VisitContactHomePhone) ? $this->VisitContactHomePhone : null;
    }
    /**
     * Set VisitContactHomePhone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $visitContactHomePhone
     * @return \patest\StructType\BizAction_BizResource_CreateOrder_Request
     */
    public function setVisitContactHomePhone($visitContactHomePhone = null)
    {
        // validation for constraint: string
        if (!is_null($visitContactHomePhone) && !is_string($visitContactHomePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($visitContactHomePhone, true), gettype($visitContactHomePhone)), __LINE__);
        }
        if (is_null($visitContactHomePhone) || (is_array($visitContactHomePhone) && empty($visitContactHomePhone))) {
            unset($this->VisitContactHomePhone);
        } else {
            $this->VisitContactHomePhone = $visitContactHomePhone;
        }
        return $this;
    }
    /**
     * Get VisitContactId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVisitContactId()
    {
        return isset($this->VisitContactId) ? $this->VisitContactId : null;
    }
    /**
     * Set VisitContactId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $visitContactId
     * @return \patest\StructType\BizAction_BizResource_CreateOrder_Request
     */
    public function setVisitContactId($visitContactId = null)
    {
        // validation for constraint: string
        if (!is_null($visitContactId) && !is_string($visitContactId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($visitContactId, true), gettype($visitContactId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($visitContactId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $visitContactId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($visitContactId, true)), __LINE__);
        }
        if (is_null($visitContactId) || (is_array($visitContactId) && empty($visitContactId))) {
            unset($this->VisitContactId);
        } else {
            $this->VisitContactId = $visitContactId;
        }
        return $this;
    }
    /**
     * Get VisitContactMobile value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVisitContactMobile()
    {
        return isset($this->VisitContactMobile) ? $this->VisitContactMobile : null;
    }
    /**
     * Set VisitContactMobile value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $visitContactMobile
     * @return \patest\StructType\BizAction_BizResource_CreateOrder_Request
     */
    public function setVisitContactMobile($visitContactMobile = null)
    {
        // validation for constraint: string
        if (!is_null($visitContactMobile) && !is_string($visitContactMobile)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($visitContactMobile, true), gettype($visitContactMobile)), __LINE__);
        }
        if (is_null($visitContactMobile) || (is_array($visitContactMobile) && empty($visitContactMobile))) {
            unset($this->VisitContactMobile);
        } else {
            $this->VisitContactMobile = $visitContactMobile;
        }
        return $this;
    }
    /**
     * Get VisitNatureId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVisitNatureId()
    {
        return isset($this->VisitNatureId) ? $this->VisitNatureId : null;
    }
    /**
     * Set VisitNatureId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $visitNatureId
     * @return \patest\StructType\BizAction_BizResource_CreateOrder_Request
     */
    public function setVisitNatureId($visitNatureId = null)
    {
        // validation for constraint: string
        if (!is_null($visitNatureId) && !is_string($visitNatureId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($visitNatureId, true), gettype($visitNatureId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($visitNatureId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $visitNatureId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($visitNatureId, true)), __LINE__);
        }
        if (is_null($visitNatureId) || (is_array($visitNatureId) && empty($visitNatureId))) {
            unset($this->VisitNatureId);
        } else {
            $this->VisitNatureId = $visitNatureId;
        }
        return $this;
    }
    /**
     * Get VisitPayerAccountId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVisitPayerAccountId()
    {
        return isset($this->VisitPayerAccountId) ? $this->VisitPayerAccountId : null;
    }
    /**
     * Set VisitPayerAccountId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $visitPayerAccountId
     * @return \patest\StructType\BizAction_BizResource_CreateOrder_Request
     */
    public function setVisitPayerAccountId($visitPayerAccountId = null)
    {
        // validation for constraint: string
        if (!is_null($visitPayerAccountId) && !is_string($visitPayerAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($visitPayerAccountId, true), gettype($visitPayerAccountId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($visitPayerAccountId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $visitPayerAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($visitPayerAccountId, true)), __LINE__);
        }
        if (is_null($visitPayerAccountId) || (is_array($visitPayerAccountId) && empty($visitPayerAccountId))) {
            unset($this->VisitPayerAccountId);
        } else {
            $this->VisitPayerAccountId = $visitPayerAccountId;
        }
        return $this;
    }
    /**
     * Get VisitPlanId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVisitPlanId()
    {
        return isset($this->VisitPlanId) ? $this->VisitPlanId : null;
    }
    /**
     * Set VisitPlanId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $visitPlanId
     * @return \patest\StructType\BizAction_BizResource_CreateOrder_Request
     */
    public function setVisitPlanId($visitPlanId = null)
    {
        // validation for constraint: string
        if (!is_null($visitPlanId) && !is_string($visitPlanId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($visitPlanId, true), gettype($visitPlanId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($visitPlanId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $visitPlanId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($visitPlanId, true)), __LINE__);
        }
        if (is_null($visitPlanId) || (is_array($visitPlanId) && empty($visitPlanId))) {
            unset($this->VisitPlanId);
        } else {
            $this->VisitPlanId = $visitPlanId;
        }
        return $this;
    }
    /**
     * Get VisitSkills value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\VisitSkills|null
     */
    public function getVisitSkills()
    {
        return isset($this->VisitSkills) ? $this->VisitSkills : null;
    }
    /**
     * Set VisitSkills value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\VisitSkills $visitSkills
     * @return \patest\StructType\BizAction_BizResource_CreateOrder_Request
     */
    public function setVisitSkills(\patest\StructType\VisitSkills $visitSkills = null)
    {
        if (is_null($visitSkills) || (is_array($visitSkills) && empty($visitSkills))) {
            unset($this->VisitSkills);
        } else {
            $this->VisitSkills = $visitSkills;
        }
        return $this;
    }
    /**
     * Get VisitTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVisitTypeId()
    {
        return isset($this->VisitTypeId) ? $this->VisitTypeId : null;
    }
    /**
     * Set VisitTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $visitTypeId
     * @return \patest\StructType\BizAction_BizResource_CreateOrder_Request
     */
    public function setVisitTypeId($visitTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($visitTypeId) && !is_string($visitTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($visitTypeId, true), gettype($visitTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($visitTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $visitTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($visitTypeId, true)), __LINE__);
        }
        if (is_null($visitTypeId) || (is_array($visitTypeId) && empty($visitTypeId))) {
            unset($this->VisitTypeId);
        } else {
            $this->VisitTypeId = $visitTypeId;
        }
        return $this;
    }
}
