<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.BizResource.AllocateGuides.Request StructType
 * @subpackage Structs
 */
class BizAction_BizResource_AllocateGuides_Request extends AnyEntity
{
    /**
     * The AvailableGuides
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfBizAction_BizResource_AllocateGuides_AvailableGuide
     */
    public $AvailableGuides;
    /**
     * The GuideRequestId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GuideRequestId;
    /**
     * The ShowAllGuides
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ShowAllGuides;
    /**
     * Constructor method for BizAction.BizResource.AllocateGuides.Request
     * @uses BizAction_BizResource_AllocateGuides_Request::setAvailableGuides()
     * @uses BizAction_BizResource_AllocateGuides_Request::setGuideRequestId()
     * @uses BizAction_BizResource_AllocateGuides_Request::setShowAllGuides()
     * @param \patest\StructType\RecordSetOfBizAction_BizResource_AllocateGuides_AvailableGuide $availableGuides
     * @param string $guideRequestId
     * @param bool $showAllGuides
     */
    public function __construct(\patest\StructType\RecordSetOfBizAction_BizResource_AllocateGuides_AvailableGuide $availableGuides = null, $guideRequestId = null, $showAllGuides = null)
    {
        $this
            ->setAvailableGuides($availableGuides)
            ->setGuideRequestId($guideRequestId)
            ->setShowAllGuides($showAllGuides);
    }
    /**
     * Get AvailableGuides value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfBizAction_BizResource_AllocateGuides_AvailableGuide|null
     */
    public function getAvailableGuides()
    {
        return isset($this->AvailableGuides) ? $this->AvailableGuides : null;
    }
    /**
     * Set AvailableGuides value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfBizAction_BizResource_AllocateGuides_AvailableGuide $availableGuides
     * @return \patest\StructType\BizAction_BizResource_AllocateGuides_Request
     */
    public function setAvailableGuides(\patest\StructType\RecordSetOfBizAction_BizResource_AllocateGuides_AvailableGuide $availableGuides = null)
    {
        if (is_null($availableGuides) || (is_array($availableGuides) && empty($availableGuides))) {
            unset($this->AvailableGuides);
        } else {
            $this->AvailableGuides = $availableGuides;
        }
        return $this;
    }
    /**
     * Get GuideRequestId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGuideRequestId()
    {
        return isset($this->GuideRequestId) ? $this->GuideRequestId : null;
    }
    /**
     * Set GuideRequestId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $guideRequestId
     * @return \patest\StructType\BizAction_BizResource_AllocateGuides_Request
     */
    public function setGuideRequestId($guideRequestId = null)
    {
        // validation for constraint: string
        if (!is_null($guideRequestId) && !is_string($guideRequestId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guideRequestId, true), gettype($guideRequestId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($guideRequestId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $guideRequestId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($guideRequestId, true)), __LINE__);
        }
        if (is_null($guideRequestId) || (is_array($guideRequestId) && empty($guideRequestId))) {
            unset($this->GuideRequestId);
        } else {
            $this->GuideRequestId = $guideRequestId;
        }
        return $this;
    }
    /**
     * Get ShowAllGuides value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getShowAllGuides()
    {
        return isset($this->ShowAllGuides) ? $this->ShowAllGuides : null;
    }
    /**
     * Set ShowAllGuides value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $showAllGuides
     * @return \patest\StructType\BizAction_BizResource_AllocateGuides_Request
     */
    public function setShowAllGuides($showAllGuides = null)
    {
        // validation for constraint: boolean
        if (!is_null($showAllGuides) && !is_bool($showAllGuides)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showAllGuides, true), gettype($showAllGuides)), __LINE__);
        }
        if (is_null($showAllGuides) || (is_array($showAllGuides) && empty($showAllGuides))) {
            unset($this->ShowAllGuides);
        } else {
            $this->ShowAllGuides = $showAllGuides;
        }
        return $this;
    }
}
