<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.BizResource.AllocateGuides.AvailableGuide
 * StructType
 * @subpackage Structs
 */
class BizAction_BizResource_AllocateGuides_AvailableGuide extends AnyEntity
{
    /**
     * The GuideId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GuideId;
    /**
     * Constructor method for BizAction.BizResource.AllocateGuides.AvailableGuide
     * @uses BizAction_BizResource_AllocateGuides_AvailableGuide::setGuideId()
     * @param string $guideId
     */
    public function __construct($guideId = null)
    {
        $this
            ->setGuideId($guideId);
    }
    /**
     * Get GuideId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGuideId()
    {
        return isset($this->GuideId) ? $this->GuideId : null;
    }
    /**
     * Set GuideId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $guideId
     * @return \patest\StructType\BizAction_BizResource_AllocateGuides_AvailableGuide
     */
    public function setGuideId($guideId = null)
    {
        // validation for constraint: string
        if (!is_null($guideId) && !is_string($guideId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guideId, true), gettype($guideId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($guideId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $guideId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($guideId, true)), __LINE__);
        }
        if (is_null($guideId) || (is_array($guideId) && empty($guideId))) {
            unset($this->GuideId);
        } else {
            $this->GuideId = $guideId;
        }
        return $this;
    }
}
