<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * BizAction.AccessControl.BulkReactivateTicketBarcodes.Request StructType
 * @subpackage Structs
 */
class BizAction_AccessControl_BulkReactivateTicketBarcodes_Request extends BizAction_Foundation_BulkOperation_Request
{
    /**
     * The ReactivationOption
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReactivationOption;
    /**
     * Constructor method for
     * BizAction.AccessControl.BulkReactivateTicketBarcodes.Request
     * @uses BizAction_AccessControl_BulkReactivateTicketBarcodes_Request::setReactivationOption()
     * @param string $reactivationOption
     */
    public function __construct($reactivationOption = null)
    {
        $this
            ->setReactivationOption($reactivationOption);
    }
    /**
     * Get ReactivationOption value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReactivationOption()
    {
        return isset($this->ReactivationOption) ? $this->ReactivationOption : null;
    }
    /**
     * Set ReactivationOption value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\BulkBarcodeReactivationOption::valueIsValid()
     * @uses \patest\EnumType\BulkBarcodeReactivationOption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $reactivationOption
     * @return \patest\StructType\BizAction_AccessControl_BulkReactivateTicketBarcodes_Request
     */
    public function setReactivationOption($reactivationOption = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BulkBarcodeReactivationOption::valueIsValid($reactivationOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BulkBarcodeReactivationOption', is_array($reactivationOption) ? implode(', ', $reactivationOption) : var_export($reactivationOption, true), implode(', ', \patest\EnumType\BulkBarcodeReactivationOption::getValidValues())), __LINE__);
        }
        if (is_null($reactivationOption) || (is_array($reactivationOption) && empty($reactivationOption))) {
            unset($this->ReactivationOption);
        } else {
            $this->ReactivationOption = $reactivationOption;
        }
        return $this;
    }
}
