<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * BizActionLogics.Foundation.ProcessDefinitionSummery.Activate.Request StructType
 * @subpackage Structs
 */
class BizActionLogics_Foundation_ProcessDefinitionSummery_Activate_Request extends AnyEntity
{
    /**
     * The ProcessId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ProcessId;
    /**
     * Constructor method for
     * BizActionLogics.Foundation.ProcessDefinitionSummery.Activate.Request
     * @uses BizActionLogics_Foundation_ProcessDefinitionSummery_Activate_Request::setProcessId()
     * @param string $processId
     */
    public function __construct($processId = null)
    {
        $this
            ->setProcessId($processId);
    }
    /**
     * Get ProcessId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProcessId()
    {
        return isset($this->ProcessId) ? $this->ProcessId : null;
    }
    /**
     * Set ProcessId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $processId
     * @return \patest\StructType\BizActionLogics_Foundation_ProcessDefinitionSummery_Activate_Request
     */
    public function setProcessId($processId = null)
    {
        // validation for constraint: string
        if (!is_null($processId) && !is_string($processId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($processId, true), gettype($processId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($processId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $processId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($processId, true)), __LINE__);
        }
        if (is_null($processId) || (is_array($processId) && empty($processId))) {
            unset($this->ProcessId);
        } else {
            $this->ProcessId = $processId;
        }
        return $this;
    }
}
