<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * BizActionLogics.AccessControl.ReactivateTicketsBarcode.Request StructType
 * @subpackage Structs
 */
class BizActionLogics_AccessControl_ReactivateTicketsBarcode_Request extends AnyEntity
{
    /**
     * The AccessControlSystemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccessControlSystemId;
    /**
     * The ActiveBarcode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ActiveBarcode;
    /**
     * The BarcodeToReactivate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BarcodeToReactivate;
    /**
     * The CurrentTicketIndex
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CurrentTicketIndex;
    /**
     * The IsValid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsValid;
    /**
     * The TicketDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TicketDescription;
    /**
     * The TicketIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\TicketIds
     */
    public $TicketIds;
    /**
     * The TicketPrintedBarcodes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfAccessControl_TicketBarcodePrintHistory
     */
    public $TicketPrintedBarcodes;
    /**
     * The ValidityMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ValidityMessage;
    /**
     * Constructor method for
     * BizActionLogics.AccessControl.ReactivateTicketsBarcode.Request
     * @uses BizActionLogics_AccessControl_ReactivateTicketsBarcode_Request::setAccessControlSystemId()
     * @uses BizActionLogics_AccessControl_ReactivateTicketsBarcode_Request::setActiveBarcode()
     * @uses BizActionLogics_AccessControl_ReactivateTicketsBarcode_Request::setBarcodeToReactivate()
     * @uses BizActionLogics_AccessControl_ReactivateTicketsBarcode_Request::setCurrentTicketIndex()
     * @uses BizActionLogics_AccessControl_ReactivateTicketsBarcode_Request::setIsValid()
     * @uses BizActionLogics_AccessControl_ReactivateTicketsBarcode_Request::setTicketDescription()
     * @uses BizActionLogics_AccessControl_ReactivateTicketsBarcode_Request::setTicketIds()
     * @uses BizActionLogics_AccessControl_ReactivateTicketsBarcode_Request::setTicketPrintedBarcodes()
     * @uses BizActionLogics_AccessControl_ReactivateTicketsBarcode_Request::setValidityMessage()
     * @param string $accessControlSystemId
     * @param string $activeBarcode
     * @param string $barcodeToReactivate
     * @param int $currentTicketIndex
     * @param bool $isValid
     * @param string $ticketDescription
     * @param \patest\StructType\TicketIds $ticketIds
     * @param \patest\StructType\RecordSetOfAccessControl_TicketBarcodePrintHistory $ticketPrintedBarcodes
     * @param string $validityMessage
     */
    public function __construct($accessControlSystemId = null, $activeBarcode = null, $barcodeToReactivate = null, $currentTicketIndex = null, $isValid = null, $ticketDescription = null, \patest\StructType\TicketIds $ticketIds = null, \patest\StructType\RecordSetOfAccessControl_TicketBarcodePrintHistory $ticketPrintedBarcodes = null, $validityMessage = null)
    {
        $this
            ->setAccessControlSystemId($accessControlSystemId)
            ->setActiveBarcode($activeBarcode)
            ->setBarcodeToReactivate($barcodeToReactivate)
            ->setCurrentTicketIndex($currentTicketIndex)
            ->setIsValid($isValid)
            ->setTicketDescription($ticketDescription)
            ->setTicketIds($ticketIds)
            ->setTicketPrintedBarcodes($ticketPrintedBarcodes)
            ->setValidityMessage($validityMessage);
    }
    /**
     * Get AccessControlSystemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessControlSystemId()
    {
        return isset($this->AccessControlSystemId) ? $this->AccessControlSystemId : null;
    }
    /**
     * Set AccessControlSystemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessControlSystemId
     * @return \patest\StructType\BizActionLogics_AccessControl_ReactivateTicketsBarcode_Request
     */
    public function setAccessControlSystemId($accessControlSystemId = null)
    {
        // validation for constraint: string
        if (!is_null($accessControlSystemId) && !is_string($accessControlSystemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessControlSystemId, true), gettype($accessControlSystemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accessControlSystemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accessControlSystemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accessControlSystemId, true)), __LINE__);
        }
        if (is_null($accessControlSystemId) || (is_array($accessControlSystemId) && empty($accessControlSystemId))) {
            unset($this->AccessControlSystemId);
        } else {
            $this->AccessControlSystemId = $accessControlSystemId;
        }
        return $this;
    }
    /**
     * Get ActiveBarcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActiveBarcode()
    {
        return isset($this->ActiveBarcode) ? $this->ActiveBarcode : null;
    }
    /**
     * Set ActiveBarcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $activeBarcode
     * @return \patest\StructType\BizActionLogics_AccessControl_ReactivateTicketsBarcode_Request
     */
    public function setActiveBarcode($activeBarcode = null)
    {
        // validation for constraint: string
        if (!is_null($activeBarcode) && !is_string($activeBarcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($activeBarcode, true), gettype($activeBarcode)), __LINE__);
        }
        if (is_null($activeBarcode) || (is_array($activeBarcode) && empty($activeBarcode))) {
            unset($this->ActiveBarcode);
        } else {
            $this->ActiveBarcode = $activeBarcode;
        }
        return $this;
    }
    /**
     * Get BarcodeToReactivate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBarcodeToReactivate()
    {
        return isset($this->BarcodeToReactivate) ? $this->BarcodeToReactivate : null;
    }
    /**
     * Set BarcodeToReactivate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $barcodeToReactivate
     * @return \patest\StructType\BizActionLogics_AccessControl_ReactivateTicketsBarcode_Request
     */
    public function setBarcodeToReactivate($barcodeToReactivate = null)
    {
        // validation for constraint: string
        if (!is_null($barcodeToReactivate) && !is_string($barcodeToReactivate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcodeToReactivate, true), gettype($barcodeToReactivate)), __LINE__);
        }
        if (is_null($barcodeToReactivate) || (is_array($barcodeToReactivate) && empty($barcodeToReactivate))) {
            unset($this->BarcodeToReactivate);
        } else {
            $this->BarcodeToReactivate = $barcodeToReactivate;
        }
        return $this;
    }
    /**
     * Get CurrentTicketIndex value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCurrentTicketIndex()
    {
        return isset($this->CurrentTicketIndex) ? $this->CurrentTicketIndex : null;
    }
    /**
     * Set CurrentTicketIndex value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $currentTicketIndex
     * @return \patest\StructType\BizActionLogics_AccessControl_ReactivateTicketsBarcode_Request
     */
    public function setCurrentTicketIndex($currentTicketIndex = null)
    {
        // validation for constraint: int
        if (!is_null($currentTicketIndex) && !(is_int($currentTicketIndex) || ctype_digit($currentTicketIndex))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($currentTicketIndex, true), gettype($currentTicketIndex)), __LINE__);
        }
        if (is_null($currentTicketIndex) || (is_array($currentTicketIndex) && empty($currentTicketIndex))) {
            unset($this->CurrentTicketIndex);
        } else {
            $this->CurrentTicketIndex = $currentTicketIndex;
        }
        return $this;
    }
    /**
     * Get IsValid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsValid()
    {
        return isset($this->IsValid) ? $this->IsValid : null;
    }
    /**
     * Set IsValid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isValid
     * @return \patest\StructType\BizActionLogics_AccessControl_ReactivateTicketsBarcode_Request
     */
    public function setIsValid($isValid = null)
    {
        // validation for constraint: boolean
        if (!is_null($isValid) && !is_bool($isValid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isValid, true), gettype($isValid)), __LINE__);
        }
        if (is_null($isValid) || (is_array($isValid) && empty($isValid))) {
            unset($this->IsValid);
        } else {
            $this->IsValid = $isValid;
        }
        return $this;
    }
    /**
     * Get TicketDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketDescription()
    {
        return isset($this->TicketDescription) ? $this->TicketDescription : null;
    }
    /**
     * Set TicketDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketDescription
     * @return \patest\StructType\BizActionLogics_AccessControl_ReactivateTicketsBarcode_Request
     */
    public function setTicketDescription($ticketDescription = null)
    {
        // validation for constraint: string
        if (!is_null($ticketDescription) && !is_string($ticketDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketDescription, true), gettype($ticketDescription)), __LINE__);
        }
        if (is_null($ticketDescription) || (is_array($ticketDescription) && empty($ticketDescription))) {
            unset($this->TicketDescription);
        } else {
            $this->TicketDescription = $ticketDescription;
        }
        return $this;
    }
    /**
     * Get TicketIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\TicketIds|null
     */
    public function getTicketIds()
    {
        return isset($this->TicketIds) ? $this->TicketIds : null;
    }
    /**
     * Set TicketIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\TicketIds $ticketIds
     * @return \patest\StructType\BizActionLogics_AccessControl_ReactivateTicketsBarcode_Request
     */
    public function setTicketIds(\patest\StructType\TicketIds $ticketIds = null)
    {
        if (is_null($ticketIds) || (is_array($ticketIds) && empty($ticketIds))) {
            unset($this->TicketIds);
        } else {
            $this->TicketIds = $ticketIds;
        }
        return $this;
    }
    /**
     * Get TicketPrintedBarcodes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfAccessControl_TicketBarcodePrintHistory|null
     */
    public function getTicketPrintedBarcodes()
    {
        return isset($this->TicketPrintedBarcodes) ? $this->TicketPrintedBarcodes : null;
    }
    /**
     * Set TicketPrintedBarcodes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfAccessControl_TicketBarcodePrintHistory $ticketPrintedBarcodes
     * @return \patest\StructType\BizActionLogics_AccessControl_ReactivateTicketsBarcode_Request
     */
    public function setTicketPrintedBarcodes(\patest\StructType\RecordSetOfAccessControl_TicketBarcodePrintHistory $ticketPrintedBarcodes = null)
    {
        if (is_null($ticketPrintedBarcodes) || (is_array($ticketPrintedBarcodes) && empty($ticketPrintedBarcodes))) {
            unset($this->TicketPrintedBarcodes);
        } else {
            $this->TicketPrintedBarcodes = $ticketPrintedBarcodes;
        }
        return $this;
    }
    /**
     * Get ValidityMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValidityMessage()
    {
        return isset($this->ValidityMessage) ? $this->ValidityMessage : null;
    }
    /**
     * Set ValidityMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $validityMessage
     * @return \patest\StructType\BizActionLogics_AccessControl_ReactivateTicketsBarcode_Request
     */
    public function setValidityMessage($validityMessage = null)
    {
        // validation for constraint: string
        if (!is_null($validityMessage) && !is_string($validityMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validityMessage, true), gettype($validityMessage)), __LINE__);
        }
        if (is_null($validityMessage) || (is_array($validityMessage) && empty($validityMessage))) {
            unset($this->ValidityMessage);
        } else {
            $this->ValidityMessage = $validityMessage;
        }
        return $this;
    }
}
