<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * BizActionLogics.AccessControl.ReactivateSubscriptionsBarcode.Request StructType
 * @subpackage Structs
 */
class BizActionLogics_AccessControl_ReactivateSubscriptionsBarcode_Request extends AnyEntity
{
    /**
     * The AccessControlSystemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccessControlSystemId;
    /**
     * The BarcodeToReactivate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BarcodeToReactivate;
    /**
     * The CurrentSubscriptionIndex
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CurrentSubscriptionIndex;
    /**
     * The IsBarcodeRequired
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsBarcodeRequired;
    /**
     * The IsValid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsValid;
    /**
     * The ReactivateManner
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReactivateManner;
    /**
     * The SubscriptionDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SubscriptionDescription;
    /**
     * The SubscriptionIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SubscriptionIds
     */
    public $SubscriptionIds;
    /**
     * The ValidityMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ValidityMessage;
    /**
     * Constructor method for
     * BizActionLogics.AccessControl.ReactivateSubscriptionsBarcode.Request
     * @uses BizActionLogics_AccessControl_ReactivateSubscriptionsBarcode_Request::setAccessControlSystemId()
     * @uses BizActionLogics_AccessControl_ReactivateSubscriptionsBarcode_Request::setBarcodeToReactivate()
     * @uses BizActionLogics_AccessControl_ReactivateSubscriptionsBarcode_Request::setCurrentSubscriptionIndex()
     * @uses BizActionLogics_AccessControl_ReactivateSubscriptionsBarcode_Request::setIsBarcodeRequired()
     * @uses BizActionLogics_AccessControl_ReactivateSubscriptionsBarcode_Request::setIsValid()
     * @uses BizActionLogics_AccessControl_ReactivateSubscriptionsBarcode_Request::setReactivateManner()
     * @uses BizActionLogics_AccessControl_ReactivateSubscriptionsBarcode_Request::setSubscriptionDescription()
     * @uses BizActionLogics_AccessControl_ReactivateSubscriptionsBarcode_Request::setSubscriptionIds()
     * @uses BizActionLogics_AccessControl_ReactivateSubscriptionsBarcode_Request::setValidityMessage()
     * @param string $accessControlSystemId
     * @param string $barcodeToReactivate
     * @param int $currentSubscriptionIndex
     * @param bool $isBarcodeRequired
     * @param bool $isValid
     * @param string $reactivateManner
     * @param string $subscriptionDescription
     * @param \patest\StructType\SubscriptionIds $subscriptionIds
     * @param string $validityMessage
     */
    public function __construct($accessControlSystemId = null, $barcodeToReactivate = null, $currentSubscriptionIndex = null, $isBarcodeRequired = null, $isValid = null, $reactivateManner = null, $subscriptionDescription = null, \patest\StructType\SubscriptionIds $subscriptionIds = null, $validityMessage = null)
    {
        $this
            ->setAccessControlSystemId($accessControlSystemId)
            ->setBarcodeToReactivate($barcodeToReactivate)
            ->setCurrentSubscriptionIndex($currentSubscriptionIndex)
            ->setIsBarcodeRequired($isBarcodeRequired)
            ->setIsValid($isValid)
            ->setReactivateManner($reactivateManner)
            ->setSubscriptionDescription($subscriptionDescription)
            ->setSubscriptionIds($subscriptionIds)
            ->setValidityMessage($validityMessage);
    }
    /**
     * Get AccessControlSystemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessControlSystemId()
    {
        return isset($this->AccessControlSystemId) ? $this->AccessControlSystemId : null;
    }
    /**
     * Set AccessControlSystemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessControlSystemId
     * @return \patest\StructType\BizActionLogics_AccessControl_ReactivateSubscriptionsBarcode_Request
     */
    public function setAccessControlSystemId($accessControlSystemId = null)
    {
        // validation for constraint: string
        if (!is_null($accessControlSystemId) && !is_string($accessControlSystemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessControlSystemId, true), gettype($accessControlSystemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accessControlSystemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accessControlSystemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accessControlSystemId, true)), __LINE__);
        }
        if (is_null($accessControlSystemId) || (is_array($accessControlSystemId) && empty($accessControlSystemId))) {
            unset($this->AccessControlSystemId);
        } else {
            $this->AccessControlSystemId = $accessControlSystemId;
        }
        return $this;
    }
    /**
     * Get BarcodeToReactivate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBarcodeToReactivate()
    {
        return isset($this->BarcodeToReactivate) ? $this->BarcodeToReactivate : null;
    }
    /**
     * Set BarcodeToReactivate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $barcodeToReactivate
     * @return \patest\StructType\BizActionLogics_AccessControl_ReactivateSubscriptionsBarcode_Request
     */
    public function setBarcodeToReactivate($barcodeToReactivate = null)
    {
        // validation for constraint: string
        if (!is_null($barcodeToReactivate) && !is_string($barcodeToReactivate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcodeToReactivate, true), gettype($barcodeToReactivate)), __LINE__);
        }
        if (is_null($barcodeToReactivate) || (is_array($barcodeToReactivate) && empty($barcodeToReactivate))) {
            unset($this->BarcodeToReactivate);
        } else {
            $this->BarcodeToReactivate = $barcodeToReactivate;
        }
        return $this;
    }
    /**
     * Get CurrentSubscriptionIndex value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCurrentSubscriptionIndex()
    {
        return isset($this->CurrentSubscriptionIndex) ? $this->CurrentSubscriptionIndex : null;
    }
    /**
     * Set CurrentSubscriptionIndex value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $currentSubscriptionIndex
     * @return \patest\StructType\BizActionLogics_AccessControl_ReactivateSubscriptionsBarcode_Request
     */
    public function setCurrentSubscriptionIndex($currentSubscriptionIndex = null)
    {
        // validation for constraint: int
        if (!is_null($currentSubscriptionIndex) && !(is_int($currentSubscriptionIndex) || ctype_digit($currentSubscriptionIndex))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($currentSubscriptionIndex, true), gettype($currentSubscriptionIndex)), __LINE__);
        }
        if (is_null($currentSubscriptionIndex) || (is_array($currentSubscriptionIndex) && empty($currentSubscriptionIndex))) {
            unset($this->CurrentSubscriptionIndex);
        } else {
            $this->CurrentSubscriptionIndex = $currentSubscriptionIndex;
        }
        return $this;
    }
    /**
     * Get IsBarcodeRequired value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsBarcodeRequired()
    {
        return isset($this->IsBarcodeRequired) ? $this->IsBarcodeRequired : null;
    }
    /**
     * Set IsBarcodeRequired value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isBarcodeRequired
     * @return \patest\StructType\BizActionLogics_AccessControl_ReactivateSubscriptionsBarcode_Request
     */
    public function setIsBarcodeRequired($isBarcodeRequired = null)
    {
        // validation for constraint: boolean
        if (!is_null($isBarcodeRequired) && !is_bool($isBarcodeRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isBarcodeRequired, true), gettype($isBarcodeRequired)), __LINE__);
        }
        if (is_null($isBarcodeRequired) || (is_array($isBarcodeRequired) && empty($isBarcodeRequired))) {
            unset($this->IsBarcodeRequired);
        } else {
            $this->IsBarcodeRequired = $isBarcodeRequired;
        }
        return $this;
    }
    /**
     * Get IsValid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsValid()
    {
        return isset($this->IsValid) ? $this->IsValid : null;
    }
    /**
     * Set IsValid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isValid
     * @return \patest\StructType\BizActionLogics_AccessControl_ReactivateSubscriptionsBarcode_Request
     */
    public function setIsValid($isValid = null)
    {
        // validation for constraint: boolean
        if (!is_null($isValid) && !is_bool($isValid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isValid, true), gettype($isValid)), __LINE__);
        }
        if (is_null($isValid) || (is_array($isValid) && empty($isValid))) {
            unset($this->IsValid);
        } else {
            $this->IsValid = $isValid;
        }
        return $this;
    }
    /**
     * Get ReactivateManner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReactivateManner()
    {
        return isset($this->ReactivateManner) ? $this->ReactivateManner : null;
    }
    /**
     * Set ReactivateManner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\BarcodeReactivateManner::valueIsValid()
     * @uses \patest\EnumType\BarcodeReactivateManner::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $reactivateManner
     * @return \patest\StructType\BizActionLogics_AccessControl_ReactivateSubscriptionsBarcode_Request
     */
    public function setReactivateManner($reactivateManner = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BarcodeReactivateManner::valueIsValid($reactivateManner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BarcodeReactivateManner', is_array($reactivateManner) ? implode(', ', $reactivateManner) : var_export($reactivateManner, true), implode(', ', \patest\EnumType\BarcodeReactivateManner::getValidValues())), __LINE__);
        }
        if (is_null($reactivateManner) || (is_array($reactivateManner) && empty($reactivateManner))) {
            unset($this->ReactivateManner);
        } else {
            $this->ReactivateManner = $reactivateManner;
        }
        return $this;
    }
    /**
     * Get SubscriptionDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriptionDescription()
    {
        return isset($this->SubscriptionDescription) ? $this->SubscriptionDescription : null;
    }
    /**
     * Set SubscriptionDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subscriptionDescription
     * @return \patest\StructType\BizActionLogics_AccessControl_ReactivateSubscriptionsBarcode_Request
     */
    public function setSubscriptionDescription($subscriptionDescription = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionDescription) && !is_string($subscriptionDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriptionDescription, true), gettype($subscriptionDescription)), __LINE__);
        }
        if (is_null($subscriptionDescription) || (is_array($subscriptionDescription) && empty($subscriptionDescription))) {
            unset($this->SubscriptionDescription);
        } else {
            $this->SubscriptionDescription = $subscriptionDescription;
        }
        return $this;
    }
    /**
     * Get SubscriptionIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SubscriptionIds|null
     */
    public function getSubscriptionIds()
    {
        return isset($this->SubscriptionIds) ? $this->SubscriptionIds : null;
    }
    /**
     * Set SubscriptionIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SubscriptionIds $subscriptionIds
     * @return \patest\StructType\BizActionLogics_AccessControl_ReactivateSubscriptionsBarcode_Request
     */
    public function setSubscriptionIds(\patest\StructType\SubscriptionIds $subscriptionIds = null)
    {
        if (is_null($subscriptionIds) || (is_array($subscriptionIds) && empty($subscriptionIds))) {
            unset($this->SubscriptionIds);
        } else {
            $this->SubscriptionIds = $subscriptionIds;
        }
        return $this;
    }
    /**
     * Get ValidityMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValidityMessage()
    {
        return isset($this->ValidityMessage) ? $this->ValidityMessage : null;
    }
    /**
     * Set ValidityMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $validityMessage
     * @return \patest\StructType\BizActionLogics_AccessControl_ReactivateSubscriptionsBarcode_Request
     */
    public function setValidityMessage($validityMessage = null)
    {
        // validation for constraint: string
        if (!is_null($validityMessage) && !is_string($validityMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validityMessage, true), gettype($validityMessage)), __LINE__);
        }
        if (is_null($validityMessage) || (is_array($validityMessage) && empty($validityMessage))) {
            unset($this->ValidityMessage);
        } else {
            $this->ValidityMessage = $validityMessage;
        }
        return $this;
    }
}
