<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizActionLogics.AccessControl.ReactivateBarcodeRequest
 * StructType
 * @subpackage Structs
 */
class BizActionLogics_AccessControl_ReactivateBarcodeRequest extends AnyEntity
{
    /**
     * The AccessControlSystemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccessControlSystemId;
    /**
     * The ActiveBarcode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ActiveBarcode;
    /**
     * The Barcode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Barcode;
    /**
     * The IsInputBarcode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsInputBarcode;
    /**
     * The ReactivateManner
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReactivateManner;
    /**
     * The ReferencedEntityId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ReferencedEntityId;
    /**
     * The ReferencedEntityName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReferencedEntityName;
    /**
     * Constructor method for BizActionLogics.AccessControl.ReactivateBarcodeRequest
     * @uses BizActionLogics_AccessControl_ReactivateBarcodeRequest::setAccessControlSystemId()
     * @uses BizActionLogics_AccessControl_ReactivateBarcodeRequest::setActiveBarcode()
     * @uses BizActionLogics_AccessControl_ReactivateBarcodeRequest::setBarcode()
     * @uses BizActionLogics_AccessControl_ReactivateBarcodeRequest::setIsInputBarcode()
     * @uses BizActionLogics_AccessControl_ReactivateBarcodeRequest::setReactivateManner()
     * @uses BizActionLogics_AccessControl_ReactivateBarcodeRequest::setReferencedEntityId()
     * @uses BizActionLogics_AccessControl_ReactivateBarcodeRequest::setReferencedEntityName()
     * @param string $accessControlSystemId
     * @param string $activeBarcode
     * @param string $barcode
     * @param bool $isInputBarcode
     * @param string $reactivateManner
     * @param string $referencedEntityId
     * @param string $referencedEntityName
     */
    public function __construct($accessControlSystemId = null, $activeBarcode = null, $barcode = null, $isInputBarcode = null, $reactivateManner = null, $referencedEntityId = null, $referencedEntityName = null)
    {
        $this
            ->setAccessControlSystemId($accessControlSystemId)
            ->setActiveBarcode($activeBarcode)
            ->setBarcode($barcode)
            ->setIsInputBarcode($isInputBarcode)
            ->setReactivateManner($reactivateManner)
            ->setReferencedEntityId($referencedEntityId)
            ->setReferencedEntityName($referencedEntityName);
    }
    /**
     * Get AccessControlSystemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessControlSystemId()
    {
        return isset($this->AccessControlSystemId) ? $this->AccessControlSystemId : null;
    }
    /**
     * Set AccessControlSystemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessControlSystemId
     * @return \patest\StructType\BizActionLogics_AccessControl_ReactivateBarcodeRequest
     */
    public function setAccessControlSystemId($accessControlSystemId = null)
    {
        // validation for constraint: string
        if (!is_null($accessControlSystemId) && !is_string($accessControlSystemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessControlSystemId, true), gettype($accessControlSystemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accessControlSystemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accessControlSystemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accessControlSystemId, true)), __LINE__);
        }
        if (is_null($accessControlSystemId) || (is_array($accessControlSystemId) && empty($accessControlSystemId))) {
            unset($this->AccessControlSystemId);
        } else {
            $this->AccessControlSystemId = $accessControlSystemId;
        }
        return $this;
    }
    /**
     * Get ActiveBarcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActiveBarcode()
    {
        return isset($this->ActiveBarcode) ? $this->ActiveBarcode : null;
    }
    /**
     * Set ActiveBarcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $activeBarcode
     * @return \patest\StructType\BizActionLogics_AccessControl_ReactivateBarcodeRequest
     */
    public function setActiveBarcode($activeBarcode = null)
    {
        // validation for constraint: string
        if (!is_null($activeBarcode) && !is_string($activeBarcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($activeBarcode, true), gettype($activeBarcode)), __LINE__);
        }
        if (is_null($activeBarcode) || (is_array($activeBarcode) && empty($activeBarcode))) {
            unset($this->ActiveBarcode);
        } else {
            $this->ActiveBarcode = $activeBarcode;
        }
        return $this;
    }
    /**
     * Get Barcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBarcode()
    {
        return isset($this->Barcode) ? $this->Barcode : null;
    }
    /**
     * Set Barcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $barcode
     * @return \patest\StructType\BizActionLogics_AccessControl_ReactivateBarcodeRequest
     */
    public function setBarcode($barcode = null)
    {
        // validation for constraint: string
        if (!is_null($barcode) && !is_string($barcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcode, true), gettype($barcode)), __LINE__);
        }
        if (is_null($barcode) || (is_array($barcode) && empty($barcode))) {
            unset($this->Barcode);
        } else {
            $this->Barcode = $barcode;
        }
        return $this;
    }
    /**
     * Get IsInputBarcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsInputBarcode()
    {
        return isset($this->IsInputBarcode) ? $this->IsInputBarcode : null;
    }
    /**
     * Set IsInputBarcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isInputBarcode
     * @return \patest\StructType\BizActionLogics_AccessControl_ReactivateBarcodeRequest
     */
    public function setIsInputBarcode($isInputBarcode = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInputBarcode) && !is_bool($isInputBarcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInputBarcode, true), gettype($isInputBarcode)), __LINE__);
        }
        if (is_null($isInputBarcode) || (is_array($isInputBarcode) && empty($isInputBarcode))) {
            unset($this->IsInputBarcode);
        } else {
            $this->IsInputBarcode = $isInputBarcode;
        }
        return $this;
    }
    /**
     * Get ReactivateManner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReactivateManner()
    {
        return isset($this->ReactivateManner) ? $this->ReactivateManner : null;
    }
    /**
     * Set ReactivateManner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\BarcodeReactivateManner::valueIsValid()
     * @uses \patest\EnumType\BarcodeReactivateManner::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $reactivateManner
     * @return \patest\StructType\BizActionLogics_AccessControl_ReactivateBarcodeRequest
     */
    public function setReactivateManner($reactivateManner = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BarcodeReactivateManner::valueIsValid($reactivateManner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BarcodeReactivateManner', is_array($reactivateManner) ? implode(', ', $reactivateManner) : var_export($reactivateManner, true), implode(', ', \patest\EnumType\BarcodeReactivateManner::getValidValues())), __LINE__);
        }
        if (is_null($reactivateManner) || (is_array($reactivateManner) && empty($reactivateManner))) {
            unset($this->ReactivateManner);
        } else {
            $this->ReactivateManner = $reactivateManner;
        }
        return $this;
    }
    /**
     * Get ReferencedEntityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReferencedEntityId()
    {
        return isset($this->ReferencedEntityId) ? $this->ReferencedEntityId : null;
    }
    /**
     * Set ReferencedEntityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $referencedEntityId
     * @return \patest\StructType\BizActionLogics_AccessControl_ReactivateBarcodeRequest
     */
    public function setReferencedEntityId($referencedEntityId = null)
    {
        // validation for constraint: string
        if (!is_null($referencedEntityId) && !is_string($referencedEntityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referencedEntityId, true), gettype($referencedEntityId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($referencedEntityId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $referencedEntityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($referencedEntityId, true)), __LINE__);
        }
        if (is_null($referencedEntityId) || (is_array($referencedEntityId) && empty($referencedEntityId))) {
            unset($this->ReferencedEntityId);
        } else {
            $this->ReferencedEntityId = $referencedEntityId;
        }
        return $this;
    }
    /**
     * Get ReferencedEntityName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReferencedEntityName()
    {
        return isset($this->ReferencedEntityName) ? $this->ReferencedEntityName : null;
    }
    /**
     * Set ReferencedEntityName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $referencedEntityName
     * @return \patest\StructType\BizActionLogics_AccessControl_ReactivateBarcodeRequest
     */
    public function setReferencedEntityName($referencedEntityName = null)
    {
        // validation for constraint: string
        if (!is_null($referencedEntityName) && !is_string($referencedEntityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referencedEntityName, true), gettype($referencedEntityName)), __LINE__);
        }
        if (is_null($referencedEntityName) || (is_array($referencedEntityName) && empty($referencedEntityName))) {
            unset($this->ReferencedEntityName);
        } else {
            $this->ReferencedEntityName = $referencedEntityName;
        }
        return $this;
    }
}
