<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BindSalePointToIdentifier-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:BindSalePointToIdentifier-Request
 * @subpackage Structs
 */
class BindSalePointToIdentifier_Request extends ExtensibleDataContract
{
    /**
     * The IsRoaming
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsRoaming;
    /**
     * The SalePointId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SalePointId;
    /**
     * The SalePointIdentifier
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SalePointIdentifier;
    /**
     * The UpdateConnectionProperties
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $UpdateConnectionProperties;
    /**
     * Constructor method for BindSalePointToIdentifier-Request
     * @uses BindSalePointToIdentifier_Request::setIsRoaming()
     * @uses BindSalePointToIdentifier_Request::setSalePointId()
     * @uses BindSalePointToIdentifier_Request::setSalePointIdentifier()
     * @uses BindSalePointToIdentifier_Request::setUpdateConnectionProperties()
     * @param bool $isRoaming
     * @param string $salePointId
     * @param string $salePointIdentifier
     * @param bool $updateConnectionProperties
     */
    public function __construct($isRoaming = null, $salePointId = null, $salePointIdentifier = null, $updateConnectionProperties = null)
    {
        $this
            ->setIsRoaming($isRoaming)
            ->setSalePointId($salePointId)
            ->setSalePointIdentifier($salePointIdentifier)
            ->setUpdateConnectionProperties($updateConnectionProperties);
    }
    /**
     * Get IsRoaming value
     * @return bool|null
     */
    public function getIsRoaming()
    {
        return $this->IsRoaming;
    }
    /**
     * Set IsRoaming value
     * @param bool $isRoaming
     * @return \patest\StructType\BindSalePointToIdentifier_Request
     */
    public function setIsRoaming($isRoaming = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRoaming) && !is_bool($isRoaming)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isRoaming, true), gettype($isRoaming)), __LINE__);
        }
        $this->IsRoaming = $isRoaming;
        return $this;
    }
    /**
     * Get SalePointId value
     * @return string|null
     */
    public function getSalePointId()
    {
        return $this->SalePointId;
    }
    /**
     * Set SalePointId value
     * @param string $salePointId
     * @return \patest\StructType\BindSalePointToIdentifier_Request
     */
    public function setSalePointId($salePointId = null)
    {
        // validation for constraint: string
        if (!is_null($salePointId) && !is_string($salePointId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salePointId, true), gettype($salePointId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($salePointId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $salePointId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($salePointId, true)), __LINE__);
        }
        $this->SalePointId = $salePointId;
        return $this;
    }
    /**
     * Get SalePointIdentifier value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSalePointIdentifier()
    {
        return isset($this->SalePointIdentifier) ? $this->SalePointIdentifier : null;
    }
    /**
     * Set SalePointIdentifier value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $salePointIdentifier
     * @return \patest\StructType\BindSalePointToIdentifier_Request
     */
    public function setSalePointIdentifier($salePointIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($salePointIdentifier) && !is_string($salePointIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salePointIdentifier, true), gettype($salePointIdentifier)), __LINE__);
        }
        if (is_null($salePointIdentifier) || (is_array($salePointIdentifier) && empty($salePointIdentifier))) {
            unset($this->SalePointIdentifier);
        } else {
            $this->SalePointIdentifier = $salePointIdentifier;
        }
        return $this;
    }
    /**
     * Get UpdateConnectionProperties value
     * @return bool|null
     */
    public function getUpdateConnectionProperties()
    {
        return $this->UpdateConnectionProperties;
    }
    /**
     * Set UpdateConnectionProperties value
     * @param bool $updateConnectionProperties
     * @return \patest\StructType\BindSalePointToIdentifier_Request
     */
    public function setUpdateConnectionProperties($updateConnectionProperties = null)
    {
        // validation for constraint: boolean
        if (!is_null($updateConnectionProperties) && !is_bool($updateConnectionProperties)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($updateConnectionProperties, true), gettype($updateConnectionProperties)), __LINE__);
        }
        $this->UpdateConnectionProperties = $updateConnectionProperties;
        return $this;
    }
}
