<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BasketItemAccessControlData StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:BasketItemAccessControlData
 * @subpackage Structs
 */
class BasketItemAccessControlData extends AbstractStructBase
{
    /**
     * The AccessCard
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\BasketItemAccessCardData
     */
    public $AccessCard;
    /**
     * The AccessControlSystemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccessControlSystemId;
    /**
     * The CanChangeAccessCard
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $CanChangeAccessCard;
    /**
     * The CanLoadOnAccessCard
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $CanLoadOnAccessCard;
    /**
     * The ItemId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ItemId;
    /**
     * The MustLoadOnAccessCard
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $MustLoadOnAccessCard;
    /**
     * Constructor method for BasketItemAccessControlData
     * @uses BasketItemAccessControlData::setAccessCard()
     * @uses BasketItemAccessControlData::setAccessControlSystemId()
     * @uses BasketItemAccessControlData::setCanChangeAccessCard()
     * @uses BasketItemAccessControlData::setCanLoadOnAccessCard()
     * @uses BasketItemAccessControlData::setItemId()
     * @uses BasketItemAccessControlData::setMustLoadOnAccessCard()
     * @param \patest\StructType\BasketItemAccessCardData $accessCard
     * @param string $accessControlSystemId
     * @param bool $canChangeAccessCard
     * @param bool $canLoadOnAccessCard
     * @param int $itemId
     * @param bool $mustLoadOnAccessCard
     */
    public function __construct(\patest\StructType\BasketItemAccessCardData $accessCard = null, $accessControlSystemId = null, $canChangeAccessCard = null, $canLoadOnAccessCard = null, $itemId = null, $mustLoadOnAccessCard = null)
    {
        $this
            ->setAccessCard($accessCard)
            ->setAccessControlSystemId($accessControlSystemId)
            ->setCanChangeAccessCard($canChangeAccessCard)
            ->setCanLoadOnAccessCard($canLoadOnAccessCard)
            ->setItemId($itemId)
            ->setMustLoadOnAccessCard($mustLoadOnAccessCard);
    }
    /**
     * Get AccessCard value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\BasketItemAccessCardData|null
     */
    public function getAccessCard()
    {
        return isset($this->AccessCard) ? $this->AccessCard : null;
    }
    /**
     * Set AccessCard value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\BasketItemAccessCardData $accessCard
     * @return \patest\StructType\BasketItemAccessControlData
     */
    public function setAccessCard(\patest\StructType\BasketItemAccessCardData $accessCard = null)
    {
        if (is_null($accessCard) || (is_array($accessCard) && empty($accessCard))) {
            unset($this->AccessCard);
        } else {
            $this->AccessCard = $accessCard;
        }
        return $this;
    }
    /**
     * Get AccessControlSystemId value
     * @return string|null
     */
    public function getAccessControlSystemId()
    {
        return $this->AccessControlSystemId;
    }
    /**
     * Set AccessControlSystemId value
     * @param string $accessControlSystemId
     * @return \patest\StructType\BasketItemAccessControlData
     */
    public function setAccessControlSystemId($accessControlSystemId = null)
    {
        // validation for constraint: string
        if (!is_null($accessControlSystemId) && !is_string($accessControlSystemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessControlSystemId, true), gettype($accessControlSystemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accessControlSystemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accessControlSystemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accessControlSystemId, true)), __LINE__);
        }
        $this->AccessControlSystemId = $accessControlSystemId;
        return $this;
    }
    /**
     * Get CanChangeAccessCard value
     * @return bool|null
     */
    public function getCanChangeAccessCard()
    {
        return $this->CanChangeAccessCard;
    }
    /**
     * Set CanChangeAccessCard value
     * @param bool $canChangeAccessCard
     * @return \patest\StructType\BasketItemAccessControlData
     */
    public function setCanChangeAccessCard($canChangeAccessCard = null)
    {
        // validation for constraint: boolean
        if (!is_null($canChangeAccessCard) && !is_bool($canChangeAccessCard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canChangeAccessCard, true), gettype($canChangeAccessCard)), __LINE__);
        }
        $this->CanChangeAccessCard = $canChangeAccessCard;
        return $this;
    }
    /**
     * Get CanLoadOnAccessCard value
     * @return bool|null
     */
    public function getCanLoadOnAccessCard()
    {
        return $this->CanLoadOnAccessCard;
    }
    /**
     * Set CanLoadOnAccessCard value
     * @param bool $canLoadOnAccessCard
     * @return \patest\StructType\BasketItemAccessControlData
     */
    public function setCanLoadOnAccessCard($canLoadOnAccessCard = null)
    {
        // validation for constraint: boolean
        if (!is_null($canLoadOnAccessCard) && !is_bool($canLoadOnAccessCard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canLoadOnAccessCard, true), gettype($canLoadOnAccessCard)), __LINE__);
        }
        $this->CanLoadOnAccessCard = $canLoadOnAccessCard;
        return $this;
    }
    /**
     * Get ItemId value
     * @return int|null
     */
    public function getItemId()
    {
        return $this->ItemId;
    }
    /**
     * Set ItemId value
     * @param int $itemId
     * @return \patest\StructType\BasketItemAccessControlData
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: int
        if (!is_null($itemId) && !(is_int($itemId) || ctype_digit($itemId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemId, true), gettype($itemId)), __LINE__);
        }
        $this->ItemId = $itemId;
        return $this;
    }
    /**
     * Get MustLoadOnAccessCard value
     * @return bool|null
     */
    public function getMustLoadOnAccessCard()
    {
        return $this->MustLoadOnAccessCard;
    }
    /**
     * Set MustLoadOnAccessCard value
     * @param bool $mustLoadOnAccessCard
     * @return \patest\StructType\BasketItemAccessControlData
     */
    public function setMustLoadOnAccessCard($mustLoadOnAccessCard = null)
    {
        // validation for constraint: boolean
        if (!is_null($mustLoadOnAccessCard) && !is_bool($mustLoadOnAccessCard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mustLoadOnAccessCard, true), gettype($mustLoadOnAccessCard)), __LINE__);
        }
        $this->MustLoadOnAccessCard = $mustLoadOnAccessCard;
        return $this;
    }
}
