<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BasePriceListCell StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:BasePriceListCell
 * @subpackage Structs
 */
class BasePriceListCell extends AbstractStructBase
{
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \patest\StructType\Money
     */
    public $Price;
    /**
     * The PriceLevelId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceLevelId;
    /**
     * Constructor method for BasePriceListCell
     * @uses BasePriceListCell::setPrice()
     * @uses BasePriceListCell::setPriceLevelId()
     * @param \patest\StructType\Money $price
     * @param string $priceLevelId
     */
    public function __construct(\patest\StructType\Money $price = null, $priceLevelId = null)
    {
        $this
            ->setPrice($price)
            ->setPriceLevelId($priceLevelId);
    }
    /**
     * Get Price value
     * @return \patest\StructType\Money|null
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param \patest\StructType\Money $price
     * @return \patest\StructType\BasePriceListCell
     */
    public function setPrice(\patest\StructType\Money $price = null)
    {
        $this->Price = $price;
        return $this;
    }
    /**
     * Get PriceLevelId value
     * @return string|null
     */
    public function getPriceLevelId()
    {
        return $this->PriceLevelId;
    }
    /**
     * Set PriceLevelId value
     * @param string $priceLevelId
     * @return \patest\StructType\BasePriceListCell
     */
    public function setPriceLevelId($priceLevelId = null)
    {
        // validation for constraint: string
        if (!is_null($priceLevelId) && !is_string($priceLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceLevelId, true), gettype($priceLevelId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceLevelId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceLevelId, true)), __LINE__);
        }
        $this->PriceLevelId = $priceLevelId;
        return $this;
    }
}
