<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for bSRO.Sales.ShiftStarting StructType
 * @subpackage Structs
 */
class BSRO_Sales_ShiftStarting extends AnyEntity
{
    /**
     * The StartingAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $StartingAmount;
    /**
     * Constructor method for bSRO.Sales.ShiftStarting
     * @uses BSRO_Sales_ShiftStarting::setStartingAmount()
     * @param float $startingAmount
     */
    public function __construct($startingAmount = null)
    {
        $this
            ->setStartingAmount($startingAmount);
    }
    /**
     * Get StartingAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getStartingAmount()
    {
        return isset($this->StartingAmount) ? $this->StartingAmount : null;
    }
    /**
     * Set StartingAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $startingAmount
     * @return \patest\StructType\BSRO_Sales_ShiftStarting
     */
    public function setStartingAmount($startingAmount = null)
    {
        // validation for constraint: float
        if (!is_null($startingAmount) && !(is_float($startingAmount) || is_numeric($startingAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($startingAmount, true), gettype($startingAmount)), __LINE__);
        }
        if (is_null($startingAmount) || (is_array($startingAmount) && empty($startingAmount))) {
            unset($this->StartingAmount);
        } else {
            $this->StartingAmount = $startingAmount;
        }
        return $this;
    }
}
