<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for bSRO.Sales.ItemReturnReason StructType
 * @subpackage Structs
 */
class BSRO_Sales_ItemReturnReason extends AnyEntity
{
    /**
     * The ItemReturnReasonId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ItemReturnReasonId;
    /**
     * Constructor method for bSRO.Sales.ItemReturnReason
     * @uses BSRO_Sales_ItemReturnReason::setItemReturnReasonId()
     * @param string $itemReturnReasonId
     */
    public function __construct($itemReturnReasonId = null)
    {
        $this
            ->setItemReturnReasonId($itemReturnReasonId);
    }
    /**
     * Get ItemReturnReasonId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getItemReturnReasonId()
    {
        return isset($this->ItemReturnReasonId) ? $this->ItemReturnReasonId : null;
    }
    /**
     * Set ItemReturnReasonId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $itemReturnReasonId
     * @return \patest\StructType\BSRO_Sales_ItemReturnReason
     */
    public function setItemReturnReasonId($itemReturnReasonId = null)
    {
        // validation for constraint: string
        if (!is_null($itemReturnReasonId) && !is_string($itemReturnReasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemReturnReasonId, true), gettype($itemReturnReasonId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($itemReturnReasonId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $itemReturnReasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($itemReturnReasonId, true)), __LINE__);
        }
        if (is_null($itemReturnReasonId) || (is_array($itemReturnReasonId) && empty($itemReturnReasonId))) {
            unset($this->ItemReturnReasonId);
        } else {
            $this->ItemReturnReasonId = $itemReturnReasonId;
        }
        return $this;
    }
}
